/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustServiceCondition;
import java.util.List;
import java.util.stream.Stream;

class TrustServiceUsageConsistency
implements TrustServiceCondition {
    @Override
    public boolean isConsistent(TrustServiceWrapper trustService) {
        List<String> capturedQualifiers = trustService.getCapturedQualifierUris();
        boolean qcForEsig = ServiceQualification.isQcForEsig(capturedQualifiers);
        boolean qcForEseal = ServiceQualification.isQcForEseal(capturedQualifiers);
        boolean qcForWSA = ServiceQualification.isQcForWSA(capturedQualifiers);
        boolean noneOfThem = !qcForEsig && !qcForEseal && !qcForWSA;
        boolean onlyOneOfThem = Stream.of(qcForEsig, qcForEseal, qcForWSA).filter(b -> b).count() == 1L;
        return noneOfThem || onlyOneOfThem;
    }
}

