/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Collections;
import java.util.List;

public class LongTermValidationCheck
extends ChainItem<XmlValidationProcessArchivalData> {
    private final XmlConstraintsConclusion longTermValidationResult;
    private Indication ltvIndication;
    private SubIndication ltvSubIndication;

    public LongTermValidationCheck(I18nProvider i18nProvider, XmlValidationProcessArchivalData result, XmlConstraintsConclusion longTermValidationResult, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.longTermValidationResult = longTermValidationResult;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.LTV;
    }

    @Override
    protected boolean process() {
        if (this.longTermValidationResult != null && this.longTermValidationResult.getConclusion() != null) {
            this.ltvIndication = this.longTermValidationResult.getConclusion().getIndication();
            this.ltvSubIndication = this.longTermValidationResult.getConclusion().getSubIndication();
            return ValidationProcessUtils.isAllowedValidationWithLongTermData(this.longTermValidationResult.getConclusion());
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ARCH_LTVV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ARCH_LTVV_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.ltvIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.ltvSubIndication;
    }

    @Override
    protected List<XmlMessage> getPreviousErrors() {
        if (this.longTermValidationResult != null && this.longTermValidationResult.getConclusion() != null) {
            return this.longTermValidationResult.getConclusion().getErrors();
        }
        return Collections.emptyList();
    }
}

