/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.TokenCertificateChainAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.AlgorithmObsolescenceValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.checks.SuccessfulValidationTimeSlidingFoundCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.checks.ValidationTimeSlidingCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.ValidationTimeSliding;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PastCertificateValidation
extends Chain<XmlPCV> {
    private final TokenProxy token;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;
    private Date controlTime;

    public PastCertificateValidation(I18nProvider i18nProvider, TokenProxy token, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(i18nProvider, new XmlPCV());
        this.token = token;
        this.bbbs = bbbs;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.PAST_CERTIFICATE_VALIDATION;
    }

    @Override
    protected void initChain() {
        XmlVTS vts;
        ChainItem<XmlPCV> item = this.firstItem = this.prospectiveCertificateChain();
        CertificateWrapper trustedCertificate = null;
        ArrayList<XmlVTS> vtsList = new ArrayList<XmlVTS>();
        for (CertificateWrapper certificateWrapper : this.token.getCertificateChain()) {
            if (!certificateWrapper.isTrusted()) continue;
            trustedCertificate = certificateWrapper;
            XmlVTS vts2 = this.getVTSResult(trustedCertificate);
            vtsList.add(vts2);
            item = item.setNextItem(this.validationTimeSliding(vts2, trustedCertificate));
            if (!trustedCertificate.isSelfSigned() && trustedCertificate.getTrustSunsetDate() != null && trustedCertificate.isTrustedChain()) continue;
            break;
        }
        if ((vts = this.getBestValidationTimeSliding(vtsList)) != null) {
            XmlBasicBuildingBlocks bbb = this.bbbs.get(this.token.getId());
            bbb.setVTS(vts);
            if (this.isValid(vts)) {
                this.controlTime = vts.getControlTime();
            }
        }
        item = item.setNextItem(this.successfulValidationTimeSlidingFound(vts));
        if (this.controlTime != null) {
            item = item.setNextItem(this.cryptographicCheck((XmlPCV)this.result, this.controlTime));
        }
    }

    private ChainItem<XmlPCV> prospectiveCertificateChain() {
        LevelRule constraint = this.policy.getProspectiveCertificateChainConstraint(this.context);
        return new ProspectiveCertificateChainCheck(this.i18nProvider, (XmlPCV)this.result, this.token, constraint);
    }

    private XmlVTS getVTSResult(CertificateWrapper trustedCertificate) {
        ValidationTimeSliding validationTimeSliding = new ValidationTimeSliding(this.i18nProvider, this.token, trustedCertificate, this.currentTime, this.poe, this.bbbs, this.context, this.policy);
        return (XmlVTS)validationTimeSliding.execute();
    }

    private ChainItem<XmlPCV> validationTimeSliding(XmlVTS vts, CertificateWrapper trustedCertificate) {
        return new ValidationTimeSlidingCheck(this.i18nProvider, (XmlPCV)this.result, vts, this.token.getId(), trustedCertificate, this.getWarnLevelRule());
    }

    private ChainItem<XmlPCV> successfulValidationTimeSlidingFound(XmlVTS vts) {
        return new SuccessfulValidationTimeSlidingFoundCheck(this.i18nProvider, (XmlPCV)this.result, vts, this.getFailLevelRule());
    }

    private ChainItem<XmlPCV> cryptographicCheck(XmlPCV result, Date validationTime) {
        TokenCertificateChainAlgorithmObsolescenceValidation<TokenProxy> algorithmObsolescenceValidation = new TokenCertificateChainAlgorithmObsolescenceValidation<TokenProxy>(this.i18nProvider, this.token, this.context, validationTime, this.policy);
        XmlAOV aovResult = (XmlAOV)algorithmObsolescenceValidation.execute();
        MessageTag position = ValidationProcessUtils.getCertificateChainCryptoPosition(this.context);
        return new AlgorithmObsolescenceValidationCheck<XmlPCV>(this.i18nProvider, result, aovResult, validationTime, position, this.token.getId());
    }

    private XmlVTS getBestValidationTimeSliding(List<XmlVTS> vtsList) {
        if (Utils.isCollectionEmpty(vtsList)) {
            return null;
        }
        XmlVTS bestVTS = null;
        for (XmlVTS xmlVTS : vtsList) {
            if (bestVTS != null && (this.isValid(bestVTS) || !this.isValid(xmlVTS) && !bestVTS.getControlTime().before(xmlVTS.getControlTime())) && (!this.isValid(xmlVTS) || !bestVTS.getControlTime().before(xmlVTS.getControlTime()))) continue;
            bestVTS = xmlVTS;
        }
        return bestVTS;
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlPCV)this.result).setControlTime(this.controlTime);
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.VTS.equals((Object)constraint.getBlockType())) {
            super.collectMessages(conclusion, constraint);
        }
    }
}

