/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class ValidationTimeSlidingCheck
extends ChainItem<XmlPCV> {
    private final XmlVTS vts;
    private final CertificateWrapper trustedCertificate;

    public ValidationTimeSlidingCheck(I18nProvider i18nProvider, XmlPCV result, XmlVTS vts, String tokenId, CertificateWrapper trustedCertificate, LevelRule constraint) {
        super(i18nProvider, result, constraint, tokenId);
        this.vts = vts;
        this.trustedCertificate = trustedCertificate;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.VTS;
    }

    @Override
    protected boolean process() {
        return this.isValid(this.vts);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PCV_IVTSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PCV_IVTSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.vts.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.vts.getConclusion().getSubIndication();
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.vts.getControlTime() != null) {
            if (this.trustedCertificate != null) {
                return this.i18nProvider.getMessage(MessageTag.CONTROL_TIME_WITH_TRUST_ANCHOR, this.trustedCertificate.getId(), ValidationProcessUtils.getFormattedDate(this.vts.getControlTime()));
            }
            return this.i18nProvider.getMessage(MessageTag.CONTROL_TIME_ALONE, ValidationProcessUtils.getFormattedDate(this.vts.getControlTime()));
        }
        return null;
    }
}

