/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AbstractSignedAndTimestampedFilesCoveredCheck;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EvidenceRecordSignedAndTimestampedFilesCoveredCheck
extends AbstractSignedAndTimestampedFilesCoveredCheck<XmlValidationProcessEvidenceRecord> {
    private final EvidenceRecordWrapper evidenceRecordWrapper;

    public EvidenceRecordSignedAndTimestampedFilesCoveredCheck(I18nProvider i18nProvider, XmlValidationProcessEvidenceRecord result, DiagnosticData diagnosticData, EvidenceRecordWrapper evidenceRecordWrapper, LevelRule constraint) {
        super(i18nProvider, result, diagnosticData, evidenceRecordWrapper.getFilename(), constraint);
        this.evidenceRecordWrapper = evidenceRecordWrapper;
    }

    @Override
    protected boolean process() {
        if (!super.process()) {
            return false;
        }
        List<String> coveredDocumentEntries = this.getCoveredDocumentEntries();
        return this.checkManifestFilesCovered(coveredDocumentEntries);
    }

    private List<String> getCoveredDocumentEntries() {
        List<String> result = this.evidenceRecordWrapper.getDigestMatchers().stream().map(XmlDigestMatcher::getDocumentName).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.evidenceRecordWrapper.isEmbedded() && this.evidenceRecordWrapper.getParent() != null && this.evidenceRecordWrapper.getParent().getFilename() != null) {
            result.add(this.evidenceRecordWrapper.getParent().getFilename());
        }
        return result;
    }
}

