/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftspwatsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.TimestampAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.AlgorithmObsolescenceValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.EvidenceRecordValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import eu.europa.esig.dss.validation.process.vpftsp.checks.BasicTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpftspwatsp.checks.AcceptableBasicTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpftspwatsp.checks.PastTimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpftspwatsp.checks.TimestampDigestAlgorithmValidationCheck;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationProcessForTimestampsWithArchivalData
extends Chain<XmlValidationProcessArchivalDataTimestamp> {
    private final XmlValidationProcessBasicTimestamp vpftsp;
    private final TimestampWrapper timestamp;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final Map<String, XmlEvidenceRecord> evidenceRecordValidations;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final POEExtraction poe;

    public ValidationProcessForTimestampsWithArchivalData(I18nProvider i18nProvider, TimestampWrapper timestamp, XmlValidationProcessBasicTimestamp vpftsp, Map<String, XmlBasicBuildingBlocks> bbbs, Map<String, XmlEvidenceRecord> evidenceRecordValidations, Date currentTime, ValidationPolicy policy, POEExtraction poe) {
        super(i18nProvider, new XmlValidationProcessArchivalDataTimestamp());
        this.vpftsp = vpftsp;
        this.timestamp = timestamp;
        this.bbbs = bbbs;
        this.evidenceRecordValidations = evidenceRecordValidations;
        this.currentTime = currentTime;
        this.policy = policy;
        this.poe = poe;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPFTSPWATSP;
    }

    @Override
    protected void initChain() {
        XmlProofOfExistence lowestPOE = this.getLowestPOE();
        Date lowestPOETime = lowestPOE.getTime();
        ((XmlValidationProcessArchivalDataTimestamp)this.result).setProofOfExistence(lowestPOE);
        XmlConclusion basicTimestampConclusion = this.vpftsp.getConclusion();
        ChainItem<XmlValidationProcessArchivalDataTimestamp> item = null;
        List<EvidenceRecordWrapper> evidenceRecords = this.timestamp.getEvidenceRecords();
        if (Utils.isCollectionNotEmpty(evidenceRecords)) {
            for (EvidenceRecordWrapper evidenceRecord : evidenceRecords) {
                XmlValidationProcessEvidenceRecord evidenceRecordValidation = this.getEvidenceRecordValidation(evidenceRecord);
                if (evidenceRecordValidation == null) continue;
                ChainItem<XmlValidationProcessArchivalDataTimestamp> evidenceRecordValidationConclusive = this.evidenceRecordValidationConclusive(evidenceRecord, evidenceRecordValidation);
                if (item == null) {
                    this.firstItem = evidenceRecordValidationConclusive;
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(evidenceRecordValidationConclusive);
                }
                if (!this.isValid(evidenceRecordValidation)) continue;
                this.poe.extractPOE(evidenceRecord);
            }
        }
        ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampBasicSignatureValidationAcceptable = this.timestampBasicSignatureValidationAcceptable(this.vpftsp);
        if (item == null) {
            this.firstItem = timestampBasicSignatureValidationAcceptable;
            item = this.firstItem;
        } else {
            item = item.setNextItem(timestampBasicSignatureValidationAcceptable);
        }
        if (ValidationProcessUtils.isAllowedBasicTimestampValidation(basicTimestampConclusion)) {
            item = item.setNextItem(this.timestampBasicSignatureValidationConclusive(this.timestamp, this.vpftsp));
            if (this.isValid(this.vpftsp)) {
                XmlAOV aovResult = this.getBasicTimestampAlgorithmObsolescenceValidation(this.timestamp);
                XmlCryptographicValidation digestMatchersValidation = aovResult.getDigestMatchersValidation();
                item = item.setNextItem(this.timestampDigestAlgorithm(this.timestamp, digestMatchersValidation, lowestPOETime));
            } else if (ValidationProcessUtils.isAllowedBasicTimestampValidation(basicTimestampConclusion)) {
                PastSignatureValidation psv = new PastSignatureValidation(this.i18nProvider, this.timestamp, this.bbbs, basicTimestampConclusion, this.poe, this.currentTime, this.policy, Context.TIMESTAMP);
                XmlPSV psvResult = (XmlPSV)psv.execute();
                XmlBasicBuildingBlocks tstBBB = this.bbbs.get(this.timestamp.getId());
                this.enrichBBBWithPSVConclusion(tstBBB, psvResult);
                item = item.setNextItem(this.pastTimestampValidation(this.timestamp, psvResult));
                if (this.isValid(psvResult)) {
                    TimestampAlgorithmObsolescenceValidation algorithmObsolescenceValidation = new TimestampAlgorithmObsolescenceValidation(this.i18nProvider, this.timestamp, lowestPOETime, this.policy);
                    XmlAOV aovResult = (XmlAOV)algorithmObsolescenceValidation.execute();
                    item = item.setNextItem(this.timestampIsAcceptable(aovResult, lowestPOETime));
                    XmlCryptographicValidation digestMatchersValidation = aovResult.getDigestMatchersValidation();
                    item = item.setNextItem(this.timestampDigestAlgorithm(this.timestamp, digestMatchersValidation, lowestPOETime));
                }
            }
        }
    }

    private XmlProofOfExistence getLowestPOE() {
        POE lowestPOE = this.poe.getLowestPOE(this.timestamp.getId());
        XmlProofOfExistence xmlProofOfExistence = new XmlProofOfExistence();
        xmlProofOfExistence.setTime(lowestPOE.getTime());
        return xmlProofOfExistence;
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampBasicSignatureValidationAcceptable(XmlValidationProcessBasicTimestamp timestampValidationResult) {
        return new AcceptableBasicTimestampValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestampValidationResult, this.getFailLevelRule());
    }

    private void enrichBBBWithPSVConclusion(XmlBasicBuildingBlocks bbb, XmlPSV psv) {
        bbb.setPSV(psv);
        XmlConclusion bbbConclusion = bbb.getConclusion();
        XmlConclusion psvConclusion = psv.getConclusion();
        bbbConclusion.setIndication(psvConclusion.getIndication());
        bbbConclusion.setSubIndication(psvConclusion.getSubIndication());
        bbbConclusion.getErrors().addAll(psvConclusion.getErrors());
        bbbConclusion.getWarnings().addAll(psvConclusion.getWarnings());
        bbbConclusion.getInfos().addAll(psvConclusion.getInfos());
    }

    private XmlValidationProcessEvidenceRecord getEvidenceRecordValidation(EvidenceRecordWrapper evidenceRecord) {
        XmlEvidenceRecord xmlEvidenceRecord = this.evidenceRecordValidations.get(evidenceRecord.getId());
        return xmlEvidenceRecord.getValidationProcessEvidenceRecord();
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> evidenceRecordValidationConclusive(EvidenceRecordWrapper evidenceRecordWrapper, XmlValidationProcessEvidenceRecord erValidationResult) {
        return new EvidenceRecordValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, evidenceRecordWrapper, erValidationResult, this.getEvidenceRecordValidationConstraintLevel());
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampBasicSignatureValidationConclusive(TimestampWrapper timestampWrapper, XmlValidationProcessBasicTimestamp timestampValidationResult) {
        return new BasicTimestampValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestampWrapper, timestampValidationResult, this.getWarnLevelRule());
    }

    private XmlAOV getBasicTimestampAlgorithmObsolescenceValidation(TimestampWrapper newestTimestamp) {
        return this.bbbs.get(newestTimestamp.getId()).getAOV();
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> pastTimestampValidation(TimestampWrapper timestamp, XmlPSV xmlPSV) {
        return new PastTimestampValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestamp, xmlPSV, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampDigestAlgorithm(TimestampWrapper timestampWrapper, XmlCryptographicValidation cvResult, Date poeTime) {
        return new TimestampDigestAlgorithmValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, timestampWrapper, cvResult, poeTime, this.getWarnLevelRule());
    }

    private ChainItem<XmlValidationProcessArchivalDataTimestamp> timestampIsAcceptable(XmlAOV aovResult, Date lowestPOE) {
        MessageTag position = ValidationProcessUtils.getCryptoPosition(Context.TIMESTAMP);
        return new AlgorithmObsolescenceValidationCheck<XmlValidationProcessArchivalDataTimestamp>(this.i18nProvider, (XmlValidationProcessArchivalDataTimestamp)this.result, aovResult, lowestPOE, position, this.timestamp.getId());
    }

    private LevelRule getEvidenceRecordValidationConstraintLevel() {
        LevelRule constraint = this.policy.getEvidenceRecordValidConstraint();
        if (constraint == null) {
            constraint = this.getWarnLevelRule();
        }
        return constraint;
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (!XmlBlockType.TST_BBB.equals((Object)constraint.getBlockType()) && !XmlBlockType.TST_PSV.equals((Object)constraint.getBlockType()) || this.policy.getTimestampValidConstraint() != null) {
            super.collectMessages(conclusion, constraint);
        }
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        if (!ValidationProcessUtils.isAllowedBasicTimestampValidation(this.vpftsp.getConclusion())) {
            conclusion.getWarnings().addAll(this.vpftsp.getConclusion().getWarnings());
            conclusion.getInfos().addAll(this.vpftsp.getConclusion().getInfos());
        }
    }
}

