/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESService;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESService;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureProfile;
import eu.europa.esig.dss.enumerations.TimestampContainerForm;
import eu.europa.esig.dss.extension.SignedDocumentExtender;
import eu.europa.esig.dss.jades.signature.JAdESService;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteMultipleDocumentsSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMultipleDocumentsSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteMultipleDocumentsSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMultipleDocumentsSignatureServiceImpl.class);
    private XAdESService xadesService;
    private JAdESService jadesService;
    private ASiCWithXAdESService asicWithXAdESService;
    private ASiCWithCAdESService asicWithCAdESService;

    public void setXadesService(XAdESService xadesService) {
        this.xadesService = xadesService;
    }

    public void setJadesService(JAdESService jadesService) {
        this.jadesService = jadesService;
    }

    public void setAsicWithXAdESService(ASiCWithXAdESService asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    public void setAsicWithCAdESService(ASiCWithCAdESService asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    private MultipleDocumentsSignatureService getServiceForSignature(SignatureForm signatureForm, ASiCContainerType asicContainerType) {
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new UnsupportedOperationException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + (Object)((Object)signatureForm));
        }
        switch (signatureForm) {
            case XAdES: {
                return this.xadesService;
            }
            case JAdES: {
                return this.jadesService;
            }
        }
        throw new UnsupportedOperationException("Unrecognized format (only XAdES and JAdES are allowed for multiple documents signing) : " + (Object)((Object)signatureForm));
    }

    private MultipleDocumentsSignatureService getServiceForTimestamp(TimestampContainerForm timestampContainerForm) {
        Objects.requireNonNull(timestampContainerForm, "The timestampContainerForm must be defined!");
        switch (timestampContainerForm) {
            case ASiC_E: 
            case ASiC_S: {
                return this.asicWithCAdESService;
            }
        }
        throw new UnsupportedOperationException(String.format("The format '%s' is not recognized or not allowed (only ASiC-E and ASiC-S are allowed for a multiple document timestamping)!", timestampContainerForm.getReadable()));
    }

    @Override
    public ToBeSignedDTO getDataToSign(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("GetDataToSign in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toSignDocuments);
        ToBeSigned dataToSign = service.getDataToSign(dssDocuments, parameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO(dataToSign);
    }

    @Override
    public RemoteDocument signDocument(List<RemoteDocument> toSignDocuments, RemoteSignatureParameters remoteParameters, SignatureValueDTO signatureValueDTO) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("SignDocument in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toSignDocuments);
        DSSDocument signDocument = service.signDocument(dssDocuments, parameters, this.toSignatureValue(signatureValueDTO));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(signDocument);
    }

    @Override
    @Deprecated
    public RemoteDocument extendDocument(RemoteDocument toExtendDocument, RemoteSignatureParameters remoteParameters) {
        return this.extendDocument(toExtendDocument, null, remoteParameters);
    }

    @Override
    public RemoteDocument extendDocument(RemoteDocument remoteDocument, SignatureProfile signatureProfile, RemoteSignatureParameters remoteParameters) throws DSSException {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        if (signatureProfile == null && (remoteParameters == null || remoteParameters.getSignatureLevel() == null)) {
            throw new NullPointerException("One of the signatureProfile or remoteParameters.signatureLevel must be defined!");
        }
        LOG.info("ExtendDocument in process...");
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        SignedDocumentExtender documentExtender = SignedDocumentExtender.fromDocument(dssDocument);
        documentExtender.setServices(this.xadesService, this.jadesService, this.asicWithXAdESService, this.asicWithCAdESService);
        SignatureForm signatureForm = documentExtender.getSignatureForm();
        SerializableSignatureParameters signatureParameters = remoteParameters == null ? null : (documentExtender.isASiC() ? this.getASiCSignatureParameters(null, signatureForm) : this.getSignatureParameters(signatureForm, remoteParameters));
        this.fillParameters(signatureParameters, remoteParameters, signatureForm);
        if (signatureProfile == null) {
            signatureProfile = remoteParameters.getSignatureLevel().getSignatureProfile();
        }
        DSSDocument extendDocument = documentExtender.extendDocument(signatureProfile, signatureParameters);
        LOG.info("ExtendDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(extendDocument);
    }

    @Override
    public RemoteDocument timestamp(List<RemoteDocument> toTimestampDocuments, RemoteTimestampParameters remoteParameters) {
        Objects.requireNonNull(toTimestampDocuments, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getTimestampContainerForm(), "timestampContainerForm must be defined!");
        LOG.info("Timestamp document in process...");
        TimestampParameters parameters = this.toTimestampParameters(remoteParameters);
        MultipleDocumentsSignatureService service = this.getServiceForTimestamp(remoteParameters.getTimestampContainerForm());
        List<DSSDocument> dssDocuments = RemoteDocumentConverter.toDSSDocuments(toTimestampDocuments);
        DSSDocument timestampedDocument = service.timestamp(dssDocuments, parameters);
        LOG.info("Timestamp document is finished");
        return RemoteDocumentConverter.toRemoteDocument(timestampedDocument);
    }
}

