/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.validation.common;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.policy.ValidationPolicyLoader;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.exception.DSSRemoteServiceException;
import eu.europa.esig.dss.ws.validation.dto.DataToValidateDTO;
import eu.europa.esig.dss.ws.validation.dto.WSReportsDTO;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDocumentValidationService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDocumentValidationService.class);
    private CertificateVerifier verifier;
    private ValidationPolicy defaultValidationPolicy;

    public void setVerifier(CertificateVerifier verifier) {
        this.verifier = verifier;
    }

    public void setDefaultValidationPolicy(InputStream validationPolicy) {
        this.setDefaultValidationPolicy(validationPolicy, null);
    }

    public void setDefaultValidationPolicy(InputStream validationPolicy, InputStream cryptographicSuite) {
        ValidationPolicyLoader validationPolicyLoader;
        try {
            validationPolicyLoader = validationPolicy != null ? ValidationPolicyLoader.fromValidationPolicy(validationPolicy) : ValidationPolicyLoader.fromDefaultValidationPolicy();
        }
        catch (Exception e) {
            throw new DSSRemoteServiceException(String.format("Unable to instantiate validation policy: %s", e.getMessage()), e);
        }
        try {
            if (cryptographicSuite != null) {
                validationPolicyLoader = validationPolicyLoader.withCryptographicSuite(cryptographicSuite);
            }
        }
        catch (Exception e) {
            throw new DSSRemoteServiceException(String.format("Unable to instantiate cryptographic suite: %s", e.getMessage()), e);
        }
        this.defaultValidationPolicy = validationPolicyLoader.create();
    }

    public void setDefaultValidationPolicy(ValidationPolicy validationPolicy) {
        this.defaultValidationPolicy = validationPolicy;
    }

    public WSReportsDTO validateDocument(DataToValidateDTO dataToValidate) {
        LOG.info("ValidateDocument in process...");
        SignedDocumentValidator validator = this.initValidator(dataToValidate);
        RemoteDocument policy = dataToValidate.getPolicy();
        ValidationPolicyLoader validationPolicyLoader = policy != null ? ValidationPolicyLoader.fromValidationPolicy(RemoteDocumentConverter.toDSSDocument(policy)) : (this.defaultValidationPolicy != null ? ValidationPolicyLoader.fromValidationPolicy(this.defaultValidationPolicy) : ValidationPolicyLoader.fromDefaultValidationPolicy());
        RemoteDocument cryptographicSuite = dataToValidate.getCryptographicSuite();
        if (cryptographicSuite != null) {
            validationPolicyLoader.withCryptographicSuite(RemoteDocumentConverter.toDSSDocument(cryptographicSuite));
        }
        ValidationPolicy validationPolicy = validationPolicyLoader.create();
        Reports reports = validator.validateDocument(validationPolicy);
        WSReportsDTO reportsDTO = new WSReportsDTO(reports.getDiagnosticDataJaxb(), reports.getSimpleReportJaxb(), reports.getDetailedReportJaxb(), reports.getEtsiValidationReportJaxb());
        LOG.info("ValidateDocument is finished");
        return reportsDTO;
    }

    public List<RemoteDocument> getOriginalDocuments(DataToValidateDTO dataToValidate) {
        List<AdvancedSignature> signatures;
        LOG.info("GetOriginalDocuments in process...");
        SignedDocumentValidator validator = this.initValidator(dataToValidate);
        String signatureId = dataToValidate.getSignatureId();
        if (signatureId == null && !(signatures = validator.getSignatures()).isEmpty()) {
            LOG.debug("SignatureId is not defined, the first signature is used");
            signatureId = signatures.get(0).getId();
        }
        List<DSSDocument> originalDocuments = validator.getOriginalDocuments(signatureId);
        List<RemoteDocument> remoteDocuments = RemoteDocumentConverter.toRemoteDocuments(originalDocuments);
        LOG.info("GetOriginalDocuments is finished");
        return remoteDocuments;
    }

    protected SignedDocumentValidator initValidator(DataToValidateDTO dataToValidate) {
        DSSDocument signedDocument = RemoteDocumentConverter.toDSSDocument(dataToValidate.getSignedDocument());
        SignedDocumentValidator signedDocValidator = SignedDocumentValidator.fromDocument(signedDocument);
        if (dataToValidate.getValidationTime() != null) {
            signedDocValidator.setValidationTime(dataToValidate.getValidationTime());
        }
        if (Utils.isCollectionNotEmpty(dataToValidate.getOriginalDocuments())) {
            signedDocValidator.setDetachedContents(RemoteDocumentConverter.toDSSDocuments(dataToValidate.getOriginalDocuments()));
        }
        if (Utils.isCollectionNotEmpty(dataToValidate.getEvidenceRecords())) {
            signedDocValidator.setDetachedEvidenceRecordDocuments(RemoteDocumentConverter.toDSSDocuments(dataToValidate.getEvidenceRecords()));
        }
        signedDocValidator.setCertificateVerifier(this.verifier);
        if (dataToValidate.getTokenExtractionStrategy() != null) {
            signedDocValidator.setTokenExtractionStrategy(dataToValidate.getTokenExtractionStrategy());
        }
        return signedDocValidator;
    }
}

