/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.extension;

import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.extension.AbstractDocumentExtender;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzerFactory;
import java.util.Objects;

public class XAdESDocumentExtender
extends AbstractDocumentExtender<XAdESSignatureParameters, XAdESTimestampParameters> {
    XAdESDocumentExtender() {
    }

    public XAdESDocumentExtender(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be extended cannot be null!");
        this.document = document;
    }

    @Override
    protected DocumentSignatureService<XAdESSignatureParameters, XAdESTimestampParameters> createSignatureService() {
        Objects.requireNonNull(this.certificateVerifier, "Please provide CertificateVerifier or corresponding XAdESService!");
        XAdESService service = new XAdESService(this.certificateVerifier);
        service.setTspSource(this.tspSource);
        return service;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return new XMLDocumentAnalyzerFactory().isSupported(dssDocument);
    }

    @Override
    protected XAdESSignatureParameters emptySignatureParameters() {
        return new XAdESSignatureParameters();
    }

    @Override
    protected boolean isSupportedParameters(SerializableSignatureParameters parameters) {
        return parameters instanceof XAdESSignatureParameters;
    }

    @Override
    protected boolean isSupportedService(DocumentSignatureService<?, ?> service) {
        return service instanceof XAdESService;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.XAdES;
    }
}

