/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.xades.reference.ComplexTransform;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathTransform
extends ComplexTransform {
    private static final long serialVersionUID = 4223069758436340714L;
    protected final String xPathExpression;

    public XPathTransform(String xPathExpression) {
        this(XMLDSigNamespace.NS, "http://www.w3.org/TR/1999/REC-xpath-19991116", xPathExpression);
    }

    public XPathTransform(DSSNamespace xmlDSigNamespace, String xPathExpression) {
        this(xmlDSigNamespace, "http://www.w3.org/TR/1999/REC-xpath-19991116", xPathExpression);
    }

    protected XPathTransform(DSSNamespace xmlDSigNamespace, String algorithm, String xPathExpression) {
        super(xmlDSigNamespace, algorithm);
        Objects.requireNonNull(xPathExpression, "xPathExpression cannot be null!");
        this.xPathExpression = xPathExpression;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transform = super.createTransform(document, parentNode);
        return DomUtils.addTextElement(document, transform, this.namespace, XMLDSigElement.XPATH, this.xPathExpression);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.xPathExpression == null ? 0 : this.xPathExpression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathTransform other = (XPathTransform)obj;
        return Objects.equals(this.xPathExpression, other.xPathExpression);
    }

    @Override
    public String toString() {
        return "XPathTransform [xPathExpression=" + this.xPathExpression + ", algorithm=" + this.algorithm + ", namespace=" + this.namespace + "]";
    }
}

