/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XPathPlacementSignatureBuilder
extends XAdESSignatureBuilder {
    protected XPathPlacementSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        super(params, document, certificateVerifier);
    }

    protected XPathPlacementSignatureBuilder(XAdESSignatureParameters params, List<DSSDocument> documents, CertificateVerifier certificateVerifier) {
        super(params, documents, certificateVerifier);
    }

    protected void assertOriginalXmlDocumentValid() {
        if (Utils.collectionSize(this.documents) > 1) {
            throw new IllegalArgumentException(String.format("Only one original document is allowed for '%s' signature packaging!", new Object[]{this.params.getSignaturePackaging()}));
        }
        if (!DomUtils.isDOM((DSSDocument)this.documents.get(0))) {
            throw new IllegalInputException("Enveloped signature cannot be created. Reason : the provided document is not XML!");
        }
        this.initRootDocumentDom();
        NodeList signatureNodeList = DSSXMLUtils.getAllSignaturesExceptCounterSignatures(this.documentDom);
        if (signatureNodeList == null || signatureNodeList.getLength() == 0) {
            return;
        }
        Node parentSignatureNode = this.getParentNodeOfSignature();
        Set<Node> parentNodes = this.getParentNodesChain(parentSignatureNode);
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Node signatureNode = signatureNodeList.item(ii);
            NodeList referenceNodeList = DSSXMLUtils.getReferenceNodeList(signatureNode);
            if (referenceNodeList == null || referenceNodeList.getLength() == 0) continue;
            for (int jj = 0; jj < referenceNodeList.getLength(); ++jj) {
                Node referenceNode = referenceNodeList.item(jj);
                if (!this.isSignatureCoveredNodeAffected(referenceNode, parentNodes)) continue;
                this.assertDoesNotContainEnvelopedTransform(referenceNode);
            }
        }
    }

    private Set<Node> getParentNodesChain(Node node) {
        LinkedHashSet<Node> nodesChain = new LinkedHashSet<Node>();
        nodesChain.add(node);
        for (Node parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            nodesChain.add(parentNode);
        }
        return nodesChain;
    }

    private boolean isSignatureCoveredNodeAffected(Node referenceNode, Set<Node> affectedNodes) {
        String id = DSSXMLUtils.getAttribute(referenceNode, XMLDSigAttribute.URI.getAttributeName());
        if (id == null) {
            return false;
        }
        if (Utils.isStringEmpty(id)) {
            return true;
        }
        Element referencedNode = DomUtils.getElementById(this.documentDom, id);
        return affectedNodes.contains(referencedNode);
    }

    private void assertDoesNotContainEnvelopedTransform(Node referenceNode) {
        NodeList transformList = DomUtils.getNodeList(referenceNode, XMLDSigPath.TRANSFORMS_TRANSFORM_PATH);
        if (transformList != null && transformList.getLength() > 0) {
            for (int jj = 0; jj < transformList.getLength(); ++jj) {
                Element transformElement = (Element)transformList.item(jj);
                String transformAlgorithm = transformElement.getAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName());
                if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(transformAlgorithm)) continue;
                throw new IllegalInputException(String.format("The parallel signature is not possible! The provided file contains a signature with an '%s' transform.", "http://www.w3.org/2000/09/xmldsig#enveloped-signature"));
            }
        }
    }

    @Override
    protected Node getParentNodeOfSignature() {
        String xPathLocationString = this.params.getXPathLocationString();
        if (Utils.isStringNotEmpty(xPathLocationString)) {
            Element element = DomUtils.getElement(this.documentDom, xPathLocationString);
            if (element != null) {
                return element;
            }
            throw new IllegalArgumentException(String.format("Unable to find an element corresponding to XPath location '%s'", xPathLocationString));
        }
        return this.documentDom.getDocumentElement();
    }

    @Override
    protected void incorporateSignatureDom(Node parentNodeOfSignature) {
        if (this.params.getXPathElementPlacement() == null || Utils.isStringEmpty(this.params.getXPathLocationString())) {
            super.incorporateSignatureDom(parentNodeOfSignature);
            return;
        }
        switch (this.params.getXPathElementPlacement()) {
            case XPathAfter: {
                if (parentNodeOfSignature.isEqualNode(this.documentDom.getDocumentElement())) {
                    parentNodeOfSignature.appendChild(this.signatureDom);
                    break;
                }
                Node parent = parentNodeOfSignature.getParentNode();
                parent.insertBefore(this.signatureDom, parentNodeOfSignature.getNextSibling());
                break;
            }
            case XPathFirstChildOf: {
                parentNodeOfSignature.insertBefore(this.signatureDom, parentNodeOfSignature.getFirstChild());
                break;
            }
            default: {
                parentNodeOfSignature.appendChild(this.signatureDom);
            }
        }
    }
}

