/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.timestamp;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureProperties;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.timestamp.SignatureTimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampInclude;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.definition.XAdESNamespace;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.definition.xadesen.XAdESEvidencerecordNamespaceElement;
import eu.europa.esig.dss.xades.evidencerecord.XAdESEmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESCertificateRefExtractionUtils;
import eu.europa.esig.dss.xades.validation.XAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignedDataObjectProperties;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import eu.europa.esig.dss.xades.validation.scope.XAdESTimestampScopeFinder;
import eu.europa.esig.dss.xades.validation.timestamp.XAdESTimestampMessageDigestBuilder;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigPath;
import eu.europa.esig.dss.xml.utils.DOMDocument;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampSource
extends SignatureTimestampSource<XAdESSignature, XAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampSource.class);
    private final transient Element signatureElement;
    private final XAdESPath xadesPaths;
    private final Map<TimestampToken, XAdESAttribute> timestampAttributeMap = new HashMap<TimestampToken, XAdESAttribute>();

    public XAdESTimestampSource(XAdESSignature signature) {
        super(signature);
        this.signatureElement = signature.getSignatureElement();
        this.xadesPaths = signature.getXAdESPaths();
    }

    @Override
    protected SignatureProperties<XAdESAttribute> buildSignedSignatureProperties() {
        return XAdESSignedDataObjectProperties.build(this.signatureElement, this.xadesPaths);
    }

    @Override
    protected SignatureProperties<XAdESAttribute> buildUnsignedSignatureProperties() {
        return XAdESUnsignedSigProperties.build(this.signatureElement, this.xadesPaths);
    }

    @Override
    protected XAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(DigestAlgorithm digestAlgorithm) {
        return new XAdESTimestampMessageDigestBuilder((XAdESSignature)this.signature, digestAlgorithm);
    }

    @Override
    protected XAdESTimestampMessageDigestBuilder getTimestampMessageImprintDigestBuilder(TimestampToken timestampToken) {
        return new XAdESTimestampMessageDigestBuilder((XAdESSignature)this.signature, timestampToken).setTimestampAttribute(this.timestampAttributeMap.get(timestampToken));
    }

    public DSSMessageDigest getSignatureTimestampMessageDigest(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod);
        return builder.getSignatureTimestampMessageDigest();
    }

    public DSSMessageDigest getTimestampX1MessageDigest(DigestAlgorithm digestAlgorithm, String canonicalizationMethod, boolean en319132) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod).setEn319132(en319132);
        return builder.getTimestampX1MessageDigest();
    }

    public DSSMessageDigest getTimestampX2MessageDigest(DigestAlgorithm digestAlgorithm, String canonicalizationMethod, boolean en319132) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod).setEn319132(en319132);
        return builder.getTimestampX2MessageDigest();
    }

    public DSSMessageDigest getArchiveTimestampData(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        XAdESTimestampMessageDigestBuilder builder = this.getTimestampMessageImprintDigestBuilder(digestAlgorithm).setCanonicalizationAlgorithm(canonicalizationMethod);
        return builder.getArchiveTimestampMessageDigest();
    }

    @Override
    protected boolean isContentTimestamp(XAdESAttribute signedAttribute) {
        return false;
    }

    @Override
    protected boolean isAllDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return XAdES132Element.ALL_DATA_OBJECTS_TIMESTAMP.isSameTagName(signedAttribute.getName());
    }

    @Override
    protected boolean isIndividualDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return XAdES132Element.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.isSameTagName(signedAttribute.getName());
    }

    @Override
    protected boolean isSignatureTimestamp(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.SIGNATURE_TIMESTAMP.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isCompleteCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.COMPLETE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES141Element.COMPLETE_CERTIFICATE_REFS_V2.isSameTagName(localName);
    }

    @Override
    protected boolean isAttributeCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES141Element.ATTRIBUTE_CERTIFICATE_REFS_V2.isSameTagName(localName);
    }

    @Override
    protected boolean isCompleteRevocationRef(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.COMPLETE_REVOCATION_REFS.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isAttributeRevocationRef(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTRIBUTE_REVOCATION_REFS.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isRefsOnlyTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.REFS_ONLY_TIMESTAMP.isSameTagName(localName) || XAdES141Element.REFS_ONLY_TIMESTAMP_V2.isSameTagName(localName);
    }

    @Override
    protected boolean isSigAndRefsTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.SIG_AND_REFS_TIMESTAMP.isSameTagName(localName) || XAdES141Element.SIG_AND_REFS_TIMESTAMP_V2.isSameTagName(localName);
    }

    @Override
    protected boolean isCertificateValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.CERTIFICATE_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isRevocationValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.REVOCATION_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isAttrAuthoritiesCertValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTR_AUTHORITIES_CERT_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isAttributeRevocationValues(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ATTRIBUTE_REVOCATION_VALUES.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isArchiveTimestamp(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.ARCHIVE_TIMESTAMP.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isTimeStampValidationData(XAdESAttribute unsignedAttribute) {
        return XAdES141Element.TIMESTAMP_VALIDATION_DATA.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isAnyValidationData(XAdESAttribute unsignedAttribute) {
        return XAdES141Element.ANY_VALIDATION_DATA.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isValidationDataReferences(XAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isCounterSignature(XAdESAttribute unsignedAttribute) {
        return XAdES132Element.COUNTER_SIGNATURE.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isSignaturePolicyStore(XAdESAttribute unsignedAttribute) {
        return XAdES141Element.SIGNATURE_POLICY_STORE.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected boolean isEvidenceRecord(XAdESAttribute unsignedAttribute) {
        return XAdESEvidencerecordNamespaceElement.SEALING_EVIDENCE_RECORDS.isSameTagName(unsignedAttribute.getName());
    }

    @Override
    protected List<TimestampToken> makeTimestampTokens(XAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        NodeList encapsulatedTimestamps = signatureAttribute.getNodeList(this.xadesPaths.getCurrentEncapsulatedTimestamp());
        if (encapsulatedTimestamps == null || encapsulatedTimestamps.getLength() == 0) {
            LOG.warn("The timestamp(s) {} cannot be extracted from the signature!", (Object)timestampType.name());
            return Collections.emptyList();
        }
        if (this.isSignatureTimestamp(signatureAttribute) && encapsulatedTimestamps.getLength() > 1) {
            LOG.warn("Only one EncapsulatedTimeStamp is allowed in '{}' element!", (Object)signatureAttribute.getName());
        }
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        for (int ii = 0; ii < encapsulatedTimestamps.getLength(); ++ii) {
            Element encapsulatedTimeStamp = (Element)encapsulatedTimestamps.item(ii);
            TimestampToken timestampToken = this.createTimestampToken(encapsulatedTimeStamp, timestampType, references, signatureAttribute, ii);
            if (timestampToken == null) continue;
            timestampToken.setCanonicalizationMethod(signatureAttribute.getTimestampCanonicalizationMethod());
            timestampToken.setTimestampIncludes(signatureAttribute.getTimestampIncludedReferences());
            if (TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timestampType)) {
                this.addReferences(timestampToken.getTimestampedReferences(), this.getIndividualDataContentTimestampReferences(signatureAttribute.getTimestampIncludedReferences()));
            }
            this.timestampAttributeMap.put(timestampToken, signatureAttribute);
            result.add(timestampToken);
        }
        return result;
    }

    private TimestampToken createTimestampToken(Element encapsulatedTimeStamp, TimestampType timestampType, List<TimestampedReference> references, XAdESAttribute signatureAttribute, Integer orderWithinAttribute) {
        try {
            String base64EncodedTimestamp = encapsulatedTimeStamp.getTextContent();
            byte[] binaries = Utils.fromBase64(base64EncodedTimestamp);
            SignatureTimestampIdentifierBuilder identifierBuilder = new SignatureTimestampIdentifierBuilder(binaries).setSignature(this.signature).setAttribute(signatureAttribute).setOrderOfAttribute(this.getAttributeOrder(signatureAttribute)).setOrderWithinAttribute(orderWithinAttribute);
            return new TimestampToken(binaries, timestampType, references, (TimestampIdentifierBuilder)identifierBuilder);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to build timestamp token from binaries '{}'! Reason : {}", encapsulatedTimeStamp.getTextContent(), e.getMessage(), e);
            } else {
                LOG.warn("Unable to build timestamp token! Reason : {}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }
    }

    @Override
    protected List<EvidenceRecord> makeEvidenceRecords(XAdESAttribute signatureAttribute, List<TimestampedReference> references) {
        Element element = signatureAttribute.getElement();
        if (element == null || element.getChildNodes().getLength() == 0) {
            LOG.warn("The element containing evidence record(s) is empty!");
            return Collections.emptyList();
        }
        ArrayList<EvidenceRecord> result = new ArrayList<EvidenceRecord>();
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Element encapsulatedEvidenceRecord = (Element)element.getChildNodes().item(ii);
            EvidenceRecord evidenceRecord = this.createEvidenceRecord(signatureAttribute, encapsulatedEvidenceRecord, ii);
            if (evidenceRecord == null) continue;
            result.add(evidenceRecord);
        }
        return result;
    }

    private EvidenceRecord createEvidenceRecord(XAdESAttribute signatureAttribute, Element encapsulatedEvidenceRecord, int orderWithinAttribute) {
        try {
            DSSDocument erDocument = this.getEvidenceRecordDocument(encapsulatedEvidenceRecord);
            EvidenceRecordAnalyzer evidenceRecordAnalyzer = EvidenceRecordAnalyzerFactory.fromDocument(erDocument);
            evidenceRecordAnalyzer.setEvidenceRecordOrigin(EvidenceRecordOrigin.SIGNATURE);
            XAdESEmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper = new XAdESEmbeddedEvidenceRecordHelper((XAdESSignature)this.signature, signatureAttribute);
            embeddedEvidenceRecordHelper.setDetachedContents(((XAdESSignature)this.signature).getDetachedContents());
            embeddedEvidenceRecordHelper.setOrderOfAttribute(this.getAttributeOrder(signatureAttribute));
            embeddedEvidenceRecordHelper.setOrderWithinAttribute(orderWithinAttribute);
            evidenceRecordAnalyzer.setEmbeddedEvidenceRecordHelper(embeddedEvidenceRecordHelper);
            return evidenceRecordAnalyzer.getEvidenceRecord();
        }
        catch (Exception e) {
            LOG.warn("Unable to build an embedded evidence record. Reason : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private DSSDocument getEvidenceRecordDocument(Element encapsulatedEvidenceRecord) {
        String base64EncodedEvidenceRecord;
        if (XAdESEvidencerecordNamespaceElement.EVIDENCE_RECORD.isSameTagName(encapsulatedEvidenceRecord.getLocalName())) {
            return new DOMDocument(encapsulatedEvidenceRecord);
        }
        if (XAdESEvidencerecordNamespaceElement.ASN1_EVIDENCE_RECORD.isSameTagName(encapsulatedEvidenceRecord.getLocalName()) && Utils.isBase64Encoded(base64EncodedEvidenceRecord = encapsulatedEvidenceRecord.getTextContent())) {
            return new InMemoryDocument(Utils.fromBase64(base64EncodedEvidenceRecord));
        }
        throw new UnsupportedOperationException(String.format("The provided format of an evidence record within the '%s' element is not supported.", encapsulatedEvidenceRecord.getLocalName()));
    }

    @Override
    protected List<SignatureScope> getTimestampScopes(TimestampToken timestampToken) {
        XAdESTimestampScopeFinder timestampScopeFinder = new XAdESTimestampScopeFinder();
        timestampScopeFinder.setSignature(this.signature);
        return timestampScopeFinder.findTimestampScope(timestampToken);
    }

    private List<TimestampedReference> getIndividualDataContentTimestampReferences(List<TimestampInclude> timestampIncludes) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        List<SignatureScope> signatureScopes = ((XAdESSignature)this.signature).getSignatureScopes();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (ReferenceValidation referenceValidation : ((XAdESSignature)this.signature).getReferenceValidations()) {
                XAdESReferenceValidation xadesReferenceValidation = (XAdESReferenceValidation)referenceValidation;
                if (!this.isContentTimestampedReference(xadesReferenceValidation, timestampIncludes)) continue;
                for (SignatureScope signatureScope : signatureScopes) {
                    if (!Utils.endsWithIgnoreCase(xadesReferenceValidation.getUri(), signatureScope.getDocumentName())) continue;
                    result.add(signatureScope);
                }
            }
        }
        return this.getSignerDataTimestampedReferences(result);
    }

    private boolean isContentTimestampedReference(XAdESReferenceValidation xadesReferenceValidation, List<TimestampInclude> includes) {
        if (xadesReferenceValidation.getId() != null) {
            for (TimestampInclude timestampInclude : includes) {
                if (!xadesReferenceValidation.getId().equals(timestampInclude.getURI())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected TimestampToken makeTimestampToken(XAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        throw new UnsupportedOperationException("XAdESTimeStampType element can contain more than one timestamp");
    }

    @Override
    protected List<TimestampedReference> getArchiveTimestampReferences(List<TimestampToken> previousTimestamps) {
        List<TimestampedReference> timestampedReferences = super.getArchiveTimestampReferences(previousTimestamps);
        this.addReferences(timestampedReferences, this.getKeyInfoReferences());
        return timestampedReferences;
    }

    @Override
    protected List<TimestampedReference> getSignatureTimestampReferences() {
        List<TimestampedReference> timestampedReferences = super.getSignatureTimestampReferences();
        if (XAdESSignatureUtils.isKeyInfoCovered((XAdESSignature)this.signature)) {
            this.addReferences(timestampedReferences, this.getKeyInfoReferences());
        }
        return timestampedReferences;
    }

    @Override
    protected List<CertificateRef> getCertificateRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> certRefs = new ArrayList<CertificateRef>();
        boolean certificateRefV1 = this.isCertificateRefV1(unsignedAttribute);
        NodeList certRefsNodeList = null;
        if (certificateRefV1) {
            String currentCertRefsCertChildrenPath = this.xadesPaths.getCurrentCertRefsCertChildren();
            if (Utils.isStringNotEmpty(currentCertRefsCertChildrenPath)) {
                certRefsNodeList = unsignedAttribute.getNodeList(currentCertRefsCertChildrenPath);
            }
        } else {
            String currentCertRefs141CertChildrenPath = this.xadesPaths.getCurrentCertRefs141CertChildren();
            if (Utils.isStringNotEmpty(currentCertRefs141CertChildrenPath)) {
                certRefsNodeList = unsignedAttribute.getNodeList(currentCertRefs141CertChildrenPath);
            }
        }
        if (certRefsNodeList != null) {
            for (int ii = 0; ii < certRefsNodeList.getLength(); ++ii) {
                Element certRefElement = (Element)certRefsNodeList.item(ii);
                CertificateRef certificateRef = certificateRefV1 ? XAdESCertificateRefExtractionUtils.createCertificateRefFromV1(certRefElement, this.xadesPaths) : XAdESCertificateRefExtractionUtils.createCertificateRefFromV2(certRefElement, this.xadesPaths);
                if (certificateRef == null) continue;
                certRefs.add(certificateRef);
            }
        }
        return certRefs;
    }

    private boolean isCertificateRefV1(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return XAdES132Element.ATTRIBUTE_CERTIFICATE_REFS.isSameTagName(localName) || XAdES132Element.COMPLETE_CERTIFICATE_REFS.isSameTagName(localName);
    }

    @Override
    protected List<CRLRef> getCRLRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<CRLRef> crlRefs = new ArrayList<CRLRef>();
        NodeList nodeList = unsignedAttribute.getNodeList(this.xadesPaths.getCurrentCRLRefsChildren());
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element element = (Element)nodeList.item(ii);
            CRLRef crlRef = XAdESRevocationRefExtractionUtils.createCRLRef(this.xadesPaths, element);
            if (crlRef == null) continue;
            crlRefs.add(crlRef);
        }
        return crlRefs;
    }

    @Override
    protected List<OCSPRef> getOCSPRefs(XAdESAttribute unsignedAttribute) {
        ArrayList<OCSPRef> ocspRefs = new ArrayList<OCSPRef>();
        NodeList nodeList = unsignedAttribute.getNodeList(this.xadesPaths.getCurrentOCSPRefsChildren());
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element element = (Element)nodeList.item(ii);
            OCSPRef ocspRef = XAdESRevocationRefExtractionUtils.createOCSPRef(this.xadesPaths, element);
            if (ocspRef == null) continue;
            ocspRefs.add(ocspRef);
        }
        return ocspRefs;
    }

    @Override
    protected List<Identifier> getEncapsulatedCertificateIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) || this.isAnyValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentCertificateValuesEncapsulatedCertificate() : this.xadesPaths.getCurrentEncapsulatedCertificate();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                CertificateToken certificateToken = DSSUtils.loadCertificate(binaries);
                certificateIdentifiers.add(certificateToken.getDSSId());
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    @Override
    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<CRLBinary> crlIdentifiers = new ArrayList<CRLBinary>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) || this.isAnyValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentRevocationValuesEncapsulatedCRLValue() : this.xadesPaths.getCurrentEncapsulatedCRLValue();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                crlIdentifiers.add(CRLUtils.buildCRLBinary(binaries));
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse CRL binaries : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return crlIdentifiers;
    }

    @Override
    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<OCSPResponseBinary> ocspIdentifiers = new ArrayList<OCSPResponseBinary>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) || this.isAnyValidationData(unsignedAttribute) ? this.xadesPaths.getCurrentRevocationValuesEncapsulatedOCSPValue() : this.xadesPaths.getCurrentEncapsulatedOCSPValue();
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            try {
                Element element = (Element)encapsulatedNodes.item(ii);
                byte[] binaries = this.getEncapsulatedTokenBinaries(element);
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries(binaries);
                ocspIdentifiers.add(OCSPResponseBinary.build(basicOCSPResp));
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse OCSP response binaries : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return ocspIdentifiers;
    }

    private byte[] getEncapsulatedTokenBinaries(Element encapsulatedElement) {
        String base64String;
        Node firstChild;
        if (encapsulatedElement.hasChildNodes() && 3 == (firstChild = encapsulatedElement.getFirstChild()).getNodeType() && Utils.isBase64Encoded(base64String = firstChild.getTextContent())) {
            return Utils.fromBase64(base64String);
        }
        throw new DSSException(String.format("Cannot create the token reference. The element with local name [%s] must contain an encapsulated base64 token value! The found value is not a text node!", encapsulatedElement.getLocalName()));
    }

    @Override
    protected ArchiveTimestampType getArchiveTimestampType(XAdESAttribute unsignedAttribute) {
        if (XAdESNamespace.XADES_141.isSameUri(unsignedAttribute.getNamespace())) {
            return ArchiveTimestampType.XAdES_141;
        }
        return ArchiveTimestampType.XAdES;
    }

    @Override
    protected List<AdvancedSignature> getCounterSignatures(XAdESAttribute unsignedAttribute) {
        Node counterSignatureNode = DomUtils.getNode(unsignedAttribute.getElement(), XMLDSigPath.SIGNATURE_PATH);
        if (counterSignatureNode != null) {
            List<AdvancedSignature> counterSignatures = ((XAdESSignature)this.signature).getCounterSignatures();
            for (AdvancedSignature counterSignature : counterSignatures) {
                if (counterSignatureNode != ((XAdESSignature)counterSignature).getSignatureElement()) continue;
                return Collections.singletonList(counterSignature);
            }
        }
        return Collections.emptyList();
    }
}

