/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import org.apache.xmlgraphics.fonts.Glyphs;

public class NamedCharacter {
    private String charName;
    private String unicodeSequence;

    public NamedCharacter(String charName, String unicodeSequence) {
        if (charName == null) {
            throw new NullPointerException("charName must not be null");
        }
        this.charName = charName;
        this.unicodeSequence = unicodeSequence != null ? unicodeSequence : Glyphs.getUnicodeSequenceForGlyphName(charName);
    }

    public NamedCharacter(String charName) {
        this(charName, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charName == null ? 0 : this.charName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedCharacter other = (NamedCharacter)obj;
        return this.charName.equals(other.charName);
    }

    public String getName() {
        return this.charName;
    }

    public String getUnicodeSequence() {
        return this.unicodeSequence;
    }

    public boolean hasSingleUnicodeValue() {
        return this.unicodeSequence != null && this.unicodeSequence.length() == 1;
    }

    public char getSingleUnicodeValue() throws IllegalStateException {
        if (this.unicodeSequence == null) {
            return '\uffff';
        }
        if (this.unicodeSequence.length() > 1) {
            throw new IllegalStateException("getSingleUnicodeValue() may not be called for a named character that has more than one Unicode value (a sequence) associated with the named character!");
        }
        return this.unicodeSequence.charAt(0);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.unicodeSequence);
        sb.append(" (");
        if (this.unicodeSequence != null) {
            int c = this.unicodeSequence.length();
            for (int i = 0; i < c; ++i) {
                sb.append("0x").append(Integer.toHexString(this.unicodeSequence.charAt(0)));
            }
            sb.append(", ");
        }
        sb.append(this.getName()).append(')');
        return sb.toString();
    }
}

