/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.net.URI;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.xmlgraphics.util.QName;

public class AFPForeignAttributeReader {
    private static final Log LOG = LogFactory.getLog("org.apache.xmlgraphics.afp");
    public static final QName RESOURCE_NAME = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-name");
    public static final QName RESOURCE_LEVEL = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-level");
    public static final QName RESOURCE_GROUP_URI = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-group-file");

    public AFPResourceInfo getResourceInfo(Map<QName, String> foreignAttributes) {
        AFPResourceInfo resourceInfo = new AFPResourceInfo();
        if (foreignAttributes != null && !foreignAttributes.isEmpty()) {
            AFPResourceLevel level;
            String resourceName = foreignAttributes.get(RESOURCE_NAME);
            if (resourceName != null) {
                resourceInfo.setName(resourceName);
            }
            if ((level = this.getResourceLevel(foreignAttributes)) != null) {
                resourceInfo.setLevel(level);
            }
        }
        return resourceInfo;
    }

    public AFPResourceLevel getResourceLevel(Map<QName, String> foreignAttributes) {
        String levelString;
        AFPResourceLevel resourceLevel = null;
        if (foreignAttributes != null && !foreignAttributes.isEmpty() && foreignAttributes.containsKey(RESOURCE_LEVEL) && (resourceLevel = AFPResourceLevel.valueOf(levelString = foreignAttributes.get(RESOURCE_LEVEL))) != null && resourceLevel.isExternal()) {
            String resourceGroupUri = foreignAttributes.get(RESOURCE_GROUP_URI);
            if (resourceGroupUri == null) {
                String msg = RESOURCE_GROUP_URI + " not specified";
                throw new UnsupportedOperationException(msg);
            }
            resourceLevel.setExternalUri(URI.create(resourceGroupUri));
        }
        return resourceLevel;
    }
}

