<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dss="http://dss.esig.europa.eu/validation/simple-certificate-report">
                
	<xsl:output method="html" encoding="utf-8" indent="yes" omit-xml-declaration="yes" />

	<xsl:param name="rootUrlInTlBrowser">https://eidas.ec.europa.eu/efda/tl-browser/#/screen</xsl:param>
	<xsl:param name="euTLSubDirectoryInTlBrowser">/tl</xsl:param>
	<xsl:param name="tcTLSubDirectoryInTlBrowser">/tc-tl</xsl:param>
	<xsl:param name="trustmarkSubDirectoryInTlBrowser">/trustmark</xsl:param>
	<xsl:param name="euGenericTSLType">http://uri.etsi.org/TrstSvc/TrustedList/TSLType/EUgeneric</xsl:param>
	
   	<xsl:variable name="validationTime">
   		<xsl:value-of select="/dss:SimpleCertificateReport/@ValidationTime" />
   	</xsl:variable>

    <xsl:template match="/dss:SimpleCertificateReport">
		<xsl:comment>Generated by DSS v.6.4.RC1</xsl:comment>

		<div>
			<xsl:apply-templates select="dss:ValidationPolicy"/>
			<xsl:apply-templates select="dss:Certificate"/>
			<xsl:apply-templates select="dss:ConnectionDetails"/>
		</div>
    </xsl:template>
    
	<xsl:template match="dss:Chain">
		<xsl:value-of select="@Id"/>

		<xsl:if test="dss:ChainItem">
			<xsl:variable name="idToken"><xsl:value-of select="../@Id"/></xsl:variable>
			<div>
				<xsl:attribute name="class">card mt-3</xsl:attribute>
				<div>
					<xsl:attribute name="class">card-header bg-primary collapsed</xsl:attribute>
					<xsl:attribute name="data-target">#collapseChain-<xsl:value-of select="$idToken" /></xsl:attribute>
					<xsl:attribute name="data-toggle">collapse</xsl:attribute>
					<xsl:attribute name="aria-expanded">false</xsl:attribute>

					<xsl:value-of select="idToken"/>
					Certificate chain <span class="badge badge-light"><xsl:value-of select="count(dss:ChainItem)" /></span>
				</div>
				<div>
					<xsl:attribute name="class">card-body collapse pb-1</xsl:attribute>
					<xsl:attribute name="id">collapseChain-<xsl:value-of select="$idToken" /></xsl:attribute>

					<xsl:apply-templates select="dss:ChainItem" />
				</div>
			</div>
		</xsl:if>
    </xsl:template>

    <xsl:template match="dss:Certificate|dss:ChainItem">
    
		<xsl:variable name="idCert" select="@Id" />
     	<xsl:variable name="indicationText" select="dss:Indication/text()"/>
        <xsl:variable name="indicationCssClass">
        	<xsl:choose>
				<xsl:when test="$indicationText='PASSED' or dss:trustAnchors">success</xsl:when>
				<xsl:when test="$indicationText='INDETERMINATE'">warning</xsl:when>
				<xsl:when test="$indicationText='FAILED'">danger</xsl:when>
				<!-- Cannot conclude (untrusted chain) -->
				<xsl:otherwise>secondary</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>
    
		<div>
    		<xsl:attribute name="class">card mb-3</xsl:attribute>
    		<div>
    			<xsl:attribute name="class">card-header bg-<xsl:value-of select="$indicationCssClass" /> text-white</xsl:attribute>
	    		<xsl:attribute name="data-target">#collapseCert-<xsl:value-of select="$idCert"/></xsl:attribute>
		       	<xsl:attribute name="data-toggle">collapse</xsl:attribute>

				<span>
					Certificate
					<xsl:value-of select="$idCert" />
				</span>
				<i>
					<xsl:attribute name="class">id-copy fa fa-clipboard btn btn-outline-light cursor-pointer text-light border-0 p-2 ml-1 mr-1</xsl:attribute>
					<xsl:attribute name="data-id"><xsl:value-of select="$idCert"/></xsl:attribute>
					<xsl:attribute name="data-toggle">tooltip</xsl:attribute>
					<xsl:attribute name="data-placement">right</xsl:attribute>
					<xsl:attribute name="data-success-text">Id copied successfully!</xsl:attribute>
					<xsl:attribute name="title">Copy Id to clipboard</xsl:attribute>
				</i>
	        </div>
    		<div>
    			<xsl:attribute name="class">card-body collapse show</xsl:attribute>
	        	<xsl:attribute name="id">collapseCert-<xsl:value-of select="$idCert"/></xsl:attribute>
	        	
	        	<xsl:if test="dss:qualificationAtIssuance or dss:qualificationAtValidation">
		        	<dl>
			    		<xsl:attribute name="class">row mb-0</xsl:attribute>
			    		
			    		<dt>
			        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
			        		Qualification:
			        	</dt>
			    		
			    		<dd>
			        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
			    		
							<ul>
	            				<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
			    		
			    				<li>
									<xsl:attribute name="class">mb-1</xsl:attribute>

			    					Issuance Time (<xsl:call-template name="formatdate"><xsl:with-param name="DateTimeStr" select="dss:notBefore"/></xsl:call-template>) :
					    			<span>
					    				<xsl:attribute name="class">
					    					<xsl:choose>
					    						<xsl:when test="dss:qualificationAtIssuance='N/A'">badge badge-secondary</xsl:when>
					    						<xsl:otherwise>badge badge-primary</xsl:otherwise>
					    					</xsl:choose>
					    				</xsl:attribute>
					    				
					    				<xsl:value-of select="dss:qualificationAtIssuance"/>
					    			</span>
					    		</li>

								<li>
									<xsl:attribute name="class">mb-1</xsl:attribute>
									<span>
										<xsl:apply-templates select="dss:qualificationDetailsAtIssuance"/>
									</span>
								</li>
					    		
			    				<li>
									<xsl:attribute name="class">mb-1</xsl:attribute>

				    				Validation Time (<xsl:call-template name="formatdate"><xsl:with-param name="DateTimeStr" select="$validationTime"/></xsl:call-template>) :
					    			<span>
					    				<xsl:attribute name="class">
					    					<xsl:choose>
					    						<xsl:when test="dss:qualificationAtValidation='N/A'">badge badge-secondary</xsl:when>
					    						<xsl:otherwise>badge badge-primary</xsl:otherwise>
					    					</xsl:choose>
					    				</xsl:attribute>
					    				
					    				<xsl:value-of select="dss:qualificationAtValidation"/>
					    			</span>
					    		</li>

								<li>
									<xsl:attribute name="class">mb-1</xsl:attribute>
									<span>
										<xsl:apply-templates select="dss:qualificationDetailsAtValidation"/>
									</span>
								</li>

								<xsl:if test="dss:enactedMRA">
									<li>
										<xsl:attribute name="class">mt-2 mb-1</xsl:attribute>
										<span>
											The qualification level has been determined using an enacted trust service equivalence mapping.
										</span>
									</li>
								</xsl:if>
					    	</ul>
			    		</dd>
		        	</dl>
	        	</xsl:if>

				<xsl:if test="dss:qwacProfile">
					<dl>
						<xsl:attribute name="class">row mb-0</xsl:attribute>

						<dt>
							<xsl:attribute name="class">col-sm-3</xsl:attribute>
							QWAC Profile:
						</dt>

						<dd>
							<xsl:attribute name="class">col-sm-9</xsl:attribute>

							<ul>
								<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>

								<li>
									<xsl:attribute name="class">mb-1</xsl:attribute>

									<span>
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="dss:qwacProfile='Not QWAC'">badge badge-secondary mr-2</xsl:when>
												<xsl:otherwise>badge badge-primary mr-2</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>

										<xsl:value-of select="dss:qwacProfile"/>
									</span>
									<xsl:if test="dss:qwacProfile='1-QWAC' or dss:qwacProfile='2-QWAC' or dss:qwacProfile='TLS certificate supported by 2-QWAC'">
										<i>
											<xsl:attribute name="class">fa fa-check-circle align-middle text-primary</xsl:attribute>
											<xsl:attribute name="data-toggle">tooltip</xsl:attribute>
											<xsl:attribute name="data-placement">right</xsl:attribute>
											<xsl:attribute name="title">Qualified certificate for website authentication</xsl:attribute>
										</i>
									</xsl:if>
								</li>

								<li>
									<xsl:attribute name="class">mb-1</xsl:attribute>
									<span>
										<xsl:apply-templates select="dss:qwacDetails"/>
									</span>
								</li>

							</ul>
						</dd>
					</dl>
				</xsl:if>

				<dl>
					<xsl:attribute name="class">row mb-0</xsl:attribute>
					<dt>
						<xsl:attribute name="class">col-sm-3</xsl:attribute>
						Indication:
					</dt>
					<dd>
						<xsl:attribute name="class">col-sm-9 text-<xsl:value-of select="$indicationCssClass" /></xsl:attribute>

						<div>
							<xsl:attribute name="class">badge mr-2 badge-<xsl:value-of select="$indicationCssClass" /></xsl:attribute>
							<xsl:value-of select="$indicationText" />
						</div>

						<xsl:variable name="indication-icon-class">
							<xsl:choose>
								<xsl:when test="$indicationText='PASSED' or dss:trustAnchors">fa-check-circle</xsl:when>
								<xsl:when test="$indicationText='INDETERMINATE'">fa-exclamation-circle</xsl:when>
								<xsl:when test="$indicationText='FAILED'">fa-times-circle</xsl:when>
							</xsl:choose>
						</xsl:variable>

						<i>
							<xsl:attribute name="class">fa <xsl:value-of select="$indication-icon-class" /> align-middle</xsl:attribute>
							<xsl:attribute name="data-toggle">tooltip</xsl:attribute>
							<xsl:attribute name="data-placement">right</xsl:attribute>
							<xsl:attribute name="title"><xsl:value-of select="$indicationText" /></xsl:attribute>
						</i>
					</dd>
				</dl>

				<xsl:apply-templates select="dss:SubIndication">
					<xsl:with-param name="indicationClass" select="$indicationCssClass"/>
				</xsl:apply-templates>

				<xsl:apply-templates select="dss:X509ValidationDetails" />
	        	
				<xsl:apply-templates select="dss:subject"/>
				
				<xsl:if test="dss:keyUsages or dss:extendedKeyUsages">
					<div>
						<xsl:attribute name="class">row mb-0</xsl:attribute>
						
						<div>
							<xsl:attribute name="class">col-md-6</xsl:attribute>
						
							<xsl:apply-templates select="dss:keyUsages"/>
						</div>
						<div>
							<xsl:attribute name="class">col-md-6</xsl:attribute>
						
							<xsl:apply-templates select="dss:extendedKeyUsages"/>
						</div>
					</div>
				</xsl:if>
					
	        	<dl>
	        		<xsl:attribute name="class">row mb-0</xsl:attribute>
	        		
	        		<dt>
		        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
		        		Validity:
			        </dt>
	        		<dd>
	        			<xsl:attribute name="class">col-sm-9</xsl:attribute>
						<xsl:call-template name="formatdate">
							<xsl:with-param name="DateTimeStr" select="dss:notBefore"/>
						</xsl:call-template>
						-
						<xsl:call-template name="formatdate">
							<xsl:with-param name="DateTimeStr" select="dss:notAfter"/>
						</xsl:call-template>
	        		</dd>
	        		
	        		<xsl:if test="not(dss:trustAnchors)">
	       				<dt>
			        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
			        		Revocation:
			        	</dt>
	       				<dd>
	        				<xsl:attribute name="class">col-sm-9</xsl:attribute>
		       				<xsl:apply-templates select="dss:revocation"/>
		       			</dd>
       				</xsl:if>
	        		
					<xsl:apply-templates select="dss:ocspUrls"/>
					<xsl:apply-templates select="dss:crlUrls"/>
				</dl>
				
	        	<xsl:if test="dss:aiaUrls or dss:cpsUrls">
					<dl>
			    		<xsl:attribute name="class">row mb-0</xsl:attribute>
			    		
						<xsl:apply-templates select="dss:aiaUrls"/>
						<xsl:apply-templates select="dss:cpsUrls"/>
		        	</dl>
	        	</xsl:if>
				
	        	<xsl:if test="dss:trustAnchors">
					<dl>
			    		<xsl:attribute name="class">row mb-0</xsl:attribute>
			    		
						<xsl:apply-templates select="dss:trustAnchors"/>
		        	</dl>
	        	</xsl:if>

				<xsl:if test="dss:trustStartDate or dss:trustSunsetDate">
					<dl>
						<xsl:attribute name="class">row mb-0</xsl:attribute>
						<dt>
							<xsl:attribute name="class">col-sm-3</xsl:attribute>
							Trust anchor validity:
						</dt>
						<dd>
							<xsl:attribute name="class">col-sm-9</xsl:attribute>
							<xsl:if test="dss:trustStartDate">
								Start @
								<xsl:call-template name="formatdate">
									<xsl:with-param name="DateTimeStr" select="dss:trustStartDate"/>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="dss:trustSunsetDate">
								<xsl:if test="dss:trustStartDate"> -</xsl:if>
								Sunset @
								<xsl:call-template name="formatdate">
									<xsl:with-param name="DateTimeStr" select="dss:trustSunsetDate"/>
								</xsl:call-template>
							</xsl:if>
						</dd>
					</dl>
				</xsl:if>

				<xsl:apply-templates select="dss:Chain" />

				<xsl:if test="dss:TLSBindingSignature">
					<div>
						<xsl:attribute name="class">card mt-3</xsl:attribute>
						<div>
							<xsl:attribute name="class">card-header bg-primary collapsed</xsl:attribute>
							<xsl:attribute name="data-target">#collapseTLSBindingSignature<xsl:value-of select="idCert" /></xsl:attribute>
							<xsl:attribute name="data-toggle">collapse</xsl:attribute>
							<xsl:attribute name="aria-expanded">false</xsl:attribute>

							TLS Certificate Binding signature
						</div>
						<div>
							<xsl:attribute name="class">card-body collapse pb-1</xsl:attribute>
							<xsl:attribute name="id">collapseTLSBindingSignature<xsl:value-of select="idCert" /></xsl:attribute>
							<xsl:apply-templates select="dss:TLSBindingSignature" />
						</div>
					</div>
				</xsl:if>

    		</div>
    	</div>
    </xsl:template>

	<xsl:template match="dss:X509ValidationDetails|dss:AdESValidationDetails">
		<xsl:variable name="label">
			<xsl:choose>
				<xsl:when test="name() = 'X509ValidationDetails'">X509 Validation Details</xsl:when>
				<xsl:when test="name() = 'AdESValidationDetails'">AdES Validation Details</xsl:when>
				<xsl:otherwise>?</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<dl>
			<xsl:attribute name="class">row mb-0</xsl:attribute>
			<dt>
				<xsl:attribute name="class">col-sm-3</xsl:attribute>

				<xsl:value-of select="$label" />:
			</dt>
			<dd>
				<xsl:attribute name="class">col-sm-9</xsl:attribute>
				<ul>
					<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
					<xsl:apply-templates select="dss:Error" />
					<xsl:apply-templates select="dss:Warning" />
					<xsl:apply-templates select="dss:Info" />
				</ul>
			</dd>
		</dl>
	</xsl:template>

	<xsl:template match="dss:qualificationDetailsAtIssuance|dss:qualificationDetailsAtValidation|dss:qwacDetails">
		<ul>
			<xsl:attribute name="class">list-unstyled</xsl:attribute>

			<xsl:apply-templates select="dss:Error" />
			<xsl:apply-templates select="dss:Warning" />
			<xsl:apply-templates select="dss:Info" />
		</ul>
	</xsl:template>

	<xsl:template match="dss:Error|dss:Warning|dss:Info">
		<xsl:variable name="style">
			<xsl:choose>
				<xsl:when test="name() = 'Error'">danger</xsl:when>
				<xsl:when test="name() = 'Warning'">warning</xsl:when>
				<xsl:otherwise>auto</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li>
			<xsl:attribute name="class">text-<xsl:value-of select="$style" /></xsl:attribute>
			<xsl:value-of select="." />
		</li>
	</xsl:template>

	<xsl:template match="dss:SubIndication">
		<xsl:param name="indicationClass" />
		<xsl:variable name="subIndicationText" select="." />
		<dl>
			<xsl:attribute name="class">row mb-0</xsl:attribute>
			<dt>
				<xsl:attribute name="class">col-sm-3</xsl:attribute>
				Sub indication:
			</dt>
			<dd>
				<xsl:attribute name="class">col-sm-9</xsl:attribute>
				<div>
					<xsl:attribute name="class">badge badge-<xsl:value-of select="$indicationClass" /></xsl:attribute>
					<xsl:value-of select="$subIndicationText" />
				</div>
			</dd>
		</dl>
	</xsl:template>
    
    <xsl:template match="dss:subject">
     	<dl>
		    <xsl:attribute name="class">row mb-0</xsl:attribute>
	  		<xsl:if test="dss:commonName">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Common name:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:commonName"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:givenName">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Given name:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:givenName"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:surname">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Surname:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:surname"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:pseudonym">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
		        	Pseudonym:
		        </dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:pseudonym"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:organizationName">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Organization name:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:organizationName"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:organizationUnit">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Organization Unit:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:organizationUnit"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:email">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Email:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:email"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:locality">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Locality:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:locality"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:state">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		State:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:state"/>
	        	</dd>
	  		</xsl:if>
	  		<xsl:if test="dss:country">
		   		<dt>
	        		<xsl:attribute name="class">col-sm-3</xsl:attribute>
	        		Country:
	        	</dt>
		   		<dd>
	        		<xsl:attribute name="class">col-sm-9</xsl:attribute>
	        		<xsl:value-of select="dss:country"/>
	        	</dd>
	  		</xsl:if>
	  	</dl>
	</xsl:template>
	
	<xsl:template match="dss:keyUsages">
     	<dl>
		    <xsl:attribute name="class">row mb-0</xsl:attribute>
		    
		    <dt>
	        	<xsl:attribute name="class">col-sm-6</xsl:attribute>
	        	Key usages:
	        </dt>
			<dd>
	       		<xsl:attribute name="class">col-sm-6</xsl:attribute>
	   		
				<ul>
	        		<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
				
					<xsl:apply-templates select="dss:keyUsage"/>
				</ul>
			</dd>
		</dl>
	</xsl:template>
	
	<xsl:template match="dss:extendedKeyUsages">
     	<dl>
		    <xsl:attribute name="class">row mb-0</xsl:attribute>
		    
		    <dt>
	        	<xsl:attribute name="class">col-sm-6</xsl:attribute>
	        	Extended key usages:
	        </dt>
			<dd>
	       		<xsl:attribute name="class">col-sm-6</xsl:attribute>
	   		
				<ul>
	        		<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
				
					<xsl:apply-templates select="dss:extendedKeyUsage"/>
				</ul>
			</dd>
		</dl>
	</xsl:template>
	
    <xsl:template match="dss:revocation">
    	<xsl:choose>
			<xsl:when test="dss:revocationDate">
				<i>
					<xsl:attribute name="class">fa fa-times-circle text-danger</xsl:attribute>
					<xsl:attribute name="title">Revoked</xsl:attribute>
				</i>
     			Revoked (reason:<xsl:value-of select="dss:revocationReason" /> @
				<xsl:call-template name="formatdate">
					<xsl:with-param name="DateTimeStr" select="dss:revocationDate"/>
				</xsl:call-template>)
			</xsl:when>    	
			<xsl:when test="dss:thisUpdate">
      			<i>
					<xsl:attribute name="class">fa fa-check-circle text-success</xsl:attribute>
					<xsl:attribute name="title">Not Revoked</xsl:attribute>
				</i>
			</xsl:when>
			<xsl:otherwise>
      			<i>
					<xsl:attribute name="class">fa fa-question-circle text-muted</xsl:attribute>
					<xsl:attribute name="title">No revocation data available</xsl:attribute>
				</i>
			</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template match="dss:ocspUrls">
  		<dt>
			<xsl:attribute name="class">col-sm-3</xsl:attribute>
			        		
  			<acronym>
  				<xsl:attribute name="title">Online Certificate Status Protocol</xsl:attribute>
  				OCSP:
  			</acronym>
		</dt>
		<dd>
       		<xsl:attribute name="class">col-sm-9</xsl:attribute>
   		
			<ul>
        		<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
   				
   				<xsl:apply-templates select="dss:ocspUrl"/>
   			</ul>
   		</dd>
	</xsl:template>
	
  	<xsl:template match="dss:crlUrls">
  		<dt>
			<xsl:attribute name="class">col-sm-3</xsl:attribute>
			
  			<acronym>
  				<xsl:attribute name="title">Certificate Revocation List</xsl:attribute>
		  		CRL:
		  	</acronym>
		</dt>
		<dd>
       		<xsl:attribute name="class">col-sm-9</xsl:attribute>
   		
			<ul>
        		<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
   				
				<xsl:apply-templates select="dss:crlUrl"/>
			</ul>
		</dd>
	</xsl:template>
	
	<xsl:template match="dss:aiaUrls">
  		<dt>
			<xsl:attribute name="class">col-sm-3</xsl:attribute>
			
  			<acronym>
  				<xsl:attribute name="title">Authority Information Access</xsl:attribute>
  		  		AIA:
  		  	</acronym>
		</dt>
		<dd>
       		<xsl:attribute name="class">col-sm-9</xsl:attribute>
   		
			<ul>
        		<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
   				
				<xsl:apply-templates select="dss:aiaUrl"/>
			</ul>
		</dd>
	</xsl:template>
	
    <xsl:template match="dss:cpsUrls">
  		<dt>
			<xsl:attribute name="class">col-sm-3</xsl:attribute>
			
  			<acronym>
  				<xsl:attribute name="title">Certification Practice Statements</xsl:attribute>
  		  		CPS:
  		  	</acronym>
		</dt>
		
		<dd>
       		<xsl:attribute name="class">col-sm-9</xsl:attribute>
   		
			<ul>
        		<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>
   				
				<xsl:apply-templates select="dss:cpsUrl"/>
			</ul>
		</dd>
	</xsl:template>
	
    <xsl:template match="dss:trustAnchors">
  		<dt>
			<xsl:attribute name="class">col-sm-3</xsl:attribute>
  			Trust Anchor:
		</dt>
		
		<dd>
       		<xsl:attribute name="class">col-sm-9</xsl:attribute>
   		
			<ul>
        		<xsl:attribute name="class">list-unstyled mb-0</xsl:attribute>

				<xsl:choose>
					<xsl:when test="count(dss:trustAnchor) &gt; 0" >
						<xsl:apply-templates select="dss:trustAnchor"/>
					</xsl:when>
					<xsl:otherwise>
						Trusted store
					</xsl:otherwise>
				</xsl:choose>
			</ul>
		</dd>
	</xsl:template>
    
    <xsl:template match="dss:trustAnchor">
		<xsl:variable name="subDirectory">
			<xsl:choose>
				<xsl:when test="dss:tslType and $euGenericTSLType = dss:tslType"><xsl:value-of select="$euTLSubDirectoryInTlBrowser" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$tcTLSubDirectoryInTlBrowser" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="countryTlUrl" select="concat($rootUrlInTlBrowser, $subDirectory, '/', dss:countryCode)" />
		<xsl:variable name="countryTspUrl" select="concat($rootUrlInTlBrowser, $subDirectory,
				$trustmarkSubDirectoryInTlBrowser, '/', dss:countryCode, '/', dss:trustServiceProviderRegistrationId)" />

    	<li>
    		<a>
    			<xsl:attribute name="href">
	    			<xsl:value-of select="$countryTlUrl" />
	    		</xsl:attribute>
	    		<xsl:attribute name="target">_blank</xsl:attribute>
	    		<xsl:attribute name="title"><xsl:value-of select="dss:countryCode" /></xsl:attribute>
	    		
	    		<span>
	    			<xsl:attribute name="class">
		    			small_flag <xsl:value-of select="concat('flag_', dss:countryCode)" />
		    		</xsl:attribute>
	    		</span>
    		</a>
    		
    		<i>
    			<xsl:attribute name="class">fa fa-arrow-circle-right ml-2 mr-2</xsl:attribute>
    		</i>
    		
    		<a>
	    		<xsl:attribute name="href">
	    			<xsl:value-of select="$countryTspUrl" />
	    		</xsl:attribute>
	    		<xsl:attribute name="target">_blank</xsl:attribute>
	    		<xsl:attribute name="title">View in TL Browser</xsl:attribute>
	    		
	    		<xsl:value-of select="dss:trustServiceProvider" /> 
    		</a>
    		
    		<i>
    			<xsl:attribute name="class">fa fa-arrow-circle-right ml-2 mr-2</xsl:attribute>
    		</i>
    		
    		<xsl:value-of select="dss:trustServiceName" />
    	</li>
    </xsl:template>
    
    <xsl:template match="dss:keyUsage | dss:extendedKeyUsage">
    	<li><xsl:value-of select="." /></li>
    </xsl:template>
    
    <xsl:template match="dss:ocspUrl | dss:crlUrl | dss:aiaUrl | dss:cpsUrl | dss:pdsUrl">
    	<li>
    		<a>
    			<xsl:attribute name="href"><xsl:value-of select="." /></xsl:attribute>
	    		<xsl:attribute name="target">_blank</xsl:attribute>
	    		
    			<xsl:value-of select="." />
    		</a>
    	</li>
    </xsl:template>

	<xsl:template match="dss:TLSBindingSignature">
		<xsl:param name="cardStyle" select="'primary'" />

		<xsl:variable name="indicationText" select="dss:Indication/text()"/>
		<xsl:variable name="idToken" select="@Id" />
		<xsl:variable name="nodeName" select="name()" />
		<xsl:variable name="indicationCssClass">
			<xsl:choose>
				<xsl:when test="$indicationText='TOTAL_PASSED'">success</xsl:when>
				<xsl:when test="$indicationText='PASSED'">success</xsl:when>
				<xsl:when test="$indicationText='INDETERMINATE'">warning</xsl:when>
				<xsl:when test="$indicationText='FAILED'">danger</xsl:when>
				<xsl:when test="$indicationText='TOTAL_FAILED'">danger</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="copyIdBtnColor">
			<xsl:choose>
				<xsl:when test="$cardStyle='primary'">light</xsl:when>
				<xsl:otherwise>dark</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<div>
			<xsl:attribute name="class">card mb-3</xsl:attribute>
			<div>
				<xsl:attribute name="class">card-header bg-<xsl:value-of select="$cardStyle" /></xsl:attribute>
				<xsl:attribute name="data-target">#collapseSig<xsl:value-of select="$idToken" /></xsl:attribute>
				<xsl:attribute name="data-toggle">collapse</xsl:attribute>

				<span>
					Signature <xsl:value-of select="@Id" />
				</span>
				<i>
					<xsl:attribute name="class">id-copy fa fa-clipboard btn btn-outline-light cursor-pointer text-<xsl:value-of select="$copyIdBtnColor"/> border-0 p-2 ml-1 mr-1</xsl:attribute>
					<xsl:attribute name="data-id"><xsl:value-of select="@Id"/></xsl:attribute>
					<xsl:attribute name="data-toggle">tooltip</xsl:attribute>
					<xsl:attribute name="data-placement">right</xsl:attribute>
					<xsl:attribute name="data-success-text">Id copied successfully!</xsl:attribute>
					<xsl:attribute name="title">Copy Id to clipboard</xsl:attribute>
				</i>
			</div>
			<div>
				<xsl:attribute name="class">card-body collapse show</xsl:attribute>
				<xsl:attribute name="id">collapseSig<xsl:value-of select="$idToken" /></xsl:attribute>

				<xsl:if test="dss:Url">
					<dl>
						<xsl:attribute name="class">row mb-0</xsl:attribute>

						<dt>
							<xsl:attribute name="class">col-sm-3</xsl:attribute>
							URL:
						</dt>
						<dd>
							<xsl:attribute name="class">col-sm-9</xsl:attribute>

							<xsl:value-of select="dss:Url" />
						</dd>
					</dl>
				</xsl:if>

				<xsl:if test="@SignatureFormat">
					<dl>
						<xsl:attribute name="class">row mb-0</xsl:attribute>
						<dt>
							<xsl:attribute name="class">col-sm-3</xsl:attribute>
							Signature format:
						</dt>
						<dd>
							<xsl:attribute name="class">col-sm-9</xsl:attribute>

							<xsl:value-of select="@SignatureFormat"/>
						</dd>
					</dl>
				</xsl:if>

				<dl>
					<xsl:attribute name="class">row mb-0</xsl:attribute>
					<dt>
						<xsl:attribute name="class">col-sm-3</xsl:attribute>
						Indication:
					</dt>
					<dd>
						<xsl:attribute name="class">col-sm-9 text-<xsl:value-of select="$indicationCssClass" /></xsl:attribute>

						<xsl:variable name="dssIndication" select="dss:Indication" />
						<xsl:variable name="semanticText" select="//dss:Semantic[contains(@Key,$dssIndication)]"/>

						<div>
							<xsl:attribute name="class">badge mr-2 badge-<xsl:value-of select="$indicationCssClass" /></xsl:attribute>

							<xsl:if test="string-length($semanticText) &gt; 0">
								<xsl:attribute name="data-toggle">tooltip</xsl:attribute>
								<xsl:attribute name="data-placement">right</xsl:attribute>
								<xsl:attribute name="title"><xsl:value-of select="$semanticText" /></xsl:attribute>
							</xsl:if>

							<xsl:value-of select="$indicationText" />
						</div>

						<xsl:variable name="indication-icon-class">
							<xsl:choose>
								<xsl:when test="$indicationText='TOTAL_PASSED'">fa-check-circle</xsl:when>
								<xsl:when test="$indicationText='PASSED'">fa-check-circle</xsl:when>
								<xsl:when test="$indicationText='INDETERMINATE'">fa-exclamation-circle</xsl:when>
								<xsl:when test="$indicationText='FAILED'">fa-times-circle</xsl:when>
								<xsl:when test="$indicationText='TOTAL_FAILED'">fa-times-circle</xsl:when>
							</xsl:choose>
						</xsl:variable>

						<i>
							<xsl:attribute name="class">fa <xsl:value-of select="$indication-icon-class" /> align-middle</xsl:attribute>
							<xsl:attribute name="data-toggle">tooltip</xsl:attribute>
							<xsl:attribute name="data-placement">right</xsl:attribute>
							<xsl:choose>
								<xsl:when test="string-length($semanticText) &gt; 0">
									<xsl:attribute name="title"><xsl:value-of select="$semanticText" /></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="title"><xsl:value-of select="$indicationText" /></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>

						</i>
					</dd>
				</dl>

				<xsl:apply-templates select="dss:SubIndication">
					<xsl:with-param name="indicationClass" select="$indicationCssClass"/>
				</xsl:apply-templates>

				<xsl:apply-templates select="dss:AdESValidationDetails" />

				<xsl:if test="dss:SigningTime">
					<dl>
						<xsl:attribute name="class">row mb-0</xsl:attribute>
						<dt>
							<xsl:attribute name="class">col-sm-3</xsl:attribute>
							On claimed time:
						</dt>
						<dd>
							<xsl:attribute name="class">col-sm-9</xsl:attribute>

							<xsl:call-template name="formatdate">
								<xsl:with-param name="DateTimeStr" select="dss:SigningTime"/>
							</xsl:call-template>
						</dd>
					</dl>
				</xsl:if>

				<xsl:apply-templates select="dss:SignatureScope" />
				<xsl:apply-templates select="dss:Chain" />

			</div>
		</div>
	</xsl:template>

	<xsl:template match="dss:SignatureScope">
		<dl>
			<xsl:attribute name="class">row mb-0</xsl:attribute>
			<dt>
				<xsl:attribute name="class">col-sm-3</xsl:attribute>
				Signature scope:
			</dt>
			<dd>
				<xsl:attribute name="class">col-sm-9</xsl:attribute>

				<xsl:value-of select="@name"/> (<xsl:value-of select="@scope"/>)<xsl:text>&#xa;</xsl:text>
				<xsl:value-of select="node()"/>
			</dd>
		</dl>
	</xsl:template>

	<xsl:template match="dss:ConnectionDetails">
		<div>
			<xsl:attribute name="class">card</xsl:attribute>
			<div>
				<xsl:attribute name="class">card-header bg-primary</xsl:attribute>
				<xsl:attribute name="data-target">#collapseInfo</xsl:attribute>
				<xsl:attribute name="data-toggle">collapse</xsl:attribute>
				Connection details
			</div>
			<div>
				<xsl:attribute name="class">card-body collapse show</xsl:attribute>
				<xsl:attribute name="id">collapseInfo</xsl:attribute>

				<xsl:if test="dss:Url">
					<dl>
						<xsl:attribute name="class">row mb-0</xsl:attribute>
						<dt>
							<xsl:attribute name="class">col-sm-3</xsl:attribute>
							Connection URL:
						</dt>
						<dd>
							<xsl:attribute name="class">col-sm-9</xsl:attribute>

							<xsl:value-of select="dss:Url"/>
						</dd>
					</dl>
				</xsl:if>
				<xsl:if test="dss:TLSCertificateBindingLink">
					<dl>
						<xsl:attribute name="class">row mb-0</xsl:attribute>
						<dt>
							<xsl:attribute name="class">col-sm-3</xsl:attribute>
							TSL Certificate Binding Link URL:
						</dt>
						<dd>
							<xsl:attribute name="class">col-sm-9</xsl:attribute>

							<xsl:value-of select="dss:TLSCertificateBindingLink"/>
						</dd>
					</dl>
				</xsl:if>

			</div>
		</div>
	</xsl:template>

	<xsl:template match="dss:ValidationPolicy">
		<div>
			<xsl:attribute name="class">card mb-3</xsl:attribute>
			<div>
				<xsl:attribute name="class">card-header bg-primary</xsl:attribute>
				<xsl:attribute name="data-target">#collapsePolicy</xsl:attribute>
				<xsl:attribute name="data-toggle">collapse</xsl:attribute>
				Validation Policy : <xsl:value-of select="dss:PolicyName"/>
			</div>
			<div>
				<xsl:attribute name="class">card-body collapse show</xsl:attribute>
				<xsl:attribute name="id">collapsePolicy</xsl:attribute>
				<xsl:value-of select="dss:PolicyDescription"/>
			</div>
		</div>
	</xsl:template>

	<xsl:template name="formatdate">
		<xsl:param name="DateTimeStr" />

		<xsl:variable name="date">
			<xsl:value-of select="substring-before($DateTimeStr,'T')" />
		</xsl:variable>

		<xsl:variable name="after-T">
			<xsl:value-of select="substring-after($DateTimeStr,'T')" />
		</xsl:variable>

		<xsl:variable name="time">
			<xsl:value-of select="substring-before($after-T,'Z')" />
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="string-length($date) &gt; 0 and string-length($time) &gt; 0">
				<xsl:value-of select="concat($date,' ', $time)" />
			</xsl:when>
			<xsl:when test="string-length($date) &gt; 0">
				<xsl:value-of select="$date" />
			</xsl:when>
			<xsl:when test="string-length($time) &gt; 0">
				<xsl:value-of select="$time" />
			</xsl:when>
			<xsl:otherwise>-</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
