/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.signature.DefaultASiCWithXAdESFilenameFactory;
import eu.europa.esig.dss.utils.Utils;

public class SimpleASiCWithXAdESFilenameFactory
extends DefaultASiCWithXAdESFilenameFactory {
    private static final long serialVersionUID = 8922794783914081984L;
    private String signatureFilename;
    private String manifestFilename;
    private String dataPackageFilename;
    private String evidenceRecordManifestFilename;

    @Override
    public String getSignatureFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.signatureFilename)) {
            return this.getValidSignatureFilename(this.signatureFilename, asicContent);
        }
        return super.getSignatureFilename(asicContent);
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public String getManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.manifestFilename)) {
            return this.getValidManifestFilename(this.manifestFilename, asicContent);
        }
        return super.getManifestFilename(asicContent);
    }

    public void setManifestFilename(String manifestFilename) {
        this.manifestFilename = manifestFilename;
    }

    @Override
    public String getDataPackageFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.dataPackageFilename)) {
            return this.getValidDataPackageFilename(this.dataPackageFilename, asicContent);
        }
        return super.getDataPackageFilename(asicContent);
    }

    public void setDataPackageFilename(String dataPackageFilename) {
        this.dataPackageFilename = dataPackageFilename;
    }

    @Override
    public String getEvidenceRecordManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.evidenceRecordManifestFilename)) {
            return this.getValidEvidenceRecordManifestFilename(this.evidenceRecordManifestFilename, asicContent);
        }
        return super.getEvidenceRecordManifestFilename(asicContent);
    }

    public void setEvidenceRecordManifestFilename(String evidenceRecordManifestFilename) {
        this.evidenceRecordManifestFilename = evidenceRecordManifestFilename;
    }

    protected String getValidSignatureFilename(String signatureFilename, ASiCContent asicContent) {
        signatureFilename = this.getWithMetaInfFolder(signatureFilename);
        this.assertFilenameValid(signatureFilename, asicContent.getSignatureDocuments());
        if (ASiCUtils.isASiCSContainer(asicContent) && !"META-INF/signatures.xml".equals(signatureFilename)) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-S with XAdES container shall have name '%s'!", "META-INF/signatures.xml"));
        }
        if (ASiCUtils.isOpenDocument(asicContent.getMimeTypeDocument()) && !"META-INF/documentsignatures.xml".equals(signatureFilename)) {
            throw new IllegalArgumentException(String.format("A signature file within OpenDocument container shall have name '%s'!", "META-INF/documentsignatures.xml"));
        }
        if (!signatureFilename.startsWith("META-INF/signatures") || !signatureFilename.endsWith(".xml")) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-E with XAdES container shall match the template '%s'!", "META-INF/signatures*.xml"));
        }
        return signatureFilename;
    }

    protected String getValidManifestFilename(String manifestFilename, ASiCContent asicContent) {
        manifestFilename = this.getWithMetaInfFolder(manifestFilename);
        this.assertFilenameValid(manifestFilename, asicContent.getManifestDocuments());
        if (!"META-INF/manifest.xml".equals(manifestFilename)) {
            throw new IllegalArgumentException(String.format("A manifest file within ASiC with XAdES container shall have name '%s'!", "META-INF/manifest.xml"));
        }
        return manifestFilename;
    }
}

