/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.evidencerecord;

import eu.europa.esig.dss.cades.evidencerecord.CAdESEvidenceRecordDigestBuilder;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureAttribute;
import eu.europa.esig.dss.spi.validation.evidencerecord.AbstractEmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.validation.evidencerecord.SignatureEvidenceRecordDigestBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public class CAdESEmbeddedEvidenceRecordHelper
extends AbstractEmbeddedEvidenceRecordHelper {
    public CAdESEmbeddedEvidenceRecordHelper(CAdESSignature signature) {
        super(signature);
    }

    public CAdESEmbeddedEvidenceRecordHelper(CAdESSignature signature, CAdESAttribute evidenceRecordAttribute) {
        super(signature, evidenceRecordAttribute);
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        if (Utils.collectionSize(detachedContents) != 1) {
            throw new IllegalArgumentException("One and only one detached document is allowed for an embedded evidence record in CAdES!");
        }
        super.setDetachedContents(detachedContents);
    }

    @Override
    protected SignatureEvidenceRecordDigestBuilder getDigestBuilder(AdvancedSignature signature, SignatureAttribute evidenceRecordAttribute, DigestAlgorithm digestAlgorithm) {
        CAdESEvidenceRecordDigestBuilder digestBuilder = new CAdESEvidenceRecordDigestBuilder(signature, evidenceRecordAttribute, digestAlgorithm);
        if (this.isDetached(signature)) {
            digestBuilder.setDetachedContent(this.getDetachedDocument());
        }
        return digestBuilder;
    }

    private boolean isDetached(AdvancedSignature signature) {
        if (signature instanceof CAdESSignature) {
            return ((CAdESSignature)signature).getCMS().isDetachedSignature();
        }
        throw new IllegalStateException("Only instance of CAdESSignature is supported by CAdESEmbeddedEvidenceRecordHelper");
    }

    protected DSSDocument getDetachedDocument() {
        List<DSSDocument> detachedContents = this.getDetachedContents();
        if (Utils.collectionSize(detachedContents) == 1) {
            return detachedContents.get(0);
        }
        return null;
    }

    @Override
    protected void setDEREncoding(SignatureEvidenceRecordDigestBuilder digestBuilder, boolean derEncoded) {
        if (!(digestBuilder instanceof CAdESEvidenceRecordDigestBuilder)) {
            throw new IllegalArgumentException("The digestBuilder shall be an instance of CAdESEvidenceRecordDigestBuilder!");
        }
        CAdESEvidenceRecordDigestBuilder cadesEvidenceRecordDigestBuilder = (CAdESEvidenceRecordDigestBuilder)digestBuilder;
        cadesEvidenceRecordDigestBuilder.setDEREncoded(derEncoded);
    }

    @Override
    public boolean isEncodingSelectionSupported() {
        return true;
    }

    @Override
    public boolean isAbsentHashtreeSupported() {
        return true;
    }
}

