/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.extension;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.cades.validation.CMSDocumentAnalyzerFactory;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.extension.AbstractDocumentExtender;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import java.util.Objects;

public class CAdESDocumentExtender
extends AbstractDocumentExtender<CAdESSignatureParameters, CAdESTimestampParameters> {
    CAdESDocumentExtender() {
    }

    public CAdESDocumentExtender(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be extended cannot be null!");
        this.document = document;
    }

    @Override
    protected DocumentSignatureService<CAdESSignatureParameters, CAdESTimestampParameters> createSignatureService() {
        Objects.requireNonNull(this.certificateVerifier, "Please provide CertificateVerifier or corresponding CAdESService!");
        CAdESService service = new CAdESService(this.certificateVerifier);
        service.setTspSource(this.tspSource);
        return service;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return new CMSDocumentAnalyzerFactory().isSupported(dssDocument);
    }

    @Override
    protected CAdESSignatureParameters emptySignatureParameters() {
        return new CAdESSignatureParameters();
    }

    @Override
    protected boolean isSupportedParameters(SerializableSignatureParameters parameters) {
        return parameters instanceof CAdESSignatureParameters;
    }

    @Override
    protected boolean isSupportedService(DocumentSignatureService<?, ?> service) {
        return service instanceof CAdESService;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.CAdES;
    }
}

