/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CAdESUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.signature.BaselineRequirementsChecker;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESBaselineRequirementsChecker
extends BaselineRequirementsChecker<CAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESBaselineRequirementsChecker.class);

    protected CAdESBaselineRequirementsChecker(CAdESSignature signature) {
        this(signature, (CertificateVerifier)null);
    }

    public CAdESBaselineRequirementsChecker(CAdESSignature signature, CertificateVerifier offlineCertificateVerifier) {
        super(signature, offlineCertificateVerifier);
    }

    protected SignatureForm getBaselineSignatureForm() {
        return SignatureForm.CAdES;
    }

    protected boolean cmsBaselineBRequirements() {
        boolean cades;
        CMS cms = ((CAdESSignature)this.signature).getCMS();
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        if (Utils.isCollectionEmpty(cms.getCertificates().getMatches(null))) {
            LOG.warn("SignedData.certificates shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isContentTypeValid(signerInformation)) {
            LOG.warn("content-type attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isMessageDigestPresent(signerInformation)) {
            LOG.warn("message-digest attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isOneSigningCertificatePresent(signerInformation)) {
            LOG.warn("signing-certificate(-v2) attribute shall be present for {}-BASELINE-B signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        Attribute[] signingTimeAttrs = CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        boolean signingTimePresent = this.getAttributeValuesSize(signingTimeAttrs) == 1;
        if (signingTimePresent != (cades = SignatureForm.CAdES.equals((Object)signatureForm))) {
            if (cades) {
                LOG.warn("signing-time attribute shall be present for {}-BASELINE-B signature (cardinality == 1})!", (Object)signatureForm);
            } else {
                LOG.warn("signing-time attribute shall not be present for {}-BASELINE-B signature (cardinality == 0})!", (Object)signatureForm);
            }
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_signerAttr)) + Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, OID.id_aa_ets_signerAttrV2)) > 1) {
            LOG.warn("signer-attributes(-v2) attribute shall not be present multiple times for {}-BASELINE-B signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) > 1) {
            LOG.warn("signature-policy-identifier attribute shall not be present multiple times for {}-BASELINE-B signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.containsSigningCertificate(((CAdESSignature)this.signature).getCertificateSource().getSignedDataCertificates())) {
            LOG.warn("Signing certificate shall be present in SignedData.certificates for {}-BASELINE-B signature (requirement (a))!", (Object)signatureForm);
            return false;
        }
        if (((CAdESSignature)this.signature).getContentType() != null && !PKCSObjectIdentifiers.data.getId().equals(((CAdESSignature)this.signature).getContentType())) {
            LOG.warn("The content-type attribute shall have value id-data for {}-BASELINE-B signature (requirement (f))!", (Object)signatureForm);
            return false;
        }
        if (!this.isSigningCertificateAttributeValid(signerInformation)) {
            LOG.warn("signing-certificate attribute shall be used for SHA1 hash algorithm and signing-certificate-v2 for other hash algorithms for {}-BASELINE-B signature (requirements (h) and (i) 319 122-1)!", (Object)signatureForm);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasBaselineBProfile() {
        if (!this.cmsBaselineBRequirements()) {
            return false;
        }
        SignaturePolicyStore signaturePolicyStore = ((CAdESSignature)this.signature).getSignaturePolicyStore();
        if (signaturePolicyStore != null && !this.isSignaturePolicyIdentifierHashPresent()) {
            LOG.warn("signature-policy-store shall not be present for CAdES-BASELINE-B signature with not defined signature-policy-identifier/sigPolicyHash (requirement (k))!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasBaselineTProfile() {
        if (!this.minimalTRequirement()) {
            return false;
        }
        if (!this.signatureTimestampsCreatedBeforeSignCertExpiration()) {
            LOG.warn("signature-time-stamp shall be created before expiration of the signing-certificate for CAdES-BASELINE-T signature (requirement (m))!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasBaselineLTProfile() {
        if (!this.minimalLTRequirement()) {
            return false;
        }
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (Utils.isArrayNotEmpty(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certValues))) {
            LOG.warn("certificate-values attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs))) {
            LOG.warn("complete-certificate-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationValues))) {
            LOG.warn("revocation-values attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs))) {
            LOG.warn("complete-revocation-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (Utils.isArrayNotEmpty(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp))) {
            LOG.warn("time-stamped-certs-crls-references attribute shall not be present for CAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        return true;
    }

    @Override
    protected boolean containsLTLevelCertificates() {
        CMS cms = ((CAdESSignature)this.signature).getCMS();
        List signedDataCertificates = cms.getCertificates().getMatches(null).stream().map(DSSASN1Utils::getCertificate).collect(Collectors.toList());
        ListCertificateSource timestampListCertificateSource = ((CAdESSignature)this.signature).getTimestampSource().getTimestampCertificateSourcesExceptLastArchiveTimestamp();
        List<CertificateSource> timestampCertificateSources = timestampListCertificateSource.getSources();
        if (Utils.isCollectionEmpty(timestampCertificateSources)) {
            return false;
        }
        for (CertificateSource timestampCertificateSource : timestampCertificateSources) {
            if (Utils.containsAny(signedDataCertificates, timestampCertificateSource.getCertificates())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasBaselineLTAProfile() {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        timestampTokens.addAll(((CAdESSignature)this.signature).getArchiveTimestamps());
        timestampTokens.addAll(((CAdESSignature)this.signature).getDetachedTimestamps());
        if (Utils.isCollectionEmpty(timestampTokens)) {
            LOG.trace("ArchiveTimeStamp shall be present for CAdES-BASELINE-LTA signature (cardinality >= 1)!");
            return false;
        }
        boolean validArcTstFound = false;
        for (TimestampToken timestampToken : timestampTokens) {
            if (!ArchiveTimestampType.CAdES_V3.equals((Object)timestampToken.getArchiveTimestampType()) && !timestampToken.getTimeStampType().isContainerTimestamp()) continue;
            validArcTstFound = true;
            break;
        }
        if (!validArcTstFound) {
            LOG.warn("archive-time-stamp-v3 attribute shall be present for CAdES-BASELINE-LTA signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExtendedBESProfile() {
        if (!this.cmsExtendedBESRequirements()) {
            return false;
        }
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_signingTime)) > 1) {
            LOG.warn("signing-time attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_commitmentType)) > 1) {
            LOG.warn("commitment-time-indication attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_contentHint)) > 1) {
            LOG.warn("content-hints attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, OID.id_aa_ets_mimeType)) > 1) {
            LOG.warn("mime-type attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_signerLocation)) > 1) {
            LOG.warn("signer-location attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) > 1) {
            LOG.warn("signature-policy-identifier attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) > 1) {
            LOG.warn("signature-policy-identifier attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, OID.id_aa_ets_sigPolicyStore)) > 1) {
            LOG.warn("signature-policy-store attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_contentReference)) > 1) {
            LOG.warn("content-reference attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_contentIdentifier)) > 1) {
            LOG.warn("content-identifier attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs)) > 1) {
            LOG.warn("complete-certificate-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs)) > 1) {
            LOG.warn("complete-revocation-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, OID.attributeCertificateRefsOid)) > 1) {
            LOG.warn("attribute-certificate-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, OID.attributeRevocationRefsOid)) > 1) {
            LOG.warn("attribute-revocation-references attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certValues)) > 1) {
            LOG.warn("certificate-values attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationValues)) > 1) {
            LOG.warn("revocation-values attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isSigningCertificateAttributeValid(signerInformation)) {
            LOG.warn("signing-certificate attribute shall be used for SHA1 hash algorithm and signing-certificate-v2 for other hash algorithms for {}-BES signature (requirements (a) and (b) 319 122-2)!", (Object)signatureForm);
            return false;
        }
        return true;
    }

    protected boolean cmsExtendedBESRequirements() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        if (!this.isContentTypeValid(signerInformation)) {
            LOG.warn("content-type attribute shall be present for {}-BES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isMessageDigestPresent(signerInformation)) {
            LOG.warn("message-digest attribute shall be present for {}-BES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (!this.isOneSigningCertificatePresent(signerInformation)) {
            LOG.warn("signing-certificate(-v2) attribute shall be present for {}-BES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        if (Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_signerAttr)) + Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, OID.id_aa_ets_signerAttrV2)) > 1) {
            LOG.warn("signer-attributes(-v2) attribute shall not be present multiple times for {}-BES signature (cardinality == 0 or 1)!", (Object)signatureForm);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExtendedEPESProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        SignatureForm signatureForm = this.getBaselineSignatureForm();
        Attribute[] sigPolicyIdAttrs = CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_sigPolicyId);
        if (this.getAttributeValuesSize(sigPolicyIdAttrs) == 0) {
            LOG.debug("signature-policy-identifier attribute shall be present for {}-EPES signature (cardinality == 1)!", (Object)signatureForm);
            return false;
        }
        SignaturePolicyStore signaturePolicyStore = ((CAdESSignature)this.signature).getSignaturePolicyStore();
        if (signaturePolicyStore != null && !this.isSignaturePolicyIdentifierHashPresent()) {
            LOG.debug("signature-policy-store may be present for {}-EPES signature only if signature-policy-identifier is present and it contains sigPolicyHash element (requirement (c))!", (Object)signatureForm);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExtendedTProfile() {
        if (!this.minimalTRequirement()) {
            return false;
        }
        if (!this.signatureTimestampsCreatedBeforeSignCertExpiration()) {
            LOG.warn("signature-time-stamp shall be created before expiration of the signing-certificate for CAdES-T signature (requirement (f))!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExtendedCProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        Attribute[] certificateRefAttrs = CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
        int completeCertificateRefsNumberOfOccurrences = this.getAttributeValuesSize(certificateRefAttrs);
        if (completeCertificateRefsNumberOfOccurrences > 1 || completeCertificateRefsNumberOfOccurrences == 0) {
            LOG.debug("complete-certificate-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        boolean allSelfSigned = certificateFound && certificateSources.isAllSelfSigned();
        Attribute[] revocationRefAttrs = CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
        int completeRevocationRefsNumberOfOccurrences = this.getAttributeValuesSize(revocationRefAttrs);
        if (completeRevocationRefsNumberOfOccurrences > 1 || !allSelfSigned && completeRevocationRefsNumberOfOccurrences == 0) {
            LOG.debug("complete-revocation-references attribute shall be present for CAdES-C signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExtendedXProfile() {
        SignerInformation signerInformation = ((CAdESSignature)this.signature).getSignerInformation();
        if (Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp)) + Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_ets_escTimeStamp)) != 1) {
            LOG.debug("CAdES-C-timestamp or time-stamped-certs-crls-references attribute shall be present for CAdES-X signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExtendedXLProfile() {
        return this.minimalLTRequirement();
    }

    @Override
    public boolean hasExtendedAProfile() {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        timestampTokens.addAll(((CAdESSignature)this.signature).getArchiveTimestamps());
        timestampTokens.addAll(((CAdESSignature)this.signature).getDetachedTimestamps());
        if (Utils.isCollectionEmpty(timestampTokens)) {
            LOG.trace("ArchiveTimeStamp shall be present for CAdES-A signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExtendedERSProfile() {
        boolean signerERSFound = false;
        for (SignerInformation signerInformation : ((CAdESSignature)this.signature).getCMS().getSignerInfos()) {
            int externalERNumber;
            int internalERNumber = Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, OID.id_aa_er_internal));
            if (internalERNumber + (externalERNumber = Utils.arraySize(CAdESUtils.getUnsignedAttributes(signerInformation, OID.id_aa_er_external))) == 0) {
                LOG.debug("internal-evidence-records or external-evidence-records attribute shall be present for CAdES-ERS signature (cardinality >= 1)!");
                continue;
            }
            if (((CAdESSignature)this.signature).getCMS().isDetachedSignature()) {
                if (internalERNumber > 0) {
                    LOG.warn("In case a signature is detached, the external-evidence-records attribute shall be used (requirement (q))!");
                    continue;
                }
            } else if (externalERNumber > 0) {
                LOG.warn("In case a signature is attached, the internal-evidence-records attribute shall be used (requirement (q))!");
                continue;
            }
            signerERSFound = true;
        }
        return signerERSFound;
    }

    private boolean isContentTypeValid(SignerInformation signerInformation) {
        Attribute[] contentTypeAttrs = CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_contentType);
        int numberOfOccurrences = this.getAttributeValuesSize(contentTypeAttrs);
        if (((CAdESSignature)this.signature).isCounterSignature() && numberOfOccurrences == 0) {
            return true;
        }
        return numberOfOccurrences == 1;
    }

    private boolean isMessageDigestPresent(SignerInformation signerInformation) {
        Attribute[] messageDigestAttrs = CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        return this.getAttributeValuesSize(messageDigestAttrs) == 1;
    }

    private boolean isOneSigningCertificatePresent(SignerInformation signerInformation) {
        Attribute[] signingCertAttrs = CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificate);
        Attribute[] signingCertV2Attrs = CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        return this.getAttributeValuesSize(signingCertAttrs) + this.getAttributeValuesSize(signingCertV2Attrs) == 1;
    }

    private boolean isSigningCertificateAttributeValid(SignerInformation signerInformation) {
        DigestAlgorithm digestAlgorithm;
        CertificateRef signingCertificateRef;
        Digest certDigest;
        List<CertificateRef> certificateRefs = ((CAdESSignature)this.signature).getCertificateSource().getSigningCertificateRefs();
        return !Utils.isCollectionNotEmpty(certificateRefs) || (certDigest = (signingCertificateRef = certificateRefs.iterator().next()).getCertDigest()) == null || !(DigestAlgorithm.SHA1.equals(digestAlgorithm = certDigest.getAlgorithm()) ? Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificate)) == 0 : Utils.arraySize(CAdESUtils.getSignedAttributes(signerInformation, PKCSObjectIdentifiers.id_aa_signingCertificateV2)) == 0);
    }

    private int getAttributeValuesSize(Attribute ... attributes) {
        int counter = 0;
        for (Attribute attribute : attributes) {
            ASN1Encodable attrValue = DSSASN1Utils.getAsn1Encodable(attribute);
            if (attrValue == null) continue;
            ++counter;
        }
        return counter;
    }
}

