/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms.object;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Store;

public class CMSSignedDataObject
implements CMS {
    private final CMSSignedData cmsSignedData;

    public CMSSignedDataObject(CMSSignedData cmsSignedData) {
        this.cmsSignedData = cmsSignedData;
    }

    public CMSSignedData getCMSSignedData() {
        return this.cmsSignedData;
    }

    @Override
    public int getVersion() {
        return this.cmsSignedData.getVersion();
    }

    @Override
    public Set<AlgorithmIdentifier> getDigestAlgorithmIDs() {
        return this.cmsSignedData.getDigestAlgorithmIDs();
    }

    @Override
    public boolean isDetachedSignature() {
        return this.cmsSignedData.isDetachedSignature();
    }

    @Override
    public ASN1ObjectIdentifier getSignedContentType() {
        if (this.cmsSignedData.getSignedContentTypeOID() != null) {
            return new ASN1ObjectIdentifier(this.cmsSignedData.getSignedContentTypeOID());
        }
        return null;
    }

    @Override
    public DSSDocument getSignedContent() {
        if (this.cmsSignedData.getSignedContent() != null) {
            return this.getSignedContent(this.cmsSignedData.getSignedContent());
        }
        return null;
    }

    private DSSDocument getSignedContent(CMSTypedData cmsTypedData) {
        InMemoryDocument inMemoryDocument;
        if (cmsTypedData == null) {
            throw new DSSException("CMSTypedData is null (should be a detached signature)");
        }
        ByteArrayOutputStream originalDocumentData = new ByteArrayOutputStream();
        try {
            cmsTypedData.write(originalDocumentData);
            inMemoryDocument = new InMemoryDocument(originalDocumentData.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    originalDocumentData.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CMSException e) {
                throw new DSSException(e);
            }
        }
        originalDocumentData.close();
        return inMemoryDocument;
    }

    @Override
    public Store<X509CertificateHolder> getCertificates() {
        return this.cmsSignedData.getCertificates();
    }

    @Override
    public Store<X509CRLHolder> getCRLs() {
        return this.cmsSignedData.getCRLs();
    }

    @Override
    public Store<X509AttributeCertificateHolder> getAttributeCertificates() {
        return this.cmsSignedData.getAttributeCertificates();
    }

    @Override
    public Store<?> getOcspResponseStore() {
        return this.cmsSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
    }

    @Override
    public Store<?> getOcspBasicStore() {
        return this.cmsSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
    }

    @Override
    public SignerInformationStore getSignerInfos() {
        return this.cmsSignedData.getSignerInfos();
    }

    @Override
    public byte[] getDEREncoded() {
        return DSSASN1Utils.getDEREncoded(this.cmsSignedData);
    }

    @Override
    public byte[] getEncoded() {
        return DSSASN1Utils.getEncoded(this.cmsSignedData);
    }
}

