/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms.operator;

import eu.europa.esig.dss.cms.operator.CustomContentSigner;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.SignatureValue;
import java.util.Objects;

public class CustomContentSignerBuilder {
    public CustomContentSigner build(SignatureAlgorithm signatureAlgorithm) {
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm cannot be null!");
        return new CustomContentSigner(signatureAlgorithm.getJCEId());
    }

    public CustomContentSigner build(SignatureAlgorithm signatureAlgorithm, SignatureValue signatureValue) {
        Objects.requireNonNull(signatureAlgorithm, "SignatureAlgorithm cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        if (signatureAlgorithm != signatureValue.getAlgorithm()) {
            throw new IllegalArgumentException(String.format("The defined SignatureAlgorithm '%s' does not match the SignatureAlgorithm '%s' used on SignatureValue computation!", signatureAlgorithm, signatureValue.getAlgorithm()));
        }
        return new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
    }
}

