/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.detailedreport;

import eu.europa.esig.dss.detailedreport.DetailedReportMessageCollector;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateQualificationProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlQWACProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualificationAtTime;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.QWACProfile;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.jaxb.object.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class DetailedReport {
    private final XmlDetailedReport jaxbDetailedReport;
    private DetailedReportMessageCollector messageCollector;

    public DetailedReport(XmlDetailedReport jaxbDetailedReport) {
        this.jaxbDetailedReport = jaxbDetailedReport;
    }

    public Indication getBasicBuildingBlocksIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicBuildingBlocksSubIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getSubIndication();
        }
        return null;
    }

    public List<String> getBasicBuildingBlocksCertChain(String tokenId) {
        List<XmlChainItem> chainItems;
        LinkedList<String> certIds = new LinkedList<String>();
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null && (chainItems = bbb.getCertificateChain().getChainItem()) != null) {
            for (XmlChainItem chainItem : chainItems) {
                certIds.add(chainItem.getId());
            }
        }
        return certIds;
    }

    public XmlBasicBuildingBlocks getBasicBuildingBlockById(String tokenId) {
        List<XmlBasicBuildingBlocks> basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (basicBuildingBlocks != null) {
            for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
                if (!tokenId.equals(xmlBasicBuildingBlocks.getId())) continue;
                return xmlBasicBuildingBlocks;
            }
        }
        return null;
    }

    public int getBasicBuildingBlocksNumber() {
        return this.jaxbDetailedReport.getBasicBuildingBlocks().size();
    }

    public String getBasicBuildingBlocksSignatureId(int index) {
        XmlBasicBuildingBlocks bbb;
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (bbbs != null && bbbs.size() >= index && (bbb = this.jaxbDetailedReport.getBasicBuildingBlocks().get(index)) != null) {
            return bbb.getId();
        }
        return null;
    }

    public List<String> getSignatureIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.SIGNATURE != bbb.getType() && Context.COUNTER_SIGNATURE != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public String getFirstSignatureId() {
        List<String> signatureIdList = this.getSignatureIds();
        if (!signatureIdList.isEmpty()) {
            return signatureIdList.get(0);
        }
        return null;
    }

    public String getFirstTimestampId() {
        List<String> timestampIdList = this.getTimestampIds();
        if (!timestampIdList.isEmpty()) {
            return timestampIdList.get(0);
        }
        return null;
    }

    public List<String> getTimestampIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.TIMESTAMP != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public String getFirstEvidenceRecordId() {
        List<String> evidenceRecordIds = this.getEvidenceRecordIds();
        if (!evidenceRecordIds.isEmpty()) {
            return evidenceRecordIds.get(0);
        }
        return null;
    }

    public List<String> getEvidenceRecordIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<Serializable> tokens = this.jaxbDetailedReport.getSignatureOrTimestampOrEvidenceRecord();
        for (Serializable token : tokens) {
            if (token instanceof XmlEvidenceRecord) {
                XmlEvidenceRecord xmlEvidenceRecord = (XmlEvidenceRecord)token;
                result.add(xmlEvidenceRecord.getId());
                continue;
            }
            if (!(token instanceof XmlSignature)) continue;
            XmlSignature xmlSignature = (XmlSignature)token;
            List<XmlEvidenceRecord> evidenceRecords = xmlSignature.getEvidenceRecords();
            for (XmlEvidenceRecord xmlEvidenceRecord : evidenceRecords) {
                result.add(xmlEvidenceRecord.getId());
            }
        }
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.TIMESTAMP != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public List<String> getRevocationIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.REVOCATION != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public Date getBestSignatureTime(String signatureId) {
        XmlProofOfExistence proofOfExistence = this.getBestProofOfExistence(signatureId);
        if (proofOfExistence != null) {
            return proofOfExistence.getTime();
        }
        return null;
    }

    public XmlProofOfExistence getBestProofOfExistence(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature != null) {
            if (xmlSignature.getValidationProcessArchivalData() != null) {
                return xmlSignature.getValidationProcessArchivalData().getProofOfExistence();
            }
            if (xmlSignature.getValidationProcessLongTermData() != null) {
                return xmlSignature.getValidationProcessLongTermData().getProofOfExistence();
            }
            if (xmlSignature.getValidationProcessBasicSignature() != null) {
                return xmlSignature.getValidationProcessBasicSignature().getProofOfExistence();
            }
        }
        return null;
    }

    public Date getEvidenceRecordLowestPOETime(String evidenceRecordId) {
        XmlProofOfExistence poe;
        XmlEvidenceRecord xmlEvidenceRecord = this.getXmlEvidenceRecordById(evidenceRecordId);
        if (xmlEvidenceRecord != null && xmlEvidenceRecord.getValidationProcessEvidenceRecord() != null && (poe = xmlEvidenceRecord.getValidationProcessEvidenceRecord().getProofOfExistence()) != null) {
            return poe.getTime();
        }
        return null;
    }

    public Indication getBasicValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignature() != null && signature.getValidationProcessBasicSignature().getConclusion() != null) {
            return signature.getValidationProcessBasicSignature().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignature() != null && signature.getValidationProcessBasicSignature().getConclusion() != null) {
            return signature.getValidationProcessBasicSignature().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getBasicTimestampValidationIndication(String timestampId) {
        XmlValidationProcessBasicTimestamp timestampValidationById = this.getBasicTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicTimestampValidationSubIndication(String timestampId) {
        XmlValidationProcessBasicTimestamp timestampValidationById = this.getBasicTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getArchiveDataTimestampValidationIndication(String timestampId) {
        XmlValidationProcessArchivalDataTimestamp timestampValidationById = this.getArchiveDataTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getArchiveDataTimestampValidationSubIndication(String timestampId) {
        XmlValidationProcessArchivalDataTimestamp timestampValidationById = this.getArchiveDataTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getEvidenceRecordValidationIndication(String evidenceRecordId) {
        XmlValidationProcessEvidenceRecord evidenceRecordValidationById = this.getEvidenceRecordValidationById(evidenceRecordId);
        if (evidenceRecordValidationById != null && evidenceRecordValidationById.getConclusion() != null) {
            return evidenceRecordValidationById.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getEvidenceRecordValidationSubIndication(String evidenceRecordId) {
        XmlValidationProcessEvidenceRecord evidenceRecordValidationById = this.getEvidenceRecordValidationById(evidenceRecordId);
        if (evidenceRecordValidationById != null && evidenceRecordValidationById.getConclusion() != null) {
            return evidenceRecordValidationById.getConclusion().getSubIndication();
        }
        return null;
    }

    private XmlValidationProcessEvidenceRecord getEvidenceRecordValidationById(String evidenceRecordId) {
        XmlEvidenceRecord evidenceRecord = this.getXmlEvidenceRecordById(evidenceRecordId);
        if (evidenceRecord != null) {
            return evidenceRecord.getValidationProcessEvidenceRecord();
        }
        return null;
    }

    public XmlEvidenceRecord getXmlEvidenceRecordById(String evidenceRecordId) {
        for (XmlEvidenceRecord xmlEvidenceRecord : this.getIndependentEvidenceRecords()) {
            if (!xmlEvidenceRecord.getId().equals(evidenceRecordId)) continue;
            return xmlEvidenceRecord;
        }
        for (XmlSignature xmlSignature : this.getSignatures()) {
            for (XmlEvidenceRecord xmlEvidenceRecord : xmlSignature.getEvidenceRecords()) {
                if (!xmlEvidenceRecord.getId().equals(evidenceRecordId)) continue;
                return xmlEvidenceRecord;
            }
        }
        for (XmlTimestamp xmlTimestamp : this.getIndependentTimestamps()) {
            for (XmlEvidenceRecord xmlEvidenceRecord : xmlTimestamp.getEvidenceRecords()) {
                if (!xmlEvidenceRecord.getId().equals(evidenceRecordId)) continue;
                return xmlEvidenceRecord;
            }
        }
        return null;
    }

    public Indication getLongTermValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getLongTermValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getArchiveDataValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getArchiveDataValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getSubIndication();
        }
        return null;
    }

    public SignatureQualification getSignatureQualification(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationSignatureQualification() != null) {
            return signature.getValidationSignatureQualification().getSignatureQualification();
        }
        return null;
    }

    public TimestampQualification getTimestampQualification(String timestampId) {
        XmlValidationTimestampQualification timestampQualif = this.getXmlTimestampQualificationById(timestampId);
        if (timestampQualif != null) {
            return timestampQualif.getTimestampQualification();
        }
        return null;
    }

    public TimestampQualification getTimestampQualificationAtTstGenerationTime(String timestampId) {
        return this.getTimestampQualificationAtValidationTime(ValidationTime.TIMESTAMP_GENERATION_TIME, timestampId);
    }

    public TimestampQualification getTimestampQualificationAtBestPoeTime(String timestampId) {
        return this.getTimestampQualificationAtValidationTime(ValidationTime.TIMESTAMP_POE_TIME, timestampId);
    }

    private TimestampQualification getTimestampQualificationAtValidationTime(ValidationTime validationTime, String timestampId) {
        XmlValidationTimestampQualification tstQualificationValidation = this.getXmlTimestampQualificationById(timestampId);
        if (tstQualificationValidation != null) {
            for (XmlValidationTimestampQualificationAtTime tstQualAtTime : tstQualificationValidation.getValidationTimestampQualificationAtTime()) {
                if (validationTime != tstQualAtTime.getValidationTime()) continue;
                return tstQualAtTime.getTimestampQualification();
            }
        }
        return null;
    }

    private XmlValidationTimestampQualification getXmlTimestampQualificationById(String timestampId) {
        XmlTimestamp timestamp = this.getXmlTimestampById(timestampId);
        if (timestamp != null) {
            return timestamp.getValidationTimestampQualification();
        }
        return null;
    }

    private XmlValidationProcessBasicTimestamp getBasicTimestampValidationById(String timestampId) {
        XmlTimestamp timestamp = this.getXmlTimestampById(timestampId);
        if (timestamp != null) {
            return timestamp.getValidationProcessBasicTimestamp();
        }
        return null;
    }

    private XmlValidationProcessArchivalDataTimestamp getArchiveDataTimestampValidationById(String timestampId) {
        XmlTimestamp timestamp = this.getXmlTimestampById(timestampId);
        if (timestamp != null) {
            return timestamp.getValidationProcessArchivalDataTimestamp();
        }
        return null;
    }

    public XmlTimestamp getXmlTimestampById(String timestampId) {
        for (XmlTimestamp xmlTimestamp : this.getIndependentTimestamps()) {
            if (xmlTimestamp.getId().equals(timestampId)) {
                return xmlTimestamp;
            }
            for (XmlEvidenceRecord xmlEvidenceRecord : xmlTimestamp.getEvidenceRecords()) {
                for (XmlTimestamp xmlERTimestamp : xmlEvidenceRecord.getTimestamps()) {
                    if (!xmlERTimestamp.getId().equals(timestampId)) continue;
                    return xmlERTimestamp;
                }
            }
        }
        List<XmlSignature> signatures = this.getSignatures();
        for (XmlSignature xmlSignature : signatures) {
            List<XmlTimestamp> timestamps = xmlSignature.getTimestamps();
            for (XmlTimestamp xmlTimestamp : timestamps) {
                if (!xmlTimestamp.getId().equals(timestampId)) continue;
                return xmlTimestamp;
            }
            for (XmlEvidenceRecord xmlEvidenceRecord : xmlSignature.getEvidenceRecords()) {
                for (XmlTimestamp xmlTimestamp : xmlEvidenceRecord.getTimestamps()) {
                    if (!xmlTimestamp.getId().equals(timestampId)) continue;
                    return xmlTimestamp;
                }
            }
        }
        List<XmlEvidenceRecord> list = this.getIndependentEvidenceRecords();
        for (XmlEvidenceRecord xmlEvidenceRecord : list) {
            List<XmlTimestamp> timestamps = xmlEvidenceRecord.getTimestamps();
            for (XmlTimestamp xmlTimestamp : timestamps) {
                if (!xmlTimestamp.getId().equals(timestampId)) continue;
                return xmlTimestamp;
            }
        }
        return null;
    }

    public XmlSignature getXmlSignatureById(String signatureId) {
        List<XmlSignature> signatures = this.getSignatures();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                if (!signatureId.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    public XmlCertificate getXmlCertificateById(String certificateId) {
        List<XmlCertificate> certificates = this.getCertificates();
        if (certificates != null) {
            for (XmlCertificate xmlCertificate : certificates) {
                if (!certificateId.equals(xmlCertificate.getId())) continue;
                return xmlCertificate;
            }
        }
        return null;
    }

    public List<XmlSignature> getSignatures() {
        ArrayList<XmlSignature> result = new ArrayList<XmlSignature>();
        for (Serializable element : this.jaxbDetailedReport.getSignatureOrTimestampOrEvidenceRecord()) {
            if (!(element instanceof XmlSignature)) continue;
            result.add((XmlSignature)element);
        }
        return result;
    }

    public List<XmlTimestamp> getIndependentTimestamps() {
        ArrayList<XmlTimestamp> result = new ArrayList<XmlTimestamp>();
        for (Serializable element : this.jaxbDetailedReport.getSignatureOrTimestampOrEvidenceRecord()) {
            if (!(element instanceof XmlTimestamp)) continue;
            result.add((XmlTimestamp)element);
        }
        return result;
    }

    public List<XmlEvidenceRecord> getIndependentEvidenceRecords() {
        ArrayList<XmlEvidenceRecord> result = new ArrayList<XmlEvidenceRecord>();
        for (Serializable element : this.jaxbDetailedReport.getSignatureOrTimestampOrEvidenceRecord()) {
            if (!(element instanceof XmlEvidenceRecord)) continue;
            result.add((XmlEvidenceRecord)element);
        }
        return result;
    }

    public List<XmlCertificate> getCertificates() {
        ArrayList<XmlCertificate> result = new ArrayList<XmlCertificate>();
        for (Serializable element : this.jaxbDetailedReport.getSignatureOrTimestampOrEvidenceRecord()) {
            if (!(element instanceof XmlCertificate)) continue;
            result.add((XmlCertificate)element);
        }
        return result;
    }

    public XmlTLAnalysis getTLAnalysisById(String tlId) {
        List<XmlTLAnalysis> tlAnalysisBlocks = this.jaxbDetailedReport.getTLAnalysis();
        if (tlAnalysisBlocks != null) {
            for (XmlTLAnalysis xmlTLAnalysis : tlAnalysisBlocks) {
                if (!tlId.equals(xmlTLAnalysis.getId())) continue;
                return xmlTLAnalysis;
            }
        }
        return null;
    }

    public XmlDetailedReport getJAXBModel() {
        return this.jaxbDetailedReport;
    }

    public boolean isCertificateValidation() {
        List<XmlCertificate> certificates = this.getCertificates();
        return certificates != null && !certificates.isEmpty();
    }

    public CertificateQualification getCertificateQualificationAtIssuance(String certificateId) {
        return this.getCertificateQualificationAtTime(ValidationTime.CERTIFICATE_ISSUANCE_TIME, certificateId);
    }

    public CertificateQualification getCertificateQualificationAtValidation(String certificateId) {
        return this.getCertificateQualificationAtTime(ValidationTime.VALIDATION_TIME, certificateId);
    }

    private CertificateQualification getCertificateQualificationAtTime(ValidationTime validationTime, String certificateId) {
        block6: {
            block5: {
                List<XmlValidationCertificateQualification> validationCertificateQualifications;
                if (certificateId == null) {
                    return CertificateQualification.NA;
                }
                XmlCertificate certificate = this.getXmlCertificateById(certificateId);
                if (certificate == null) break block5;
                XmlCertificateQualificationProcess certificateQualificationProcess = certificate.getCertificateQualificationProcess();
                if (certificateQualificationProcess == null || (validationCertificateQualifications = certificateQualificationProcess.getValidationCertificateQualification()) == null) break block6;
                for (XmlValidationCertificateQualification validationCertificateQualification : validationCertificateQualifications) {
                    if (validationTime != validationCertificateQualification.getValidationTime()) continue;
                    return validationCertificateQualification.getCertificateQualification();
                }
                break block6;
            }
            List<XmlSignature> signatures = this.getSignatures();
            if (signatures != null && !signatures.isEmpty()) {
                for (XmlSignature xmlSignature : signatures) {
                    XmlValidationSignatureQualification signatureQualification = xmlSignature.getValidationSignatureQualification();
                    if (signatureQualification == null || signatureQualification.getValidationCertificateQualification() == null) continue;
                    for (XmlValidationCertificateQualification certificateQualification : signatureQualification.getValidationCertificateQualification()) {
                        if (!certificateId.equals(certificateQualification.getId()) || validationTime != certificateQualification.getValidationTime()) continue;
                        return certificateQualification.getCertificateQualification();
                    }
                }
            }
        }
        return CertificateQualification.NA;
    }

    public QWACProfile getCertificateQWACProfile(String certificateId) {
        if (certificateId == null) {
            return null;
        }
        XmlQWACProcess qwacProcess = null;
        XmlCertificate xmlCertificate = this.getXmlCertificateById(certificateId);
        if (xmlCertificate != null) {
            qwacProcess = xmlCertificate.getQWACProcess();
        } else {
            List<XmlSignature> signatures = this.getSignatures();
            if (signatures != null && !signatures.isEmpty()) {
                for (XmlSignature xmlSignature : signatures) {
                    XmlValidationSignatureQualification signatureQualification = xmlSignature.getValidationSignatureQualification();
                    if (signatureQualification == null || signatureQualification.getQWACProcess() == null || !certificateId.equals(signatureQualification.getQWACProcess().getId())) continue;
                    qwacProcess = signatureQualification.getQWACProcess();
                }
            }
        }
        return qwacProcess != null ? qwacProcess.getQWACType() : null;
    }

    public XmlConclusion getCertificateXCVConclusion(String certificateId) {
        List<XmlSubXCV> subXCV;
        XmlXCV xcv;
        List<XmlCertificate> certificates = this.getCertificates();
        if (certificates == null || certificates.isEmpty()) {
            throw new UnsupportedOperationException("Only supported in report for certificate");
        }
        List<String> signatureIds = this.getSignatureIds();
        List<XmlBasicBuildingBlocks> basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
            if (!signatureIds.contains(xmlBasicBuildingBlocks.getId()) || (xcv = xmlBasicBuildingBlocks.getXCV()) == null) continue;
            subXCV = xcv.getSubXCV();
            for (XmlSubXCV xmlSubXCV : subXCV) {
                if (!certificateId.equals(xmlSubXCV.getId())) continue;
                return xmlSubXCV.getConclusion();
            }
        }
        for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
            if (signatureIds.contains(xmlBasicBuildingBlocks.getId()) || (xcv = xmlBasicBuildingBlocks.getXCV()) == null) continue;
            subXCV = xcv.getSubXCV();
            for (XmlSubXCV xmlSubXCV : subXCV) {
                if (!certificateId.equals(xmlSubXCV.getId())) continue;
                return xmlSubXCV.getConclusion();
            }
        }
        return null;
    }

    public XmlConclusion getFinalConclusion(String tokenId) {
        XmlSignature signatureById = this.getXmlSignatureById(tokenId);
        if (signatureById != null) {
            return signatureById.getConclusion();
        }
        XmlTimestamp timestampById = this.getXmlTimestampById(tokenId);
        if (timestampById != null) {
            return timestampById.getConclusion();
        }
        XmlEvidenceRecord evidenceRecordById = this.getXmlEvidenceRecordById(tokenId);
        if (evidenceRecordById != null) {
            return evidenceRecordById.getConclusion();
        }
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion();
        }
        return null;
    }

    public Indication getFinalIndication(String tokenId) {
        XmlConclusion finalConclusion = this.getFinalConclusion(tokenId);
        if (finalConclusion != null) {
            return finalConclusion.getIndication();
        }
        return null;
    }

    public SubIndication getFinalSubIndication(String tokenId) {
        XmlConclusion finalConclusion = this.getFinalConclusion(tokenId);
        if (finalConclusion != null) {
            return finalConclusion.getSubIndication();
        }
        return null;
    }

    public XmlConstraintsConclusion getHighestConclusion(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature.getValidationProcessArchivalData() != null) {
            return xmlSignature.getValidationProcessArchivalData();
        }
        if (xmlSignature.getValidationProcessLongTermData() != null) {
            return xmlSignature.getValidationProcessLongTermData();
        }
        return xmlSignature.getValidationProcessBasicSignature();
    }

    public XmlSubXCV getSigningCertificate(String bbbId) {
        List<XmlSubXCV> subXCVs;
        XmlXCV xcv;
        XmlBasicBuildingBlocks basicBuildingBlocks = this.getBasicBuildingBlockById(bbbId);
        if (basicBuildingBlocks != null && (xcv = basicBuildingBlocks.getXCV()) != null && (subXCVs = xcv.getSubXCV()) != null && !subXCVs.isEmpty()) {
            return subXCVs.get(0);
        }
        return null;
    }

    DetailedReportMessageCollector getMessageCollector() {
        if (this.messageCollector == null) {
            this.messageCollector = new DetailedReportMessageCollector(this);
        }
        return this.messageCollector;
    }

    public List<Message> getAdESValidationErrors(String tokenId) {
        return this.getMessageCollector().getAdESValidationErrors(tokenId);
    }

    public List<Message> getAdESValidationWarnings(String tokenId) {
        return this.getMessageCollector().getAdESValidationWarnings(tokenId);
    }

    public List<Message> getAdESValidationInfos(String tokenId) {
        return this.getMessageCollector().getAdESValidationInfos(tokenId);
    }

    public List<Message> getQualificationErrors(String tokenId) {
        return this.getMessageCollector().getQualificationErrors(tokenId);
    }

    public List<Message> getQualificationWarnings(String tokenId) {
        return this.getMessageCollector().getQualificationWarnings(tokenId);
    }

    public List<Message> getQualificationInfos(String tokenId) {
        return this.getMessageCollector().getQualificationInfos(tokenId);
    }

    public List<Message> getCertificateQualificationErrorsAtIssuanceTime(String certificateId) {
        return this.getMessageCollector().getCertificateQualificationErrorsAtIssuanceTime(certificateId);
    }

    public List<Message> getCertificateQualificationWarningsAtIssuanceTime(String certificateId) {
        return this.getMessageCollector().getCertificateQualificationWarningsAtIssuanceTime(certificateId);
    }

    public List<Message> getCertificateQualificationInfosAtIssuanceTime(String certificateId) {
        return this.getMessageCollector().getCertificateQualificationInfosAtIssuanceTime(certificateId);
    }

    public List<Message> getCertificateQualificationErrorsAtValidationTime(String certificateId) {
        return this.getMessageCollector().getCertificateQualificationErrorsAtValidationTime(certificateId);
    }

    public List<Message> getCertificateQualificationWarningsAtValidationTime(String certificateId) {
        return this.getMessageCollector().getCertificateQualificationWarningsAtValidationTime(certificateId);
    }

    public List<Message> getCertificateQualificationInfosAtValidationTime(String certificateId) {
        return this.getMessageCollector().getCertificateQualificationInfosAtValidationTime(certificateId);
    }

    public List<Message> getQWACValidationErrors(String certificateId) {
        return this.getMessageCollector().getQWACValidationErrors(certificateId);
    }

    public List<Message> getQWACValidationWarnings(String certificateId) {
        return this.getMessageCollector().getQWACValidationWarnings(certificateId);
    }

    public List<Message> getQWACValidationInfos(String certificateId) {
        return this.getMessageCollector().getQWACValidationInfos(certificateId);
    }
}

