/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.OidDescription;
import eu.europa.esig.dss.enumerations.QCIdentMethodEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface QCIdentMethod
extends OidDescription {
    public static final Logger LOG = LoggerFactory.getLogger(QCIdentMethod.class);
    public static final String UNKNOWN_METHOD = "qc-identification-method-unknown";

    public static QCIdentMethod fromOid(final String oid) {
        for (QCIdentMethodEnum type : QCIdentMethodEnum.values()) {
            if (!type.getOid().equals(oid)) continue;
            return type;
        }
        LOG.debug("Unknown QCIdentMethod : '{}'", (Object)oid);
        return new QCIdentMethod(){
            private static final long serialVersionUID = 6089958556390661665L;

            @Override
            public String getDescription() {
                return QCIdentMethod.UNKNOWN_METHOD;
            }

            @Override
            public String getOid() {
                return oid;
            }
        };
    }
}

