/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.asn1.validation;

import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1EvidenceRecordParser;
import eu.europa.esig.dss.evidencerecord.asn1.validation.ASN1EvidenceRecordTimeStampSequenceVerifier;
import eu.europa.esig.dss.evidencerecord.asn1.validation.timestamp.ASN1EvidenceRecordTimestampSource;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordParser;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordTimeStampSequenceVerifier;
import eu.europa.esig.dss.evidencerecord.common.validation.timestamp.EvidenceRecordTimestampSource;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import java.util.Objects;
import org.bouncycastle.asn1.tsp.EvidenceRecord;

public class ASN1EvidenceRecord
extends DefaultEvidenceRecord {
    private final EvidenceRecord evidenceRecord;

    public ASN1EvidenceRecord(DSSDocument document) {
        Objects.requireNonNull(document, "Document cannot be null!");
        this.evidenceRecord = this.toASN1Document(document);
    }

    private EvidenceRecord toASN1Document(DSSDocument document) {
        try {
            return EvidenceRecord.getInstance(DSSUtils.toByteArray(document));
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("An ASN.1 file is expected : %s", e.getMessage()), e);
        }
    }

    public ASN1EvidenceRecord(EvidenceRecord evidenceRecord) {
        this.evidenceRecord = evidenceRecord;
    }

    public EvidenceRecord getEvidenceRecord() {
        return this.evidenceRecord;
    }

    @Override
    public EvidenceRecordTypeEnum getEvidenceRecordType() {
        return EvidenceRecordTypeEnum.ASN1_EVIDENCE_RECORD;
    }

    @Override
    protected EvidenceRecordParser buildEvidenceRecordParser() {
        return new ASN1EvidenceRecordParser(this.evidenceRecord).setFilename(this.getFilename()).setEmbeddedEvidenceRecordHelper(this.getEmbeddedEvidenceRecordHelper());
    }

    @Override
    protected EvidenceRecordTimeStampSequenceVerifier buildCryptographicEvidenceRecordVerifier() {
        return new ASN1EvidenceRecordTimeStampSequenceVerifier(this);
    }

    @Override
    protected EvidenceRecordTimestampSource<?> buildTimestampSource() {
        return new ASN1EvidenceRecordTimestampSource(this);
    }

    @Override
    public byte[] getEncoded() {
        return DSSASN1Utils.getDEREncoded(this.evidenceRecord);
    }
}

