/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformation;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformationType;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceRecordCRLSource
extends OfflineCRLSource {
    private static final long serialVersionUID = -8846746778038286512L;
    private static final Logger LOG = LoggerFactory.getLogger(EvidenceRecordCRLSource.class);
    private final List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence;

    public EvidenceRecordCRLSource(List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence) {
        this.archiveTimeStampSequence = archiveTimeStampSequence;
        this.extractCRLs();
    }

    private void extractCRLs() {
        if (Utils.isCollectionEmpty(this.archiveTimeStampSequence)) {
            return;
        }
        for (ArchiveTimeStampChainObject archiveTimeStampChainObject : this.archiveTimeStampSequence) {
            List<? extends ArchiveTimeStampObject> archiveTimeStamps = archiveTimeStampChainObject.getArchiveTimeStamps();
            if (!Utils.isCollectionNotEmpty(archiveTimeStamps)) continue;
            for (ArchiveTimeStampObject archiveTimeStampObject : archiveTimeStamps) {
                List<CryptographicInformation> cryptographicInformationList = archiveTimeStampObject.getCryptographicInformationList();
                if (!Utils.isCollectionNotEmpty(cryptographicInformationList)) continue;
                for (CryptographicInformation cryptographicInformation : cryptographicInformationList) {
                    if (!CryptographicInformationType.CRL.equals((Object)cryptographicInformation.getType())) continue;
                    byte[] derEncoded = cryptographicInformation.getContent();
                    try {
                        CRLBinary crlBinary = CRLUtils.buildCRLBinary(derEncoded);
                        this.addBinary(crlBinary, RevocationOrigin.EVIDENCE_RECORD);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to parse CRL '{}' : {}", Utils.toBase64(derEncoded), e.getMessage(), e);
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("+EvidenceRecordCRLSource");
        }
    }
}

