/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.validation.DigestValueGroup;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.validation.evidencerecord.ByteArrayComparator;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.evidencerecord.digest.DataObjectDigestBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EvidenceRecordTimeStampSequenceVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(EvidenceRecordTimeStampSequenceVerifier.class);
    protected final DefaultEvidenceRecord evidenceRecord;
    private List<ReferenceValidation> referenceValidations;

    protected EvidenceRecordTimeStampSequenceVerifier(DefaultEvidenceRecord evidenceRecord) {
        this.evidenceRecord = evidenceRecord;
    }

    public List<ReferenceValidation> getReferenceValidations() {
        if (this.referenceValidations == null) {
            this.verify();
        }
        return this.referenceValidations;
    }

    protected void verify() {
        this.referenceValidations = new ArrayList<ReferenceValidation>();
        DSSMessageDigest lastTimeStampHash = DSSMessageDigest.createEmptyDigest();
        DSSMessageDigest lastTimeStampSequenceHash = DSSMessageDigest.createEmptyDigest();
        List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence = this.evidenceRecord.getArchiveTimeStampSequence();
        Iterator<? extends ArchiveTimeStampChainObject> archiveTimeStampSequenceIt = archiveTimeStampSequence.iterator();
        while (archiveTimeStampSequenceIt.hasNext()) {
            ArchiveTimeStampChainObject archiveTimeStampChain = archiveTimeStampSequenceIt.next();
            DigestAlgorithm digestAlgorithm = archiveTimeStampChain.getDigestAlgorithm();
            List<DSSDocument> detachedContents = lastTimeStampHash.isEmpty() ? this.evidenceRecord.getDetachedContents() : Collections.emptyList();
            ManifestFile manifestFile = lastTimeStampHash.isEmpty() ? this.evidenceRecord.getManifestFile() : null;
            List<? extends ArchiveTimeStampObject> archiveTimeStamps = archiveTimeStampChain.getArchiveTimeStamps();
            Iterator<? extends ArchiveTimeStampObject> archiveTimeStampsIt = archiveTimeStamps.iterator();
            while (archiveTimeStampsIt.hasNext()) {
                ArchiveTimeStampObject archiveTimeStamp = archiveTimeStampsIt.next();
                List<ReferenceValidation> timestampValidations = new ArrayList<ReferenceValidation>();
                DSSMessageDigest lastMessageDigest = DSSMessageDigest.createEmptyDigest();
                List<? extends DigestValueGroup> hashTree = this.getHashTree(archiveTimeStamp.getHashTree(), detachedContents, manifestFile, archiveTimeStampChain, archiveTimeStamp, lastTimeStampHash, lastTimeStampSequenceHash);
                for (DigestValueGroup digestValueGroup : hashTree) {
                    if (lastMessageDigest.isEmpty()) {
                        List<ReferenceValidation> archiveDataObjectValidations = this.validateArchiveDataObjects(digestValueGroup, archiveTimeStampChain, lastTimeStampSequenceHash, detachedContents, manifestFile);
                        if (!lastTimeStampHash.isEmpty()) {
                            timestampValidations = this.validateArchiveTimeStampDigest(archiveDataObjectValidations, lastTimeStampHash);
                        } else if (!lastTimeStampSequenceHash.isEmpty()) {
                            timestampValidations = this.validateArchiveTimeStampSequenceDigest(archiveDataObjectValidations, lastTimeStampSequenceHash);
                        } else if (manifestFile != null) {
                            archiveDataObjectValidations = this.validateManifestEntries(archiveDataObjectValidations, manifestFile, lastTimeStampSequenceHash.isEmpty());
                        }
                        if (lastTimeStampHash.isEmpty()) {
                            if (this.evidenceRecord.isEmbedded()) {
                                archiveDataObjectValidations = this.validateMasterSignatureDigest(archiveDataObjectValidations, digestAlgorithm, lastTimeStampSequenceHash);
                            }
                            if (lastTimeStampSequenceHash.isEmpty()) {
                                this.referenceValidations.addAll(archiveDataObjectValidations);
                            }
                        }
                        if (!this.checkHashTreeValidity(archiveTimeStamp, archiveTimeStampChain)) {
                            archiveDataObjectValidations.forEach(r -> r.setIntact(false));
                        }
                    }
                    lastMessageDigest = this.computeDigestValueGroupHash(digestAlgorithm, digestValueGroup, lastMessageDigest);
                }
                TimestampToken timestampToken = archiveTimeStamp.getTimestampToken();
                timestampToken.matchData(lastMessageDigest);
                timestampValidations = this.ensureReferenceValidations(timestampValidations);
                timestampToken.setReferenceValidations(timestampValidations);
                if (!archiveTimeStampsIt.hasNext()) continue;
                lastTimeStampHash = this.computeTimeStampHash(archiveTimeStamp);
                lastTimeStampSequenceHash = DSSMessageDigest.createEmptyDigest();
            }
            if (!archiveTimeStampSequenceIt.hasNext()) continue;
            lastTimeStampSequenceHash = this.computeTimeStampSequenceHash(archiveTimeStampChain);
            lastTimeStampHash = DSSMessageDigest.createEmptyDigest();
        }
    }

    protected List<? extends DigestValueGroup> getHashTree(List<? extends DigestValueGroup> originalHashTree, List<DSSDocument> detachedContents, ManifestFile manifestFile, ArchiveTimeStampChainObject archiveTimeStampChain, ArchiveTimeStampObject archiveTimeStamp, DSSMessageDigest lastTimeStampHash, DSSMessageDigest lastTimeStampSequenceHash) {
        List<DigestValueGroup> hashTree;
        if (Utils.isCollectionNotEmpty(originalHashTree)) {
            hashTree = new ArrayList<DigestValueGroup>(originalHashTree);
        } else {
            LOG.info("No hashTree found for time-stamp validation. Use provided data as first level data object.");
            DigestValueGroup digestValueGroup = new DigestValueGroup();
            ArrayList<byte[]> digestValues = new ArrayList<byte[]>();
            if (lastTimeStampHash != null && !lastTimeStampHash.isEmpty()) {
                digestValues.add(lastTimeStampHash.getValue());
            } else if (lastTimeStampSequenceHash != null && !lastTimeStampSequenceHash.isEmpty()) {
                digestValues.addAll(this.getLastTimeStampSequenceHashList(lastTimeStampSequenceHash, detachedContents));
            } else if (Utils.collectionSize(detachedContents) == 1) {
                digestValues.add(this.getDocumentDigest(detachedContents.get(0), archiveTimeStampChain));
            } else if (manifestFile != null) {
                if (Utils.collectionSize(manifestFile.getEntries()) == 1) {
                    ManifestEntry manifestEntry = manifestFile.getEntries().get(0);
                    DSSDocument matchingDocument = this.getMatchingDocument(manifestEntry, detachedContents);
                    if (matchingDocument != null) {
                        digestValues.add(this.getDocumentDigest(matchingDocument, archiveTimeStampChain));
                    } else {
                        LOG.warn("Unable to find a matching document for a manifest entry with URI {}.", (Object)manifestEntry.getUri());
                        digestValues.add(DSSUtils.EMPTY_BYTE_ARRAY);
                    }
                } else {
                    LOG.warn("Unable to determine original data object for omitted hashTree. {} manifest entries provided instead of one.", (Object)Utils.collectionSize(manifestFile.getEntries()));
                    digestValues.add(DSSUtils.EMPTY_BYTE_ARRAY);
                }
            } else if (this.evidenceRecord.isEmbedded()) {
                EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper = this.evidenceRecord.getEmbeddedEvidenceRecordHelper();
                if (embeddedEvidenceRecordHelper.isAbsentHashtreeSupported()) {
                    LOG.info("Embedded evidence record with omitted reduced hashtree found. Use timestamp's message-imprint as a virtual reduced hashtree.");
                    digestValues.add(archiveTimeStamp.getTimestampToken().getMessageImprint().getValue());
                } else {
                    LOG.warn("Presence of the reduced hashtree is required for embedded evidence records by the current implementation! Unable to determine the original data.");
                    digestValues.add(DSSUtils.EMPTY_BYTE_ARRAY);
                }
            } else {
                LOG.warn("Unable to determine original data object for omitted hashTree. {} documents provided instead of one.", (Object)Utils.collectionSize(detachedContents));
                digestValues.add(DSSUtils.EMPTY_BYTE_ARRAY);
            }
            digestValueGroup.setDigestValues(digestValues);
            hashTree = Collections.singletonList(digestValueGroup);
        }
        return hashTree;
    }

    protected boolean checkHashTreeValidity(ArchiveTimeStampObject archiveTimeStamp, ArchiveTimeStampChainObject archiveTimeStampChain) {
        return true;
    }

    protected List<byte[]> getLastTimeStampSequenceHashList(DSSMessageDigest lastTimeStampSequenceHash, List<DSSDocument> detachedDocuments) {
        return Collections.singletonList(lastTimeStampSequenceHash.getValue());
    }

    protected byte[] getDocumentDigest(DSSDocument document, ArchiveTimeStampChainObject archiveTimeStampChain) {
        Digest digest = this.getDataObjectDigestBuilder(document, archiveTimeStampChain).build();
        return digest.getValue();
    }

    protected abstract DataObjectDigestBuilder getDataObjectDigestBuilder(DSSDocument var1, ArchiveTimeStampChainObject var2);

    protected List<ReferenceValidation> validateArchiveTimeStampDigest(List<ReferenceValidation> referenceValidations, DSSMessageDigest lastTimeStampHash) {
        return this.validateAdditionalDigest(referenceValidations, lastTimeStampHash, DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_TIME_STAMP);
    }

    protected List<ReferenceValidation> validateArchiveTimeStampSequenceDigest(List<ReferenceValidation> referenceValidations, DSSMessageDigest lastTimeStampSequenceHashes) {
        return this.validateAdditionalDigest(referenceValidations, lastTimeStampSequenceHashes, DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE);
    }

    protected List<ReferenceValidation> validateMasterSignatureDigest(List<ReferenceValidation> referenceValidations, DigestAlgorithm digestAlgorithm, DSSMessageDigest lastTimeStampSequenceHash) {
        EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper = this.evidenceRecord.getEmbeddedEvidenceRecordHelper();
        Digest masterSignatureDigest = embeddedEvidenceRecordHelper.getMasterSignatureDigest(digestAlgorithm);
        return this.validateAdditionalDigest(referenceValidations, masterSignatureDigest, DigestMatcherType.EVIDENCE_RECORD_MASTER_SIGNATURE);
    }

    protected List<ReferenceValidation> validateAdditionalDigest(List<ReferenceValidation> referenceValidations, Digest digest, DigestMatcherType type) {
        List<ReferenceValidation> invalidReferences = this.getInvalidReferences(referenceValidations);
        for (ReferenceValidation reference : invalidReferences) {
            if (!this.digestMatch(digest, reference)) continue;
            reference.setType(type);
            reference.setFound(true);
            reference.setIntact(true);
            return referenceValidations;
        }
        referenceValidations = this.ensureReferenceValidationOfType(referenceValidations, type, !digest.isEmpty());
        return referenceValidations;
    }

    private List<ReferenceValidation> getInvalidReferences(List<ReferenceValidation> referenceValidations) {
        return referenceValidations.stream().filter(r -> !r.isIntact()).collect(Collectors.toList());
    }

    protected boolean digestMatch(Digest digest, ReferenceValidation reference) {
        return reference.getDigest() != null && Arrays.equals(digest.getValue(), reference.getDigest().getValue());
    }

    private List<ReferenceValidation> validateManifestEntries(List<ReferenceValidation> referenceValidations, ManifestFile manifestFile, boolean firstTimeStamp) {
        if (manifestFile == null) {
            return referenceValidations;
        }
        List foundDocumentNames = referenceValidations.stream().map(ReferenceValidation::getDocument).filter(Objects::nonNull).map(DSSDocument::getName).filter(Objects::nonNull).collect(Collectors.toList());
        if (Utils.collectionSize(manifestFile.getEntries()) > Utils.collectionSize(foundDocumentNames)) {
            List failedReferences = referenceValidations.stream().filter(r -> !r.isIntact()).collect(Collectors.toList());
            if (Utils.collectionSize(manifestFile.getEntries()) - Utils.collectionSize(foundDocumentNames) >= Utils.collectionSize(failedReferences)) {
                for (ReferenceValidation reference : failedReferences) {
                    referenceValidations.remove(reference);
                }
            }
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (foundDocumentNames.contains(manifestEntry.getUri())) continue;
                LOG.warn("Manifest entry with name '{}' was not found within evidence record data objects!", (Object)manifestEntry.getUri());
                DSSDocument matchingDocument = this.getMatchingDocument(manifestEntry, this.evidenceRecord.getDetachedContents());
                ReferenceValidation referenceValidation = new ReferenceValidation();
                referenceValidation.setType(DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_OBJECT);
                referenceValidation.setDigest(manifestEntry.getDigest());
                referenceValidation.setUri(manifestEntry.getUri());
                referenceValidation.setDocument(matchingDocument);
                referenceValidation.setFound(matchingDocument != null);
                referenceValidation.setIntact(false);
                referenceValidations.add(referenceValidation);
            }
        }
        if (firstTimeStamp) {
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                for (ReferenceValidation reference : referenceValidations) {
                    if (reference.getDocument() == null || !manifestEntry.getUri().equals(reference.getDocument().getName()) || manifestEntry.getDigest() == null || reference.getDigest() == null || manifestEntry.getDigest().getAlgorithm().equals(reference.getDigest().getAlgorithm())) continue;
                    LOG.warn("The digest algorithm '{}' defined in a manifest file with name '{}' does not match the digest algorithm '{}' used within an evidence record for file with name '{}'", manifestEntry.getDigest().getAlgorithm(), manifestFile.getFilename(), reference.getDigest().getAlgorithm(), manifestEntry.getUri());
                    reference.setIntact(false);
                }
            }
        }
        return referenceValidations;
    }

    protected List<ReferenceValidation> validateArchiveDataObjects(DigestValueGroup digestValueGroup, ArchiveTimeStampChainObject archiveTimeStampChain, DSSMessageDigest lastTimeStampSequenceHash, List<DSSDocument> detachedContents, ManifestFile manifestFile) {
        ArrayList<ReferenceValidation> result = new ArrayList<ReferenceValidation>();
        DigestAlgorithm digestAlgorithm = archiveTimeStampChain.getDigestAlgorithm();
        List<byte[]> digestValues = digestValueGroup.getDigestValues();
        for (byte[] hashValue : digestValues) {
            ReferenceValidation referenceValidation = new ReferenceValidation();
            referenceValidation.setType(DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_OBJECT);
            Digest digest = new Digest(digestAlgorithm, hashValue);
            referenceValidation.setDigest(digest);
            DSSDocument matchingDocument = this.getMatchingDocument(digest, archiveTimeStampChain, lastTimeStampSequenceHash, detachedContents);
            ManifestEntry matchingManifestEntry = this.getMatchingManifestEntry(manifestFile, digest, matchingDocument);
            if (manifestFile != null) {
                if (matchingManifestEntry != null) {
                    referenceValidation.setFound(matchingManifestEntry.isFound() || matchingDocument != null);
                    referenceValidation.setIntact(matchingManifestEntry.isIntact() && matchingDocument != null);
                    referenceValidation.setUri(matchingManifestEntry.getUri());
                    referenceValidation.setDocument(matchingManifestEntry.getDocument());
                } else if (matchingDocument != null) {
                    referenceValidation.setDocument(matchingDocument);
                } else {
                    referenceValidation.setType(DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE);
                    referenceValidation.setFound(false);
                    referenceValidation.setIntact(false);
                }
            } else if (matchingDocument != null) {
                referenceValidation.setFound(true);
                referenceValidation.setIntact(true);
                referenceValidation.setDocument(matchingDocument);
            } else if (Utils.collectionSize(digestValues) == 1 && Utils.collectionSize(detachedContents) == 1 && !this.evidenceRecord.isEmbedded()) {
                referenceValidation.setFound(true);
                referenceValidation.setIntact(false);
                referenceValidation.setDocument(detachedContents.get(0));
            } else {
                referenceValidation.setType(DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE);
                referenceValidation.setFound(false);
                referenceValidation.setIntact(false);
            }
            result.add(referenceValidation);
        }
        return result;
    }

    protected ManifestEntry getMatchingManifestEntry(ManifestFile manifestFile, Digest digest, DSSDocument document) {
        if (manifestFile != null) {
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                Digest manifestEntryDigest = manifestEntry.getDigest();
                if (digest.equals(manifestEntryDigest)) {
                    return manifestEntry;
                }
                if (document == null || !document.getName().equals(manifestEntry.getUri())) continue;
                return manifestEntry;
            }
            LOG.debug("No manifest entry found matching the archive data object with digest value '{}'", (Object)digest.getHexValue());
        }
        return null;
    }

    protected DSSDocument getMatchingDocument(Digest digest, ArchiveTimeStampChainObject archiveTimeStampChain, DSSMessageDigest lastTimeStampSequenceHash, List<DSSDocument> detachedContents) {
        if (Utils.isCollectionNotEmpty(detachedContents)) {
            for (DSSDocument document : detachedContents) {
                byte[] documentDigest = this.getDocumentDigest(document, archiveTimeStampChain);
                if (!Arrays.equals(digest.getValue(), documentDigest)) continue;
                return document;
            }
        }
        return null;
    }

    protected DSSDocument getMatchingDocument(ManifestEntry manifestEntry, List<DSSDocument> detachedContents) {
        for (DSSDocument document : detachedContents) {
            if (!manifestEntry.getUri().equals(document.getName())) continue;
            return document;
        }
        return null;
    }

    protected abstract DSSMessageDigest computeTimeStampHash(ArchiveTimeStampObject var1);

    protected abstract DSSMessageDigest computeTimeStampSequenceHash(ArchiveTimeStampChainObject var1);

    protected List<ReferenceValidation> ensureReferenceValidations(List<ReferenceValidation> referenceValidations) {
        List orphanRefs = referenceValidations.stream().filter(r -> DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == r.getType()).collect(Collectors.toList());
        List emptyRefs = referenceValidations.stream().filter(r -> r.getDigest() == null).collect(Collectors.toList());
        if (Utils.collectionSize(orphanRefs) == 1 && Utils.collectionSize(emptyRefs) == 1) {
            ReferenceValidation orphanReference = (ReferenceValidation)orphanRefs.iterator().next();
            ReferenceValidation emptyReference = (ReferenceValidation)emptyRefs.iterator().next();
            orphanReference.setType(emptyReference.getType());
            orphanReference.setFound(emptyReference.isFound());
            referenceValidations.remove(emptyReference);
        }
        return referenceValidations;
    }

    protected List<ReferenceValidation> ensureReferenceValidationOfType(List<ReferenceValidation> referenceValidations, DigestMatcherType digestMatcherType, boolean digestFound) {
        if (!this.containsReferenceValidationOfType(referenceValidations, digestMatcherType)) {
            List<ReferenceValidation> invalidReferences = this.getInvalidReferences(referenceValidations);
            if (Utils.collectionSize(invalidReferences) == 1) {
                ReferenceValidation referenceValidation = invalidReferences.iterator().next();
                referenceValidation.setType(digestMatcherType);
                referenceValidation.setFound(digestFound);
            } else {
                referenceValidations.add(this.createEmptyReference(digestMatcherType, digestFound));
            }
        }
        return referenceValidations;
    }

    private boolean containsReferenceValidationOfType(List<ReferenceValidation> referenceValidations, DigestMatcherType digestMatcherType) {
        return referenceValidations.stream().anyMatch(r -> digestMatcherType.equals((Object)r.getType()));
    }

    protected ReferenceValidation createEmptyReference(DigestMatcherType digestMatcherType, boolean digestFound) {
        ReferenceValidation referenceValidation = new ReferenceValidation();
        referenceValidation.setType(digestMatcherType);
        referenceValidation.setFound(digestFound);
        return referenceValidation;
    }

    protected DSSMessageDigest computeDigestValueGroupHash(DigestAlgorithm digestAlgorithm, DigestValueGroup digestValueGroup, DSSMessageDigest ... otherObjectDigests) {
        ArrayList<byte[]> hashValueList = new ArrayList<byte[]>(digestValueGroup.getDigestValues());
        for (DSSMessageDigest messageDigest : otherObjectDigests) {
            if (messageDigest.isEmpty()) continue;
            hashValueList.add(messageDigest.getValue());
        }
        if (Utils.collectionSize(hashValueList) == 1) {
            return new DSSMessageDigest(digestAlgorithm, (byte[])hashValueList.get(0));
        }
        hashValueList.sort(ByteArrayComparator.getInstance());
        DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(digestAlgorithm);
        for (byte[] hashValue : hashValueList) {
            digestCalculator.update(hashValue);
        }
        return digestCalculator.getMessageDigest(digestAlgorithm);
    }
}

