/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation.identifier;

import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.DefaultEvidenceRecord;
import eu.europa.esig.dss.evidencerecord.common.validation.DigestValueGroup;
import eu.europa.esig.dss.evidencerecord.common.validation.identifier.EvidenceRecordIdentifier;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class EvidenceRecordIdentifierBuilder {
    public EvidenceRecordIdentifier build(DefaultEvidenceRecord evidenceRecord) {
        return new EvidenceRecordIdentifier(this.buildBinaries(evidenceRecord));
    }

    protected byte[] buildBinaries(DefaultEvidenceRecord evidenceRecord) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String string;
            byte[] encodedTimestamp;
            List<? extends DigestValueGroup> hashTree = this.getFirstReducedHashTree(evidenceRecord);
            if (Utils.isCollectionNotEmpty(hashTree)) {
                for (DigestValueGroup digestValueGroup : hashTree) {
                    List<byte[]> digestValues = digestValueGroup.getDigestValues();
                    if (!Utils.isCollectionNotEmpty(digestValues)) continue;
                    for (byte[] binaries : digestValues) {
                        baos.write(binaries);
                    }
                }
            }
            if ((encodedTimestamp = this.getFirstEncodedTimestamp(evidenceRecord)) != null) {
                baos.write(encodedTimestamp);
            }
            if (Utils.isStringNotEmpty(evidenceRecord.getFilename())) {
                baos.write(evidenceRecord.getFilename().getBytes());
            }
            if (Utils.isStringNotEmpty(string = this.getEvidenceRecordPosition())) {
                baos.write(string.getBytes());
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while building an Identifier : %s", e.getMessage()), e);
            }
        }
        baos.close();
        return byArray;
    }

    private List<? extends DigestValueGroup> getFirstReducedHashTree(DefaultEvidenceRecord evidenceRecord) {
        ArchiveTimeStampChainObject archiveTimeStampChainObject;
        List<? extends ArchiveTimeStampObject> archiveTimeStamps;
        List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence = evidenceRecord.getArchiveTimeStampSequence();
        if (Utils.isCollectionNotEmpty(archiveTimeStampSequence) && Utils.isCollectionNotEmpty(archiveTimeStamps = (archiveTimeStampChainObject = archiveTimeStampSequence.get(0)).getArchiveTimeStamps())) {
            ArchiveTimeStampObject archiveTimeStampObject = archiveTimeStamps.get(0);
            return archiveTimeStampObject.getHashTree();
        }
        return Collections.emptyList();
    }

    private byte[] getFirstEncodedTimestamp(DefaultEvidenceRecord evidenceRecord) {
        ArchiveTimeStampObject archiveTimeStampObject;
        TimestampToken timestampToken;
        ArchiveTimeStampChainObject archiveTimeStampChainObject;
        List<? extends ArchiveTimeStampObject> archiveTimeStamps;
        List<? extends ArchiveTimeStampChainObject> archiveTimeStampSequence = evidenceRecord.getArchiveTimeStampSequence();
        if (Utils.isCollectionNotEmpty(archiveTimeStampSequence) && Utils.isCollectionNotEmpty(archiveTimeStamps = (archiveTimeStampChainObject = archiveTimeStampSequence.get(0)).getArchiveTimeStamps()) && (timestampToken = (archiveTimeStampObject = archiveTimeStamps.get(0)).getTimestampToken()) != null) {
            return timestampToken.getEncoded();
        }
        return null;
    }

    protected String getEvidenceRecordPosition() {
        return null;
    }
}

