/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.ObjectIdentifier;
import eu.europa.esig.dss.jades.HTTPHeader;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentAnalyzer;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.jades.validation.JWSDocumentAnalyzerFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.jades.JAdESProtectedHeaderUtils;
import eu.europa.esig.jades.JAdESUnprotectedHeaderUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.jose4j.base64url.Base64Url;
import org.jose4j.json.JsonUtil;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.jose4j.json.internal.json_simple.JSONValue;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwx.CompactSerializer;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSJsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSJsonUtils.class);
    public static final String MIME_TYPE_APPLICATION_PREFIX = "application/";
    public static final String HTTP_HEADER_DIGEST = "Digest";
    public static final String CONTENT_ENCODING_BINARY = "binary";
    private static final String DATE_TIME_FORMAT_RFC3339 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final Set<String> protectedCriticalHeaders = Stream.of("sigT", "x5t#o", "sigX5ts", "srCms", "sigPl", "srAts", "adoTst", "sigPId", "sigD", "iat", "exp", "b64").collect(Collectors.toSet());
    private static final Set<String> requiredCriticalHeaders;
    private static final Set<String> criticalHeaderExceptions;

    private DSSJsonUtils() {
    }

    public static byte[] getAsciiBytes(String str) {
        return StringUtil.getBytesAscii(str);
    }

    public static String toBase64Url(byte[] binary) {
        return Base64Url.encode(binary);
    }

    public static String toBase64Url(DSSDocument document) {
        return DSSJsonUtils.toBase64Url(DSSUtils.toByteArray(document));
    }

    public static String toBase64Url(Object object) {
        String json = JSONValue.toJSONString(object);
        return Base64Url.encode(json.getBytes());
    }

    public static byte[] fromBase64Url(String base64UrlEncoded) {
        return Base64Url.decode(base64UrlEncoded);
    }

    public static boolean isBase64UrlEncoded(String str) {
        try {
            Base64Url.decode(str);
            for (byte b : str.getBytes()) {
                if (DSSJsonUtils.isBase64UrlEncoded(b)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBase64UrlEncoded(byte b) {
        for (byte m : URL_SAFE_ENCODE_TABLE) {
            if (b != m) continue;
            return true;
        }
        return false;
    }

    public static boolean isUrlSafePayload(String payloadString) {
        return payloadString.matches("[^\\P{Print}.]*");
    }

    public static boolean isUrlSafe(byte b) {
        return 31 < b && b < 46 || 46 < b && b < 127;
    }

    public static boolean isUtf8(byte[] binaries) {
        try {
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            ByteBuffer buf = ByteBuffer.wrap(binaries);
            decoder.decode(buf);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String concatenate(String ... strings) {
        return CompactSerializer.serialize(strings);
    }

    public static Set<String> getSupportedProtectedCriticalHeaders() {
        return protectedCriticalHeaders;
    }

    public static boolean isCriticalHeaderException(String headerName) {
        return criticalHeaderExceptions.contains(headerName);
    }

    public static boolean isRequiredCriticalHeader(String headerName) {
        return requiredCriticalHeaders.contains(headerName);
    }

    public static Digest getDigest(Map<?, ?> digestValueAndAlgo) {
        try {
            if (Utils.isMapNotEmpty(digestValueAndAlgo)) {
                String digestAlgoURI = DSSJsonUtils.getAsString(digestValueAndAlgo, "digAlg");
                String digestValueBase64 = DSSJsonUtils.getAsString(digestValueAndAlgo, "digVal");
                if (Utils.isStringNotEmpty(digestAlgoURI) && Utils.isStringNotEmpty(digestValueBase64)) {
                    return new Digest(DigestAlgorithm.forJAdES(digestAlgoURI), DSSJsonUtils.fromBase64Url(digestValueBase64));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to extract Digest Algorithm and Value. Reason : {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    public static JsonObject getOidObject(ObjectIdentifier objectIdentifier) {
        return DSSJsonUtils.getOidObject(DSSJsonUtils.getUriOrUrnOid(objectIdentifier), objectIdentifier.getDescription(), objectIdentifier.getDocumentationReferences());
    }

    public static String getUriOrUrnOid(ObjectIdentifier objectIdentifier) {
        String uri = objectIdentifier.getUri();
        if (uri == null && objectIdentifier.getOid() != null) {
            uri = DSSUtils.toUrnOid(objectIdentifier.getOid());
        }
        return uri;
    }

    public static JsonObject getOidObject(String uri, String desc, String[] docRefs) {
        Objects.requireNonNull(uri, "uri must be defined!");
        LinkedHashMap<String, Object> oidParams = new LinkedHashMap<String, Object>();
        oidParams.put("id", uri);
        if (Utils.isStringNotEmpty(desc)) {
            oidParams.put("desc", desc);
        }
        if (Utils.isArrayNotEmpty(docRefs)) {
            oidParams.put("docRefs", new JSONArray(Arrays.asList(docRefs)));
        }
        return new JsonObject(oidParams);
    }

    public static JsonObject getTstContainer(List<TimestampBinary> timestampBinaries, String canonicalizationMethodUri) {
        if (Utils.isCollectionEmpty(timestampBinaries)) {
            throw new IllegalArgumentException("Impossible to create 'tstContainer'. List of TimestampBinaries cannot be null or empty!");
        }
        LinkedHashMap<String, Object> tstContainerParams = new LinkedHashMap<String, Object>();
        if (canonicalizationMethodUri != null) {
            tstContainerParams.put("canonAlg", canonicalizationMethodUri);
        }
        ArrayList<JsonObject> tsTokens = new ArrayList<JsonObject>();
        for (TimestampBinary timestampBinary : timestampBinaries) {
            JsonObject tstToken = DSSJsonUtils.getTstToken(timestampBinary);
            tsTokens.add(tstToken);
        }
        JSONArray tsTokensArray = new JSONArray(tsTokens);
        tstContainerParams.put("tstTokens", tsTokensArray);
        return new JsonObject(tstContainerParams);
    }

    private static JsonObject getTstToken(TimestampBinary timestampBinary) {
        Objects.requireNonNull(timestampBinary, "timestampBinary cannot be null!");
        HashMap<String, Object> tstTokenParams = new HashMap<String, Object>();
        tstTokenParams.put("val", Utils.toBase64(timestampBinary.getBytes()));
        return new JsonObject(tstTokenParams);
    }

    public static byte[] concatenateDSSDocuments(List<DSSDocument> documents, boolean isBase64UrlEncoded) {
        Object object;
        if (Utils.isCollectionEmpty(documents)) {
            throw new IllegalArgumentException("Unable to build a JWS Payload. Reason : the detached content is not provided!");
        }
        if (documents.size() == 1) {
            return DSSJsonUtils.getDocumentOctets(documents.get(0), isBase64UrlEncoded);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (DSSDocument document : documents) {
                baos.write(DSSJsonUtils.getDocumentOctets(document, isBase64UrlEncoded));
            }
            object = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to build a JWS Payload. Reason : %s", e.getMessage()), e);
            }
        }
        baos.close();
        return object;
    }

    public static void writeDocumentsDigest(List<DSSDocument> documents, boolean isBase64UrlEncoded, DSSMessageDigestCalculator digestCalculator) {
        if (Utils.isCollectionEmpty(documents)) {
            throw new IllegalArgumentException("Unable to build a message-digest. Reason : the detached content is not provided!");
        }
        byte[] octets = null;
        if (documents.size() == 1) {
            octets = DSSJsonUtils.getDocumentOctets(documents.get(0), isBase64UrlEncoded);
            digestCalculator.update(octets);
        } else {
            for (DSSDocument document : documents) {
                octets = DSSJsonUtils.getDocumentOctets(document, isBase64UrlEncoded);
                digestCalculator.update(octets);
            }
        }
    }

    public static byte[] getDocumentOctets(DSSDocument document, boolean isBase64UrlEncoded) {
        byte[] octets = DSSUtils.toByteArray(document);
        if (isBase64UrlEncoded) {
            octets = DSSJsonUtils.toBase64Url(octets).getBytes();
        }
        return octets;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJsonDocument(DSSDocument document) {
        if (!DSSJsonUtils.isAllowedSignatureDocumentType(document)) return false;
        try (InputStream is = document.openStream();
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int firstChar = is.read();
            if (firstChar != 123) return false;
            baos.write(firstChar);
            Utils.copy(is, baos);
            if (baos.size() < 2) {
                boolean bl = false;
                return bl;
            }
            Map<String, Object> json = JsonUtil.parseJson(baos.toString());
            boolean bl = json != null;
            return bl;
        }
        catch (JoseException e) {
            LOG.warn("Unable to parse content as JSON : {}", (Object)e.getMessage());
            return false;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Cannot read the document. Reason : %s", e.getMessage()), e);
        }
    }

    public static boolean isAllowedSignatureDocumentType(DSSDocument document) {
        if (document instanceof DigestDocument || document instanceof HTTPHeader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The provided document of class '{}' cannot be parsed.", (Object)document.getClass());
            }
            return false;
        }
        return true;
    }

    public static List<Object> getEtsiU(JWS jws) {
        Map<String, Object> unprotected = jws.getUnprotected();
        if (unprotected == null) {
            return Collections.emptyList();
        }
        Object etsiU = unprotected.get("etsiU");
        if (!(etsiU instanceof List)) {
            LOG.warn("Unable to extract 'etsiU' header : the obtained entry is not an array!");
            return Collections.emptyList();
        }
        return (List)etsiU;
    }

    public static List<EtsiUComponent> getUnsignedPropertiesWithHeaderName(JAdESEtsiUHeader etsiUHeader, String headerName) {
        if (!etsiUHeader.isExist()) {
            return Collections.emptyList();
        }
        ArrayList<EtsiUComponent> componentsWithHeaderName = new ArrayList<EtsiUComponent>();
        for (EtsiUComponent attribute : etsiUHeader.getAttributes()) {
            if (!headerName.equals(attribute.getHeaderName())) continue;
            componentsWithHeaderName.add(attribute);
        }
        return componentsWithHeaderName;
    }

    public static Date getDate(String dateTimeString) {
        if (Utils.isStringNotEmpty(dateTimeString)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT_RFC3339);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf.parse(dateTimeString);
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse date with value '{}' : {}", (Object)dateTimeString, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static Date getDate(Number dateTimeNumber) {
        if (dateTimeNumber != null) {
            return new Date(dateTimeNumber.longValue());
        }
        return null;
    }

    public static IssuerSerial getIssuerSerial(String value) {
        if (Utils.isStringNotEmpty(value)) {
            if (Utils.isBase64Encoded(value)) {
                byte[] binary = Utils.fromBase64(value);
                return DSSASN1Utils.getIssuerSerial(binary);
            }
            LOG.warn("The IssuerSerial value is not base64-encoded!");
        }
        return null;
    }

    public static String generateKid(CertificateToken signingCertificate) {
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial(signingCertificate);
        return Utils.toBase64(DSSASN1Utils.getDEREncoded(issuerSerial));
    }

    public static JAdESSignature extractJAdESCounterSignature(EtsiUComponent cSigAttribute, JAdESSignature masterSignature) {
        InMemoryDocument cSigDocument;
        JWSDocumentAnalyzerFactory factory;
        Object cSigObject = cSigAttribute.getValue();
        String cSigValue = null;
        if (cSigObject instanceof String) {
            cSigValue = (String)cSigObject;
        } else if (cSigObject instanceof Map) {
            Map cSigMap = (Map)cSigObject;
            cSigValue = JsonUtil.toJson(cSigMap);
        } else {
            LOG.warn("Unsupported entry of type 'cSig' found! Class : {}. The entry is skipped", (Object)cSigObject.getClass());
        }
        if (Utils.isStringNotEmpty(cSigValue) && (factory = new JWSDocumentAnalyzerFactory()).isSupported(cSigDocument = new InMemoryDocument(cSigValue.getBytes()))) {
            AbstractJWSDocumentAnalyzer validator = factory.create(cSigDocument);
            List<AdvancedSignature> signatures = validator.getSignatures();
            if (signatures.size() == 1) {
                JAdESSignature signature = (JAdESSignature)signatures.iterator().next();
                signature.setMasterSignature(masterSignature);
                signature.setMasterCSigComponent(cSigAttribute);
                signature.setDetachedContents(Collections.singletonList(new InMemoryDocument(masterSignature.getSignatureValue())));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("A JWS counter signature found with Id : '{}'", (Object)signature.getId());
                }
                return signature;
            }
            LOG.warn("{} counter signatures found in 'cSig' element. Only one is allowed!", (Object)signatures.size());
        }
        return null;
    }

    public static List<String> validateAgainstJAdESSchema(JWS jws) {
        ArrayList<String> errors = new ArrayList<String>();
        String headerJson = jws.getHeaders().getFullHeaderAsJsonString();
        errors.addAll(JAdESProtectedHeaderUtils.getInstance().validateAgainstSchema(headerJson));
        Map<String, Object> unprotected = jws.getUnprotected();
        if (Utils.isMapNotEmpty(unprotected)) {
            List etsiUComponents;
            String unprotectedJson = JsonUtil.toJson(unprotected);
            errors.addAll(JAdESUnprotectedHeaderUtils.getInstance().validateAgainstSchema(unprotectedJson));
            Object etsiU = unprotected.get("etsiU");
            if (etsiU instanceof List && DSSJsonUtils.areAllBase64UrlComponents(etsiUComponents = (List)etsiU)) {
                Map<String, Object> clearEtsiURepresentation = DSSJsonUtils.getClearEtsiURepresentation(unprotected);
                String clearEtsiUJson = JsonUtil.toJson(clearEtsiURepresentation);
                errors.addAll(JAdESUnprotectedHeaderUtils.getInstance().validateAgainstSchema(clearEtsiUJson));
            }
        }
        return errors;
    }

    public static boolean checkComponentsUnicity(List<Object> components) {
        if (Utils.isCollectionNotEmpty(components)) {
            Iterator<Object> iterator2 = components.iterator();
            Object component = iterator2.next();
            boolean stringFormat = DSSJsonUtils.isStringFormat(component);
            while (iterator2.hasNext()) {
                component = iterator2.next();
                if (stringFormat == DSSJsonUtils.isStringFormat(component)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isStringFormat(Object object) {
        return object instanceof String;
    }

    public static boolean areAllBase64UrlComponents(List<Object> components) {
        if (Utils.isCollectionNotEmpty(components)) {
            for (Object component : components) {
                if (DSSJsonUtils.isStringFormat(component) && DSSJsonUtils.isBase64UrlEncoded((String)component)) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, Object> getClearEtsiURepresentation(Map<String, Object> unprotected) {
        ArrayList<Map<String, Object>> clearComponents = new ArrayList<Map<String, Object>>();
        List stringComponents = (List)unprotected.get("etsiU");
        for (Object component : stringComponents) {
            Map<String, Object> json = DSSJsonUtils.parseEtsiUComponent(component);
            clearComponents.add(json);
        }
        HashMap<String, Object> clearEtsiU = new HashMap<String, Object>();
        clearEtsiU.put("etsiU", clearComponents);
        return clearEtsiU;
    }

    public static Map<String, Object> parseEtsiUComponent(Object etsiUComponent) {
        try {
            if (etsiUComponent instanceof Map) {
                Map map = (Map)etsiUComponent;
                if (map.size() != 1) {
                    LOG.warn("The '{}' shall contain only one entry! Found : {}.", (Object)"etsiU", (Object)map.size());
                    return null;
                }
                return map;
            }
            if (etsiUComponent instanceof String) {
                String base64UrlEncoded = (String)etsiUComponent;
                if (DSSJsonUtils.isBase64UrlEncoded(base64UrlEncoded)) {
                    byte[] itemBinaries = DSSJsonUtils.fromBase64Url(base64UrlEncoded);
                    return JsonUtil.parseJson(new String(itemBinaries));
                }
                LOG.warn("A String component of '{}' array shall be base64Url encoded!", (Object)"etsiU");
            } else {
                LOG.warn("A component of unsupported class '{}' found inside the '{}' array!", (Object)etsiUComponent.getClass(), (Object)"etsiU");
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during '{}' component parsing : {}", "etsiU", e.getMessage(), e);
        }
        return null;
    }

    public static SpDocSpecification parseSPDocSpecification(Object spDocSpecificationObject) {
        try {
            List<?> docRefsList;
            String desc;
            Map<?, ?> spDSpec = DSSJsonUtils.toMap(spDocSpecificationObject, "spDSpec");
            if (Utils.isMapEmpty(spDSpec)) {
                LOG.warn("The {} element is empty!", (Object)"spDSpec");
                return null;
            }
            SpDocSpecification spDocSpecification = new SpDocSpecification();
            String id = DSSJsonUtils.getAsString(spDSpec, "id");
            if (Utils.isStringNotEmpty(id)) {
                spDocSpecification.setId(DSSUtils.getObjectIdentifierValue(id));
            }
            if (Utils.isStringNotEmpty(desc = DSSJsonUtils.getAsString(spDSpec, "desc"))) {
                spDocSpecification.setDescription(desc);
            }
            if (Utils.isCollectionNotEmpty(docRefsList = DSSJsonUtils.getAsList(spDSpec, "docRefs"))) {
                spDocSpecification.setDocumentationReferences(docRefsList.toArray(new String[0]));
            }
            return spDocSpecification;
        }
        catch (Exception e) {
            LOG.warn("An error occurred during '{}' component parsing : {}", "spDSpec", e.getMessage(), e);
            return null;
        }
    }

    public static JWSJsonSerializationObject toJWSJsonSerializationObject(JWS jws) {
        JWSJsonSerializationObject jwsJsonSerializationObject = new JWSJsonSerializationObject();
        jwsJsonSerializationObject.getSignatures().add(jws);
        jwsJsonSerializationObject.setPayload(jws.getSignedPayload());
        return jwsJsonSerializationObject;
    }

    public static byte[] getSigningInputBytes(JWS jws) {
        byte[] dataToSign;
        if (!jws.isRfc7797UnencodedPayload()) {
            String dataToBeSignedString = DSSJsonUtils.concatenate(jws.getEncodedHeader(), jws.getEncodedPayload());
            dataToSign = DSSJsonUtils.getAsciiBytes(dataToBeSignedString);
        } else {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                os.write(DSSJsonUtils.getAsciiBytes(jws.getEncodedHeader()));
                os.write(46);
                byte[] payloadBytes = jws.getUnverifiedPayloadBytes();
                if (Utils.isArrayNotEmpty(payloadBytes)) {
                    os.write(payloadBytes);
                }
                dataToSign = os.toByteArray();
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to compute the JWS Signature Input for the unencoded payload! Reason : %s", e.getMessage()), e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("JWS Signature Input: ");
            LOG.trace(new String(dataToSign));
        }
        return dataToSign;
    }

    public static Set<String> extractJOSEHeaderMembersSet(JWS jws) {
        try {
            HashSet<String> joseHeaderMemberKeys = new HashSet<String>();
            Map<String, Object> signedHeaders = JsonUtil.parseJson(jws.getHeaders().getFullHeaderAsJsonString());
            joseHeaderMemberKeys.addAll(signedHeaders.keySet());
            if (jws.getUnprotected() != null) {
                joseHeaderMemberKeys.addAll(jws.getUnprotected().keySet());
            }
            return joseHeaderMemberKeys;
        }
        catch (JoseException e) {
            throw new IllegalInputException(String.format("Unable to extract key set from a JOSE header! Reason : %s", e.getMessage()), e);
        }
    }

    public static Boolean getAsBoolean(Map<?, ?> map, String key) {
        return DSSJsonUtils.toBoolean(map.get(key), key);
    }

    public static Boolean toBoolean(Object object, String headerName) {
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (Utils.isStringNotEmpty(headerName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to process '{}' header parameter with value : '{}'. The Boolean type is expected!", (Object)headerName, object);
                } else {
                    LOG.warn("Unable to process '{}' header parameter. The Boolean type is expected!", (Object)headerName);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The Boolean type is expected!", object);
            } else {
                LOG.warn("Unable to process an obtained item. The Boolean type is expected!");
            }
        }
        return null;
    }

    public static String getAsString(Map<?, ?> map, String key) {
        return DSSJsonUtils.toString(map.get(key), key);
    }

    public static String toString(Object object) {
        return DSSJsonUtils.toString(object, null);
    }

    public static String toString(Object object, String headerName) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            if (Utils.isStringNotEmpty(headerName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to process '{}' header parameter with value : '{}'. The String type is expected!", (Object)headerName, object);
                } else {
                    LOG.warn("Unable to process '{}' header parameter. The String type is expected!", (Object)headerName);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The String type is expected!", object);
            } else {
                LOG.warn("Unable to process an obtained item. The String type is expected!");
            }
        }
        return "";
    }

    public static Number toNumber(Object object) {
        return DSSJsonUtils.toNumber(object, null);
    }

    public static Number toNumber(Object object, String headerName) {
        if (object != null) {
            if (object instanceof Number) {
                return (Number)object;
            }
            if (Utils.isStringNotEmpty(headerName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to process '{}' header parameter with value : '{}'. The Number type is expected!", (Object)headerName, object);
                } else {
                    LOG.warn("Unable to process '{}' header parameter. The Number type is expected!", (Object)headerName);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The Number type is expected!", object);
            } else {
                LOG.warn("Unable to process an obtained item. The Number type is expected!");
            }
        }
        return null;
    }

    public static Map<?, ?> getAsMap(Map<?, ?> map, String key) {
        return DSSJsonUtils.toMap(map.get(key), key);
    }

    public static Map<?, ?> toMap(Object object) {
        return DSSJsonUtils.toMap(object, null);
    }

    public static Map<?, ?> toMap(Object object, String headerName) {
        if (object != null) {
            if (object instanceof Map) {
                return (Map)object;
            }
            if (Utils.isStringNotEmpty(headerName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to process '{}' header parameter with value : '{}'. The JSON Object type is expected!", (Object)headerName, object);
                } else {
                    LOG.warn("Unable to process '{}' header parameter. The JSON Object type is expected!", (Object)headerName);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The JSON Object type is expected!", object);
            } else {
                LOG.warn("Unable to process an obtained item. The JSON Object type is expected!");
            }
        }
        return Collections.emptyMap();
    }

    public static List<?> getAsList(Map<?, ?> map, String key) {
        return DSSJsonUtils.toList(map.get(key), key);
    }

    public static List<?> toList(Object object) {
        return DSSJsonUtils.toList(object, null);
    }

    public static List<?> toList(Object object, String headerName) {
        if (object != null) {
            if (object instanceof List) {
                return (List)object;
            }
            if (Utils.isStringNotEmpty(headerName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to process '{}' header parameter with value : '{}'. The JSON Array type is expected!", (Object)headerName, object);
                } else {
                    LOG.warn("Unable to process '{}' header parameter. The JSON Array type is expected!", (Object)headerName);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to process an obtained item with value : '{}'. The JSON Array type is expected!", object);
            } else {
                LOG.warn("Unable to process an obtained item. The JSON Array type is expected!");
            }
        }
        return Collections.emptyList();
    }

    public static List<String> toListOfStrings(List<?> list) {
        ArrayList<String> listOfStrings = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(list)) {
            for (Object item : list) {
                String str = DSSJsonUtils.toString(item);
                if (Utils.isStringNotEmpty(str)) {
                    listOfStrings.add(str);
                    continue;
                }
                LOG.warn("An empty String entry within a JSON Object has been skipped.");
            }
        }
        return listOfStrings;
    }

    public static List<Number> toListOfNumbers(List<?> list) {
        ArrayList<Number> listOfNumbers = new ArrayList<Number>();
        if (Utils.isCollectionNotEmpty(list)) {
            for (Object item : list) {
                Number num = DSSJsonUtils.toNumber(item);
                if (num == null) continue;
                listOfNumbers.add(num);
            }
        }
        return listOfNumbers;
    }

    public static String getMimeTypeString(String mimeType) {
        if (Utils.isStringNotEmpty(mimeType) && !mimeType.contains("/")) {
            return MIME_TYPE_APPLICATION_PREFIX + mimeType;
        }
        return mimeType;
    }

    public static long getTimeValueInSeconds(long timeInMillis) {
        return NumericDate.fromMilliseconds(timeInMillis).getValue();
    }

    public static long getTimeValueInMilliseconds(long timeWithoutMillis) {
        return NumericDate.fromSeconds(timeWithoutMillis).getValueInMillis();
    }

    static {
        criticalHeaderExceptions = Stream.of("alg", "jku", "jwk", "kid", "x5u", "x5c", "x5t", "x5t#S256", "typ", "cty", "crit", "epk", "apu", "apv", "iv", "tag", "p2s", "p2c", "enc", "zip").collect(Collectors.toSet());
        requiredCriticalHeaders = Stream.of("sigD", "b64").collect(Collectors.toSet());
    }
}

