/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSJsonSerializationGenerator;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESCounterSignatureParameters;
import eu.europa.esig.dss.jades.signature.JAdESExtensionBuilder;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentAnalyzer;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWSDocumentAnalyzerFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;

public class JAdESCounterSignatureBuilder
extends JAdESExtensionBuilder {
    public DSSDocument getSignatureValueToBeSigned(DSSDocument signatureDocument, JAdESCounterSignatureParameters parameters) {
        JWSDocumentAnalyzerFactory documentValidatorFactory = new JWSDocumentAnalyzerFactory();
        AbstractJWSDocumentAnalyzer documentValidator = documentValidatorFactory.create(signatureDocument);
        JWSJsonSerializationObject jwsJsonSerializationObject = documentValidator.getJwsJsonSerializationObject();
        this.assertJSONSerializationObjectMayBeExtended(jwsJsonSerializationObject);
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        JAdESSignature jadesSignature = (JAdESSignature)this.extractSignatureById(signatures, parameters.getSignatureIdToCounterSign());
        return new InMemoryDocument(jadesSignature.getSignatureValue());
    }

    public DSSDocument buildEmbeddedCounterSignature(DSSDocument signatureDocument, DSSDocument counterSignature, JAdESCounterSignatureParameters parameters) {
        JWSDocumentAnalyzerFactory documentValidatorFactory = new JWSDocumentAnalyzerFactory();
        AbstractJWSDocumentAnalyzer documentValidator = documentValidatorFactory.create(signatureDocument);
        JWSJsonSerializationObject jwsJsonSerializationObject = documentValidator.getJwsJsonSerializationObject();
        this.assertJSONSerializationObjectMayBeExtended(jwsJsonSerializationObject);
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        JAdESSignature jadesSignature = (JAdESSignature)this.extractSignatureById(signatures, parameters.getSignatureIdToCounterSign());
        this.assertEtsiUComponentsConsistent(jadesSignature.getJws(), parameters);
        Object cSig = this.getCSig(counterSignature, parameters.getJwsSerializationType());
        JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
        etsiUHeader.addComponent("cSig", cSig, Utils.isTrue(parameters.isBase64UrlEncodedEtsiUComponents()));
        this.updateMasterSignatureRecursively(jadesSignature);
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, jwsJsonSerializationObject.getJWSSerializationType());
        return generator.generate();
    }

    private void updateMasterSignatureRecursively(JAdESSignature jadesSignature) {
        JAdESSignature masterSignature = (JAdESSignature)jadesSignature.getMasterSignature();
        if (masterSignature != null) {
            EtsiUComponent masterCSigAttribute = jadesSignature.getMasterCSigComponent();
            JWSJsonSerializationObject jwsJsonSerializationObject = jadesSignature.getJws().getJwsJsonSerializationObject();
            JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, jwsJsonSerializationObject.getJWSSerializationType());
            Object cSig = this.getCSig(generator.generate(), jwsJsonSerializationObject.getJWSSerializationType());
            EtsiUComponent updatedCSigAttribute = EtsiUComponent.build("cSig", cSig, masterCSigAttribute.isBase64UrlEncoded(), masterCSigAttribute.getIdentifier());
            this.replaceCSigComponent(jadesSignature, updatedCSigAttribute);
            this.updateMasterSignatureRecursively(masterSignature);
        }
    }

    private Object getCSig(DSSDocument counterSignature, JWSSerializationType jwsSerializationType) {
        Object cSig;
        String signatureString = new String(DSSUtils.toByteArray(counterSignature));
        switch (jwsSerializationType) {
            case COMPACT_SERIALIZATION: {
                cSig = signatureString;
                break;
            }
            case FLATTENED_JSON_SERIALIZATION: {
                try {
                    cSig = new JsonObject(JsonUtil.parseJson(signatureString));
                    break;
                }
                catch (JoseException e) {
                    throw new IllegalInputException(String.format("Unable to parse a counter signature. Reason : %s", e.getMessage()), e);
                }
            }
            default: {
                throw new UnsupportedOperationException(String.format("The JWSSerializarionType '%s' is not supported for a Counter Signature!", new Object[]{jwsSerializationType}));
            }
        }
        return cSig;
    }

    private void replaceCSigComponent(JAdESSignature jadesSignature, EtsiUComponent cSigAttribute) {
        JAdESSignature masterSignature = (JAdESSignature)jadesSignature.getMasterSignature();
        JAdESEtsiUHeader etsiUHeader = masterSignature.getEtsiUHeader();
        etsiUHeader.replaceComponent(cSigAttribute);
        jadesSignature.setMasterCSigComponent(cSigAttribute);
    }

    private AdvancedSignature extractSignatureById(List<AdvancedSignature> signatures, String signatureId) {
        Objects.requireNonNull(signatureId, "The Id of a signature to be counter signed shall be defined! Please use SerializableCounterSignatureParameters.setSignatureIdToCounterSign(signatureId) method.");
        if (Utils.isCollectionEmpty(signatures)) {
            throw new IllegalArgumentException("The provided signatureDocument does not contain JAdES Signatures!");
        }
        for (AdvancedSignature signature : signatures) {
            JAdESSignature signatureById = this.getSignatureOrItsCounterSignature((JAdESSignature)signature, signatureId);
            if (signatureById == null) continue;
            return signatureById;
        }
        throw new IllegalArgumentException(String.format("The requested JAdES Signature with id '%s' has not been found in the provided file!", signatureId));
    }

    private JAdESSignature getSignatureOrItsCounterSignature(JAdESSignature signature, String signatureId) {
        if (signatureId == null || signatureId.equals(signature.getId())) {
            return signature;
        }
        List<EtsiUComponent> cSigComponents = DSSJsonUtils.getUnsignedPropertiesWithHeaderName(signature.getEtsiUHeader(), "cSig");
        if (Utils.isCollectionNotEmpty(cSigComponents)) {
            for (EtsiUComponent cSigComponent : cSigComponents) {
                if (signature.getTimestampSource().isTimestamped(signatureId, TimestampedObjectType.SIGNATURE)) {
                    throw new IllegalInputException(String.format("Unable to counter sign a signature with Id '%s'. The signature is timestamped by a master signature!", signatureId));
                }
                JAdESSignature counterSignature = DSSJsonUtils.extractJAdESCounterSignature(cSigComponent, signature);
                JAdESSignature signatureById = this.getSignatureOrItsCounterSignature(counterSignature, signatureId);
                if (signatureById == null) continue;
                if (cSigComponent.getValue() instanceof String) {
                    throw new IllegalInputException("Unable to extend a Compact JAdES Signature with id '" + signatureId + "'");
                }
                return signatureById;
            }
        }
        return null;
    }
}

