/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JAdESExtensionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESExtensionBuilder.class);

    protected JAdESExtensionBuilder() {
    }

    protected void assertEtsiUComponentsConsistent(JWS jws, JAdESSignatureParameters signatureParameters) {
        Boolean isBase64UrlEtsiUComponents = signatureParameters.isBase64UrlEncodedEtsiUComponents();
        isBase64UrlEtsiUComponents = this.assertEtsiUComponentsConsistent(jws, isBase64UrlEtsiUComponents);
        signatureParameters.setBase64UrlEncodedEtsiUComponents(isBase64UrlEtsiUComponents);
    }

    protected boolean assertEtsiUComponentsConsistent(JWS jws, Boolean isBase64UrlEtsiUComponents) {
        List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
        if (Utils.isCollectionNotEmpty(etsiU)) {
            if (!DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                throw new IllegalInputException("Extension is not possible, because components of the 'etsiU' header have not common format! Shall be all Strings or Objects.");
            }
            boolean isEtsiUInBase64UrlForm = DSSJsonUtils.areAllBase64UrlComponents(etsiU);
            if (isBase64UrlEtsiUComponents == null) {
                LOG.info("base64UrlEtsiUComponents parameter is not defined. The check of etsiU unsigned header structure is skipped. Use the current value.");
            } else if (isBase64UrlEtsiUComponents != isEtsiUInBase64UrlForm) {
                throw new IllegalInputException(String.format("Extension is not possible! The encoding of 'etsiU' components shall match! Use jadesSignatureParameters.setBase64UrlEncodedEtsiUComponents(%s)", isBase64UrlEtsiUComponents == false));
            }
            return isEtsiUInBase64UrlForm;
        }
        if (isBase64UrlEtsiUComponents == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("base64UrlEtsiUComponents parameters is not defined. Use the default value (true).");
            }
            return true;
        }
        return isBase64UrlEtsiUComponents;
    }

    protected void assertJWSJsonSerializationObjectValid(JWSJsonSerializationObject jwsJsonSerializationObject) {
        if (jwsJsonSerializationObject == null) {
            throw new IllegalInputException("The provided document is not a valid JAdES signature! Unable to extend.");
        }
        if (Utils.isCollectionEmpty(jwsJsonSerializationObject.getSignatures())) {
            throw new IllegalInputException("No signatures found to be extended!");
        }
        if (!jwsJsonSerializationObject.isValid()) {
            throw new IllegalInputException(String.format("Signature extension is not supported for invalid RFC 7515 files (shall be a Serializable JAdES signature). Reason(s) : %s", jwsJsonSerializationObject.getStructuralValidationErrors()));
        }
    }

    protected void assertJSONSerializationObjectMayBeExtended(JWSJsonSerializationObject jwsJsonSerializationObject) {
        this.assertJWSJsonSerializationObjectValid(jwsJsonSerializationObject);
        JWSSerializationType jwsSerializationType = jwsJsonSerializationObject.getJWSSerializationType();
        if (!JWSSerializationType.JSON_SERIALIZATION.equals((Object)jwsSerializationType) && !JWSSerializationType.FLATTENED_JSON_SERIALIZATION.equals((Object)jwsSerializationType)) {
            throw new IllegalInputException("The extended signature shall have JSON Serialization (or Flattened) type! Use JWSConverter to convert the signature.");
        }
    }
}

