/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.PKIEncoding;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.jades.validation.JAdESCertificateRefExtractionUtils;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.jades.validation.KidCertificateSource;
import eu.europa.esig.dss.jades.validation.X509URLCertificateSource;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.SignatureCertificateSource;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.utils.Utils;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESCertificateSource
extends SignatureCertificateSource {
    private static final long serialVersionUID = -8170607661341382049L;
    private static final Logger LOG = LoggerFactory.getLogger(JAdESCertificateSource.class);
    private final transient JWS jws;
    private final transient JAdESEtsiUHeader etsiUHeader;
    private final Map<String, Collection<CertificateToken>> x509UrlMap = new HashMap<String, Collection<CertificateToken>>();

    public JAdESCertificateSource(JWS jws, JAdESEtsiUHeader etsiUHeader) {
        Objects.requireNonNull(jws, "JSON Web signature cannot be null");
        Objects.requireNonNull(etsiUHeader, "etsiUHeader cannot be null");
        this.jws = jws;
        this.etsiUHeader = etsiUHeader;
        this.extractX5T();
        this.extractX5TS256();
        this.extractX5TO();
        this.extractSigX5Ts();
        this.extractKid();
        this.extractX509Url();
        this.extractX5C();
        this.extractEtsiU();
    }

    public List<CertificateRef> getKeyIdentifierCertificateRefs() {
        return this.getCertificateRefsByOrigin(CertificateRefOrigin.KEY_IDENTIFIER);
    }

    public Set<CertificateToken> getKeyIdentifierCertificates() {
        return this.findTokensFromRefs(this.getKeyIdentifierCertificateRefs());
    }

    private void extractX5T() {
        String base64UrlSHA1Certificate = this.jws.getProtectedHeaderValueAsString("x5t");
        if (Utils.isStringNotEmpty(base64UrlSHA1Certificate)) {
            Digest digest = new Digest(DigestAlgorithm.SHA1, DSSJsonUtils.fromBase64Url(base64UrlSHA1Certificate));
            LOG.warn("Found {} with value {} but not supported by the JAdES standard", (Object)"x5t", (Object)digest);
        }
    }

    private void extractX5TS256() {
        String base64UrlSHA256Certificate = this.jws.getProtectedHeaderValueAsString("x5t#S256");
        if (Utils.isStringNotEmpty(base64UrlSHA256Certificate)) {
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(new Digest(DigestAlgorithm.SHA256, DSSJsonUtils.fromBase64Url(base64UrlSHA256Certificate)));
            this.addCertificateRef(certRef, CertificateRefOrigin.SIGNING_CERTIFICATE);
        }
    }

    private void extractX5TO() {
        this.extractX5TO(this.jws.getProtectedHeaderValueAsMap("x5t#o"));
    }

    private void extractX5TO(Map<?, ?> x5TO) {
        Digest digest;
        if (Utils.isMapNotEmpty(x5TO) && (digest = DSSJsonUtils.getDigest(x5TO)) != null) {
            CertificateRef certRef = new CertificateRef();
            certRef.setCertDigest(digest);
            this.addCertificateRef(certRef, CertificateRefOrigin.SIGNING_CERTIFICATE);
        }
    }

    private void extractSigX5Ts() {
        List<?> sigX5tsList = this.jws.getProtectedHeaderValueAsList("sigX5ts");
        if (Utils.isCollectionNotEmpty(sigX5tsList)) {
            for (Object item : sigX5tsList) {
                this.extractX5TO(DSSJsonUtils.toMap(item, "x5t#o"));
            }
        }
    }

    private void extractKid() {
        IssuerSerial kidIssuerSerial = this.getKidIssuerSerial();
        if (kidIssuerSerial != null) {
            CertificateRef certificateRef = new CertificateRef();
            certificateRef.setCertificateIdentifier(DSSASN1Utils.toSignerIdentifier(kidIssuerSerial));
            this.addCertificateRef(certificateRef, CertificateRefOrigin.KEY_IDENTIFIER);
        }
    }

    private void extractX509Url() {
        String x5u = this.jws.getProtectedHeaderValueAsString("x5u");
        if (Utils.isStringNotEmpty(x5u)) {
            CertificateRef certificateRef = new CertificateRef();
            certificateRef.setX509Url(x5u);
            this.addCertificateRef(certificateRef, CertificateRefOrigin.X509_URL);
        }
    }

    private void extractX5C() {
        List<?> x509CertChain = this.jws.getProtectedHeaderValueAsList("x5c");
        if (Utils.isCollectionNotEmpty(x509CertChain)) {
            for (Object item : x509CertChain) {
                String certificateBase64 = DSSJsonUtils.toString(item);
                if (!Utils.isStringNotEmpty(certificateBase64)) continue;
                try {
                    CertificateToken certificate = DSSUtils.loadCertificateFromBase64EncodedString(certificateBase64);
                    this.addCertificate(certificate, CertificateOrigin.KEY_INFO);
                }
                catch (Exception e) {
                    LOG.warn("Unable to decode a certificate from '{}'! Reason : {}", certificateBase64, e.getMessage(), e);
                }
            }
        }
    }

    private void extractEtsiU() {
        if (!this.etsiUHeader.isExist()) {
            return;
        }
        for (JAdESAttribute jAdESAttribute : this.etsiUHeader.getAttributes()) {
            this.extractCertificateValues(jAdESAttribute);
            this.extractAttrAuthoritiesCertValues(jAdESAttribute);
            this.extractTimestampValidationData(jAdESAttribute);
            this.extractAnyValidationData(jAdESAttribute);
            this.extractCompleteCertificateRefs(jAdESAttribute);
            this.extractAttributeCertificateRefs(jAdESAttribute);
        }
    }

    private void extractCertificateValues(JAdESAttribute attribute) {
        if ("xVals".equals(attribute.getHeaderName())) {
            this.extractCertificateValues(DSSJsonUtils.toList(attribute.getValue(), "xVals"), CertificateOrigin.CERTIFICATE_VALUES);
        }
    }

    private void extractAttrAuthoritiesCertValues(JAdESAttribute attribute) {
        if ("axVals".equals(attribute.getHeaderName())) {
            this.extractCertificateValues(DSSJsonUtils.toList(attribute.getValue(), "axVals"), CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES);
        }
    }

    private void extractTimestampValidationData(JAdESAttribute attribute) {
        this.extractValidationData(attribute, "tstVD", CertificateOrigin.TIMESTAMP_VALIDATION_DATA);
    }

    private void extractAnyValidationData(JAdESAttribute attribute) {
        this.extractValidationData(attribute, "anyValData", CertificateOrigin.ANY_VALIDATION_DATA);
    }

    private void extractValidationData(JAdESAttribute attribute, String headerName, CertificateOrigin origin) {
        Map<?, ?> tstVd;
        List<?> xVals;
        if (headerName.equals(attribute.getHeaderName()) && Utils.isCollectionNotEmpty(xVals = DSSJsonUtils.getAsList(tstVd = DSSJsonUtils.toMap(attribute.getValue(), headerName), "xVals"))) {
            this.extractCertificateValues(xVals, origin);
        }
    }

    private void extractCompleteCertificateRefs(JAdESAttribute attribute) {
        if ("xRefs".equals(attribute.getHeaderName())) {
            this.extractCertificateRefs(DSSJsonUtils.toList(attribute.getValue(), "xRefs"), CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
        }
    }

    private void extractAttributeCertificateRefs(JAdESAttribute attribute) {
        if ("axRefs".equals(attribute.getHeaderName())) {
            this.extractCertificateRefs(DSSJsonUtils.toList(attribute.getValue(), "axRefs"), CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
        }
    }

    private void extractCertificateValues(List<?> xVals, CertificateOrigin origin) {
        for (Object item : xVals) {
            Map<?, ?> xVal = DSSJsonUtils.toMap(item);
            Map<?, ?> x509Cert = DSSJsonUtils.getAsMap(xVal, "x509Cert");
            Map<?, ?> otherCert = DSSJsonUtils.getAsMap(xVal, "otherCert");
            if (Utils.isMapNotEmpty(x509Cert)) {
                this.extractX509Cert(x509Cert, origin);
                continue;
            }
            if (!Utils.isMapNotEmpty(otherCert)) continue;
            LOG.warn("The header '{}' is not supported! The entry is skipped.", (Object)"otherCert");
        }
    }

    private void extractCertificateRefs(List<?> xRefs, CertificateRefOrigin origin) {
        for (Object item : xRefs) {
            Map<?, ?> xref = DSSJsonUtils.toMap(item);
            CertificateRef certificateRef = JAdESCertificateRefExtractionUtils.createCertificateRef(xref);
            if (certificateRef == null) continue;
            this.addCertificateRef(certificateRef, origin);
        }
    }

    private void extractX509Cert(Map<?, ?> x509Cert, CertificateOrigin origin) {
        String encoding = DSSJsonUtils.getAsString(x509Cert, "encoding");
        if (Utils.isStringEmpty(encoding) || Utils.areStringsEqual(PKIEncoding.DER.getUri(), encoding)) {
            String val = DSSJsonUtils.getAsString(x509Cert, "val");
            if (Utils.isStringNotEmpty(val)) {
                try {
                    this.addCertificate(DSSUtils.loadCertificateFromBase64EncodedString(val), origin);
                }
                catch (Exception e) {
                    LOG.warn("Unable to decode a certificate from '{}'! Reason : {}", val, e.getMessage(), e);
                }
            }
        } else {
            LOG.warn("Unsupported encoding header value : '{}'", (Object)encoding);
        }
    }

    @Override
    protected CandidatesForSigningCertificate extractCandidatesForSigningCertificate(CertificateSource signingCertificateSource) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        for (CertificateToken certificateToken : this.getKeyInfoCertificates()) {
            candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
        }
        if (candidatesForSigningCertificate.isEmpty()) {
            PublicKey publicKey = this.extractPublicKey();
            if (publicKey != null) {
                candidatesForSigningCertificate.add(new CertificateValidity(publicKey));
            } else {
                for (CertificateToken certificateToken : this.getCertificates()) {
                    candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
                }
            }
        }
        if (signingCertificateSource != null) {
            this.resolveFromSource(signingCertificateSource, candidatesForSigningCertificate);
        }
        this.checkSigningCertificateRef(candidatesForSigningCertificate);
        return candidatesForSigningCertificate;
    }

    private void resolveFromSource(CertificateSource signingCertificateSource, CandidatesForSigningCertificate candidatesForSigningCertificate) {
        block6: {
            block5: {
                CertificateToken kidCandidate = this.resolveByKid(signingCertificateSource);
                if (kidCandidate != null) {
                    LOG.debug("Resolved certificate by kid");
                    super.addCertificate(kidCandidate);
                    candidatesForSigningCertificate.add(new CertificateValidity(kidCandidate));
                    return;
                }
                Collection<CertificateToken> uriCandidates = this.resolveByUri(signingCertificateSource);
                if (Utils.isCollectionNotEmpty(uriCandidates)) {
                    LOG.debug("Resolved certificates by x5u");
                    for (CertificateToken externalCandidate : uriCandidates) {
                        super.addCertificate(externalCandidate);
                        candidatesForSigningCertificate.add(new CertificateValidity(externalCandidate));
                    }
                    return;
                }
                Digest certificateDigest = this.getSigningCertificateDigest();
                if (certificateDigest == null) break block5;
                Set<CertificateToken> certificatesByDigest = signingCertificateSource.getByCertificateDigest(certificateDigest);
                if (!Utils.isCollectionNotEmpty(certificatesByDigest)) break block6;
                LOG.debug("Resolved certificate by digest");
                for (CertificateToken certificateToken : certificatesByDigest) {
                    candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
                }
                break block6;
            }
            List<CertificateToken> certificates = signingCertificateSource.getCertificates();
            LOG.debug("No signing certificate reference found. Resolve all {} certificates from the provided certificate source as signing candidates.", (Object)certificates.size());
            for (CertificateToken certCandidate : certificates) {
                candidatesForSigningCertificate.add(new CertificateValidity(certCandidate));
            }
        }
    }

    private CertificateToken resolveByKid(CertificateSource signingCertificateSource) {
        String kidHeader = this.jws.getKeyIdHeaderValue();
        if (Utils.isStringNotEmpty(kidHeader)) {
            if (signingCertificateSource instanceof KidCertificateSource) {
                KidCertificateSource kidCertificateSource = (KidCertificateSource)signingCertificateSource;
                return kidCertificateSource.getCertificateByKid(kidHeader);
            }
            LOG.warn("JWS/JAdES contains a 'kid' header (provide a KidCertificateSource to resolve it)");
        }
        return null;
    }

    private Collection<CertificateToken> resolveByUri(CertificateSource signingCertificateSource) {
        String x5uHeader = this.jws.getProtectedHeaderValueAsString("x5u");
        if (Utils.isStringNotEmpty(x5uHeader)) {
            if (signingCertificateSource instanceof X509URLCertificateSource) {
                X509URLCertificateSource x509URLCertificateSource = (X509URLCertificateSource)signingCertificateSource;
                Collection<CertificateToken> certificatesByUri = x509URLCertificateSource.getCertificatesByUrl(x5uHeader);
                if (Utils.isCollectionNotEmpty(certificatesByUri)) {
                    this.x509UrlMap.put(x5uHeader, certificatesByUri);
                }
                return certificatesByUri;
            }
            LOG.warn("JWS/JAdES contains a 'x5u' header (provide a X509URLCertificateSource to resolve it)");
        }
        return Collections.emptyList();
    }

    private PublicKey extractPublicKey() {
        try {
            PublicJsonWebKey jwkHeader = this.jws.getJwkHeader();
            if (jwkHeader != null) {
                return jwkHeader.getPublicKey();
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to extract the public key", e);
        }
        return null;
    }

    private void checkSigningCertificateRef(CandidatesForSigningCertificate candidates) {
        CertificateRef signingCertRef = null;
        List<CertificateRef> potentialSigningCertificates = this.getSigningCertificateRefs();
        if (Utils.isCollectionNotEmpty(potentialSigningCertificates)) {
            signingCertRef = potentialSigningCertificates.get(0);
        }
        CertificateRef kidCertRef = null;
        List<CertificateRef> keyIdentifierCertificateRefs = this.getKeyIdentifierCertificateRefs();
        if (Utils.isCollectionNotEmpty(keyIdentifierCertificateRefs)) {
            kidCertRef = keyIdentifierCertificateRefs.get(0);
        }
        if (signingCertRef != null) {
            CertificateValidity bestCertificateValidity = null;
            List<CertificateValidity> certificateValidityList = candidates.getCertificateValidityList();
            for (CertificateValidity certificateValidity : certificateValidityList) {
                if (!this.isValid(certificateValidity, signingCertRef, kidCertRef)) continue;
                bestCertificateValidity = certificateValidity;
            }
            if (bestCertificateValidity != null) {
                candidates.setTheCertificateValidity(bestCertificateValidity);
            }
        }
    }

    private boolean isValid(CertificateValidity certificateValidity, CertificateRef signingCertRef, CertificateRef kidCertRef) {
        certificateValidity.setDigestPresent(signingCertRef != null && signingCertRef.getCertDigest() != null);
        certificateValidity.setIssuerSerialPresent(kidCertRef != null && kidCertRef.getCertificateIdentifier() != null);
        CertificateToken certificateToken = certificateValidity.getCertificateToken();
        if (certificateToken != null) {
            if (signingCertRef != null) {
                certificateValidity.setDigestEqual(this.certificateMatcher.matchByDigest(certificateToken, signingCertRef));
            }
            if (kidCertRef != null) {
                certificateValidity.setSerialNumberEqual(this.certificateMatcher.matchBySerialNumber(certificateToken, kidCertRef));
                certificateValidity.setDistinguishedNameEqual(this.certificateMatcher.matchByIssuerName(certificateToken, kidCertRef));
            }
        }
        return certificateValidity.isValid();
    }

    private Digest getSigningCertificateDigest() {
        List<CertificateRef> signingCertificateRefs = this.getSigningCertificateRefs();
        if (Utils.isCollectionNotEmpty(signingCertificateRefs)) {
            CertificateRef signingCert = signingCertificateRefs.get(0);
            return signingCert.getCertDigest();
        }
        return null;
    }

    private IssuerSerial getKidIssuerSerial() {
        return DSSJsonUtils.getIssuerSerial(this.jws.getKeyIdHeaderValue());
    }

    @Override
    public List<CertificateRef> getOrphanCertificateRefs() {
        List<CertificateRef> certRefs = super.getOrphanCertificateRefs();
        List<CertificateRef> x509CertUriRefs = this.getCertificateRefsByOrigin(CertificateRefOrigin.X509_URL);
        if (Utils.isCollectionNotEmpty(x509CertUriRefs)) {
            for (CertificateRef certificateRef : x509CertUriRefs) {
                if (certRefs.contains(certificateRef)) continue;
                certRefs.add(certificateRef);
            }
        }
        return certRefs;
    }

    @Override
    public List<CertificateRef> getReferencesForCertificateToken(CertificateToken certificateToken) {
        List<CertificateRef> result = super.getReferencesForCertificateToken(certificateToken);
        for (Map.Entry<String, Collection<CertificateToken>> x5uEntry : this.x509UrlMap.entrySet()) {
            if (!x5uEntry.getValue().contains(certificateToken)) continue;
            for (CertificateRef certificateRef : this.getCertificateRefsByOrigin(CertificateRefOrigin.X509_URL)) {
                if (!x5uEntry.getKey().equals(certificateRef.getX509Url())) continue;
                result.add(certificateRef);
            }
        }
        return result;
    }

    @Override
    public Set<CertificateToken> findTokensFromCertRef(CertificateRef certificateRef) {
        Collection<CertificateToken> x509UrlCertificates;
        Set<CertificateToken> certificates = super.findTokensFromCertRef(certificateRef);
        if (Utils.isStringNotEmpty(certificateRef.getX509Url()) && Utils.isCollectionNotEmpty(x509UrlCertificates = this.x509UrlMap.get(certificateRef.getX509Url()))) {
            certificates.addAll(x509UrlCertificates);
        }
        return certificates;
    }
}

