/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.identifier.AbstractSignatureIdentifierBuilder;

public class JAdESSignatureIdentifierBuilder
extends AbstractSignatureIdentifierBuilder {
    private static final long serialVersionUID = -3147216480139711930L;

    public JAdESSignatureIdentifierBuilder(JAdESSignature signature) {
        super(signature);
    }

    @Override
    protected Integer getCounterSignaturePosition(AdvancedSignature masterSignature) {
        JAdESSignature jadesSignature = (JAdESSignature)this.signature;
        JAdESSignature jadesMasterSignature = (JAdESSignature)masterSignature;
        EtsiUComponent masterCSigAttribute = jadesSignature.getMasterCSigComponent();
        int counter = 0;
        if (masterCSigAttribute != null) {
            for (AdvancedSignature counterSignature : jadesMasterSignature.getCounterSignatures()) {
                JAdESSignature jadesCounterSignature = (JAdESSignature)counterSignature;
                if (masterCSigAttribute.hashCode() == jadesCounterSignature.getMasterCSigComponent().hashCode()) break;
                ++counter;
            }
        }
        return counter;
    }

    @Override
    protected Integer getSignaturePosition() {
        JAdESSignature jadesSignature = (JAdESSignature)this.signature;
        JWS currentJWS = jadesSignature.getJws();
        JWSJsonSerializationObject jwsJsonSerializationObject = jadesSignature.getJws().getJwsJsonSerializationObject();
        int counter = 0;
        if (jwsJsonSerializationObject != null) {
            for (JWS jws : jwsJsonSerializationObject.getSignatures()) {
                if (currentJWS == jws) break;
                ++counter;
            }
        }
        return counter;
    }
}

