/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDocument
extends CommonDocument {
    private static final Logger LOG = LoggerFactory.getLogger(FileDocument.class);
    private final File file;

    public FileDocument(String path) {
        this(new File(path));
    }

    public FileDocument(File file) {
        Objects.requireNonNull(file, "File cannot be null");
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File '{}' does not exist!", (Object)file.getAbsolutePath());
            }
            throw new DSSException(String.format("Unable to create FileDocument for File with name '%s'", file.getName()));
        }
        this.file = file;
        this.name = file.getName();
        this.mimeType = MimeType.fromFileName(file.getName());
    }

    @Override
    public InputStream openStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new DSSException("Unable to create a FileInputStream", e);
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileDocument document = (FileDocument)object;
        return Objects.equals(this.file, document.file);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.file);
        return result;
    }
}

