/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.policy.crypto;

import eu.europa.esig.dss.enumerations.CryptographicSuiteAlgorithmUsage;
import eu.europa.esig.dss.enumerations.CryptographicSuiteRecommendation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CryptographicSuiteEvaluation
implements Serializable {
    private static final long serialVersionUID = 993827242614523749L;
    private List<CryptographicSuiteParameter> parameterList;
    private Date validityStart;
    private Date validityEnd;
    private List<CryptographicSuiteAlgorithmUsage> algorithmUsage;
    private CryptographicSuiteRecommendation recommendation;

    public List<CryptographicSuiteParameter> getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(List<CryptographicSuiteParameter> parameterList) {
        this.parameterList = parameterList;
    }

    public Date getValidityStart() {
        return this.validityStart;
    }

    public void setValidityStart(Date validityStart) {
        this.validityStart = validityStart;
    }

    public Date getValidityEnd() {
        return this.validityEnd;
    }

    public void setValidityEnd(Date validityEnd) {
        this.validityEnd = validityEnd;
    }

    public List<CryptographicSuiteAlgorithmUsage> getAlgorithmUsage() {
        return this.algorithmUsage;
    }

    public void setAlgorithmUsage(List<CryptographicSuiteAlgorithmUsage> algorithmUsage) {
        this.algorithmUsage = algorithmUsage;
    }

    public CryptographicSuiteRecommendation getRecommendation() {
        return this.recommendation;
    }

    public void setRecommendation(CryptographicSuiteRecommendation recommendation) {
        this.recommendation = recommendation;
    }

    public static CryptographicSuiteEvaluation copy(CryptographicSuiteEvaluation evaluation) {
        if (evaluation == null) {
            return null;
        }
        CryptographicSuiteEvaluation copy = new CryptographicSuiteEvaluation();
        if (evaluation.parameterList != null) {
            copy.parameterList = evaluation.parameterList.stream().map(CryptographicSuiteParameter::copy).collect(Collectors.toList());
        }
        copy.validityStart = evaluation.validityStart;
        copy.validityEnd = evaluation.validityEnd;
        if (evaluation.algorithmUsage != null) {
            copy.algorithmUsage = new ArrayList<CryptographicSuiteAlgorithmUsage>(evaluation.algorithmUsage);
        }
        copy.recommendation = evaluation.recommendation;
        return copy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CryptographicSuiteEvaluation that = (CryptographicSuiteEvaluation)object;
        return Objects.equals(this.parameterList, that.parameterList) && Objects.equals(this.validityStart, that.validityStart) && Objects.equals(this.validityEnd, that.validityEnd) && Objects.equals(this.algorithmUsage, that.algorithmUsage) && this.recommendation == that.recommendation;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.parameterList);
        result = 31 * result + Objects.hashCode(this.validityStart);
        result = 31 * result + Objects.hashCode(this.validityEnd);
        result = 31 * result + Objects.hashCode(this.algorithmUsage);
        result = 31 * result + Objects.hashCode((Object)this.recommendation);
        return result;
    }

    public String toString() {
        return "CryptographicSuiteEvaluation [parameterList=" + this.parameterList + ", validityStart=" + this.validityStart + ", validityEnd=" + this.validityEnd + ", algorithmUsage=" + this.algorithmUsage + ", recommendation=" + (Object)((Object)this.recommendation) + ']';
    }
}

