/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.tsl;

import eu.europa.esig.dss.enumerations.MRAStatus;
import eu.europa.esig.dss.model.timedependent.BaseTimeDependent;
import eu.europa.esig.dss.model.tsl.CertificateContentEquivalence;
import eu.europa.esig.dss.model.tsl.ServiceTypeASi;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceEquivalence
extends BaseTimeDependent {
    private static final long serialVersionUID = 7729236073848705753L;
    private String legalInfoIdentifier;
    private MRAStatus status;
    private Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence;
    private Map<List<String>, List<String>> statusEquivalence;
    private List<CertificateContentEquivalence> certificateContentEquivalences;
    private Map<String, String> qualifierEquivalence;

    public ServiceEquivalence(ServiceEquivalenceBuilder builder) {
        super(builder.startDate, builder.endDate);
        this.legalInfoIdentifier = builder.legalInfoIdentifier;
        this.status = builder.status;
        this.typeAsiEquivalence = builder.typeAsiEquivalence;
        this.statusEquivalence = builder.statusEquivalence;
        this.certificateContentEquivalences = builder.certificateContentEquivalences;
        this.qualifierEquivalence = builder.qualifierEquivalence;
    }

    public String getLegalInfoIdentifier() {
        return this.legalInfoIdentifier;
    }

    public void setLegalInfoIdentifier(String legalInfoIdentifier) {
        this.legalInfoIdentifier = legalInfoIdentifier;
    }

    public MRAStatus getStatus() {
        return this.status;
    }

    public void setStatus(MRAStatus status) {
        this.status = status;
    }

    public Map<ServiceTypeASi, ServiceTypeASi> getTypeAsiEquivalence() {
        return this.typeAsiEquivalence;
    }

    public void setTypeAsiEquivalence(Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence) {
        this.typeAsiEquivalence = typeAsiEquivalence;
    }

    public Map<List<String>, List<String>> getStatusEquivalence() {
        return this.statusEquivalence;
    }

    public void setStatusEquivalence(Map<List<String>, List<String>> statusEquivalence) {
        this.statusEquivalence = statusEquivalence;
    }

    public List<CertificateContentEquivalence> getCertificateContentEquivalences() {
        return this.certificateContentEquivalences;
    }

    public void setCertificateContentEquivalences(List<CertificateContentEquivalence> certificateContentEquivalences) {
        this.certificateContentEquivalences = certificateContentEquivalences;
    }

    public Map<String, String> getQualifierEquivalence() {
        return this.qualifierEquivalence;
    }

    public void setQualifierEquivalence(Map<String, String> qualifierEquivalence) {
        this.qualifierEquivalence = qualifierEquivalence;
    }

    @Override
    public String toString() {
        return "ServiceEquivalence [legalInfoIdentifier='" + this.legalInfoIdentifier + '\'' + ", status=" + this.status + ", typeAsiEquivalence=" + this.typeAsiEquivalence + ", statusEquivalence=" + this.statusEquivalence + ", certificateContentEquivalences=" + this.certificateContentEquivalences + ", qualifierEquivalence=" + this.qualifierEquivalence + "] " + super.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ServiceEquivalence that = (ServiceEquivalence)object;
        return Objects.equals(this.legalInfoIdentifier, that.legalInfoIdentifier) && this.status == that.status && Objects.equals(this.typeAsiEquivalence, that.typeAsiEquivalence) && Objects.equals(this.statusEquivalence, that.statusEquivalence) && Objects.equals(this.certificateContentEquivalences, that.certificateContentEquivalences) && Objects.equals(this.qualifierEquivalence, that.qualifierEquivalence);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.legalInfoIdentifier);
        result = 31 * result + Objects.hashCode(this.status);
        result = 31 * result + Objects.hashCode(this.typeAsiEquivalence);
        result = 31 * result + Objects.hashCode(this.statusEquivalence);
        result = 31 * result + Objects.hashCode(this.certificateContentEquivalences);
        result = 31 * result + Objects.hashCode(this.qualifierEquivalence);
        return result;
    }

    public static final class ServiceEquivalenceBuilder {
        private String legalInfoIdentifier;
        private MRAStatus status;
        private Date startDate;
        private Date endDate;
        private Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence;
        private Map<List<String>, List<String>> statusEquivalence;
        private List<CertificateContentEquivalence> certificateContentEquivalences;
        private Map<String, String> qualifierEquivalence;

        public ServiceEquivalence build() {
            return new ServiceEquivalence(this);
        }

        public ServiceEquivalenceBuilder setLegalInfoIdentifier(String legalInfoIdentifier) {
            this.legalInfoIdentifier = legalInfoIdentifier;
            return this;
        }

        public ServiceEquivalenceBuilder setStatus(MRAStatus status) {
            this.status = status;
            return this;
        }

        public ServiceEquivalenceBuilder setStartDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public ServiceEquivalenceBuilder setEndDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public ServiceEquivalenceBuilder setTypeAsiEquivalence(Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence) {
            this.typeAsiEquivalence = typeAsiEquivalence;
            return this;
        }

        public ServiceEquivalenceBuilder setStatusEquivalence(Map<List<String>, List<String>> statusEquivalence) {
            this.statusEquivalence = statusEquivalence;
            return this;
        }

        public ServiceEquivalenceBuilder setCertificateContentEquivalences(List<CertificateContentEquivalence> certificateContentEquivalences) {
            this.certificateContentEquivalences = certificateContentEquivalences;
            return this;
        }

        public ServiceEquivalenceBuilder setQualifierEquivalence(Map<String, String> qualifierEquivalence) {
            this.qualifierEquivalence = qualifierEquivalence;
            return this;
        }
    }
}

