/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.PdfSignatureCache;
import eu.europa.esig.dss.spi.DSSUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

public class PAdESTimestampParameters
extends CAdESTimestampParameters
implements PAdESCommonParameters {
    protected PdfSignatureCache pdfSignatureCache;
    protected Date timestampDate = new Date();
    private int timestampSize = 9472;
    private String timestampFilter = "Adobe.PPKLite";
    private String timestampSubFilter = "ETSI.RFC3161";
    private String appName;
    private SignatureImageParameters timestampImageParameters;
    private char[] passwordProtection;

    public PAdESTimestampParameters() {
    }

    public PAdESTimestampParameters(DigestAlgorithm digestAlgorithm) {
        super(digestAlgorithm);
    }

    PAdESTimestampParameters(CAdESTimestampParameters cadesTimestampParameters) {
        this(cadesTimestampParameters.getDigestAlgorithm());
    }

    @Override
    public String getFilter() {
        return this.timestampFilter;
    }

    public void setFilter(String timestampFilter) {
        this.timestampFilter = timestampFilter;
    }

    @Override
    public String getSubFilter() {
        return this.timestampSubFilter;
    }

    public void setSubFilter(String timestampSubFilter) {
        this.timestampSubFilter = timestampSubFilter;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return null;
    }

    @Override
    public SignatureImageParameters getImageParameters() {
        if (this.timestampImageParameters == null) {
            this.timestampImageParameters = new SignatureImageParameters();
        }
        return this.timestampImageParameters;
    }

    public void setImageParameters(SignatureImageParameters timestampImageParameters) {
        this.timestampImageParameters = timestampImageParameters;
    }

    @Override
    public int getContentSize() {
        return this.timestampSize;
    }

    public void setContentSize(int timestampSize) {
        this.timestampSize = timestampSize;
    }

    @Override
    public Date getSigningDate() {
        return this.timestampDate;
    }

    @Override
    public char[] getPasswordProtection() {
        return this.passwordProtection;
    }

    public void setPasswordProtection(char[] passwordProtection) {
        this.passwordProtection = passwordProtection;
    }

    @Override
    public String getDeterministicId() {
        return DSSUtils.getDeterministicId(this.timestampDate, null);
    }

    @Override
    public PdfSignatureCache getPdfSignatureCache() {
        if (this.pdfSignatureCache == null) {
            this.pdfSignatureCache = new PdfSignatureCache();
        }
        return this.pdfSignatureCache;
    }

    @Override
    public void reinit() {
        this.pdfSignatureCache = null;
    }

    @Override
    public String toString() {
        return "PAdESTimestampParameters [pdfSignatureCache=" + this.pdfSignatureCache + ", timestampDate=" + this.timestampDate + ", timestampSize=" + this.timestampSize + ", timestampFilter='" + this.timestampFilter + '\'' + ", timestampSubFilter='" + this.timestampSubFilter + '\'' + ", appName='" + this.appName + '\'' + ", timestampImageParameters=" + this.timestampImageParameters + ", passwordProtection=" + Arrays.toString(this.passwordProtection) + "] " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PAdESTimestampParameters that = (PAdESTimestampParameters)o;
        return this.timestampSize == that.timestampSize && Objects.equals(this.pdfSignatureCache, that.pdfSignatureCache) && Objects.equals(this.timestampDate, that.timestampDate) && Objects.equals(this.timestampFilter, that.timestampFilter) && Objects.equals(this.timestampSubFilter, that.timestampSubFilter) && Objects.equals(this.appName, that.appName) && Objects.equals(this.timestampImageParameters, that.timestampImageParameters) && Arrays.equals(this.passwordProtection, that.passwordProtection);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.pdfSignatureCache);
        result = 31 * result + Objects.hashCode(this.timestampDate);
        result = 31 * result + this.timestampSize;
        result = 31 * result + Objects.hashCode(this.timestampFilter);
        result = 31 * result + Objects.hashCode(this.timestampSubFilter);
        result = 31 * result + Objects.hashCode(this.appName);
        result = 31 * result + Objects.hashCode(this.timestampImageParameters);
        result = 31 * result + Arrays.hashCode(this.passwordProtection);
        return result;
    }
}

