/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.validation.PDFDocumentAnalyzer;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.validation.executor.CompleteValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESExtensionService {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESExtensionService.class);
    private final CertificateVerifier certificateVerifier;
    private final IPdfObjFactory pdfObjectFactory;

    public PAdESExtensionService(CertificateVerifier certificateVerifier) {
        this(certificateVerifier, new ServiceLoaderPdfObjFactory());
    }

    public PAdESExtensionService(CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        Objects.requireNonNull(certificateVerifier, "CertificateVerifier cannot be null!");
        Objects.requireNonNull(pdfObjectFactory, "PdfObjectFactory cannot be null!");
        this.certificateVerifier = certificateVerifier;
        this.pdfObjectFactory = pdfObjectFactory;
    }

    public DSSDocument incorporateValidationData(DSSDocument document) {
        return this.incorporateValidationData(document, null);
    }

    public DSSDocument incorporateValidationData(DSSDocument document, char[] passwordProtection) {
        return this.incorporateValidationData(document, passwordProtection, false);
    }

    public DSSDocument incorporateValidationData(DSSDocument document, char[] passwordProtection, boolean includeVRIDict) {
        Objects.requireNonNull(document, "The document to be extended shall be provided!");
        PDFDocumentAnalyzer pdfDocumentAnalyzer = this.getPDFDocumentAnalyzer(document, passwordProtection);
        List<AdvancedSignature> signatures = pdfDocumentAnalyzer.getSignatures();
        List<TimestampToken> detachedTimestamps = pdfDocumentAnalyzer.getDetachedTimestamps();
        if (Utils.isCollectionNotEmpty(signatures)) {
            List<TimestampToken> signatureTimestamps = this.getSignatureTimestamps(signatures);
            if (Utils.isCollectionEmpty(signatureTimestamps)) {
                LOG.info("The found signatures within the document with name '{}' do not have a T-level. Validation data incorporation skipped.", (Object)document.getName());
                return document;
            }
        } else if (!Utils.isCollectionNotEmpty(detachedTimestamps)) {
            LOG.info("No signatures or timestamps found within a document with name '{}'.", (Object)document.getName());
            return document;
        }
        ValidationDataContainer validationData = pdfDocumentAnalyzer.getValidationData(signatures, detachedTimestamps);
        if (validationData.isEmpty()) {
            LOG.warn("No validation data has been obtained for the document with name '{}'. Return original document.", (Object)document.getName());
            return document;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding DSS dictionary revision to the document with name '{}'", (Object)document.getName());
        }
        PDFSignatureService signatureService = this.newPdfSignatureService();
        return signatureService.addDssDictionary(document, (PdfValidationDataContainer)validationData, passwordProtection, includeVRIDict);
    }

    private List<TimestampToken> getSignatureTimestamps(List<AdvancedSignature> signatures) {
        ArrayList<TimestampToken> signatureTimestamps = new ArrayList<TimestampToken>();
        for (AdvancedSignature signature : signatures) {
            signatureTimestamps.addAll(signature.getAllTimestamps());
        }
        return signatureTimestamps;
    }

    private PDFDocumentAnalyzer getPDFDocumentAnalyzer(DSSDocument document, char[] passwordProtection) {
        PDFDocumentAnalyzer pdfDocumentAnalyzer = new PDFDocumentAnalyzer(document);
        pdfDocumentAnalyzer.setCertificateVerifier(this.certificateVerifier);
        pdfDocumentAnalyzer.setValidationContextExecutor(CompleteValidationContextExecutor.INSTANCE);
        pdfDocumentAnalyzer.setPasswordProtection(passwordProtection);
        pdfDocumentAnalyzer.setPdfObjFactory(this.pdfObjectFactory);
        return pdfDocumentAnalyzer;
    }

    private PDFSignatureService newPdfSignatureService() {
        return this.pdfObjectFactory.newPAdESSignatureService();
    }
}

