/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineB;
import eu.europa.esig.dss.model.DSSMessageDigest;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;

public class PAdESLevelBaselineB
extends CAdESLevelBaselineB {
    private final DSSMessageDigest messageDigest;

    public PAdESLevelBaselineB(DSSMessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    @Override
    protected void addSigningTimeAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
    }

    @Override
    protected void addSignerLocation(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
    }

    @Override
    protected void addContentIdentifier(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
    }

    @Override
    protected void addMimeType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
    }

    @Override
    protected void addSignedAttributes(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        super.addSignedAttributes(parameters, signedAttributes);
        this.addMessageImprint(parameters, signedAttributes);
    }

    protected void addMessageImprint(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        signedAttributes.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(this.messageDigest.getValue()))));
    }
}

