/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy;

import eu.europa.esig.dss.enumerations.CryptographicSuiteAlgorithmUsage;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteEvaluation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteParameter;
import eu.europa.esig.dss.policy.LevelConstraintWrapper;
import eu.europa.esig.dss.policy.jaxb.Algo;
import eu.europa.esig.dss.policy.jaxb.AlgoExpirationDate;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.ListAlgo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicConstraintWrapper
extends LevelConstraintWrapper
implements CryptographicSuite {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicConstraintWrapper.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String MODULES_LENGTH_PARAMETER = "moduluslength";
    private static final String PLENGTH_PARAMETER = "plength";
    private Map<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> acceptableDigestAlgorithms;
    private Map<SignatureAlgorithm, Set<CryptographicSuiteEvaluation>> acceptableSignatureAlgorithms;

    public CryptographicConstraintWrapper() {
        super(null);
    }

    public CryptographicConstraintWrapper(CryptographicConstraint constraint) {
        super(constraint);
    }

    @Override
    public String getPolicyName() {
        return "DSS Cryptographic Constraint";
    }

    @Override
    public Map<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> getAcceptableDigestAlgorithms() {
        if (this.acceptableDigestAlgorithms == null) {
            AlgoExpirationDate algoExpirationDate;
            List<Algo> algos;
            this.acceptableDigestAlgorithms = new EnumMap<DigestAlgorithm, Set<CryptographicSuiteEvaluation>>(DigestAlgorithm.class);
            ListAlgo digestAlgo = ((CryptographicConstraint)this.constraint).getAcceptableDigestAlgo();
            if (digestAlgo != null && (algos = digestAlgo.getAlgos()) != null && !algos.isEmpty()) {
                for (Algo algo : algos) {
                    DigestAlgorithm digestAlgorithm = this.toDigestAlgorithm(algo.getValue());
                    if (digestAlgorithm == null) continue;
                    this.acceptableDigestAlgorithms.computeIfAbsent(digestAlgorithm, v -> new HashSet());
                }
            }
            if ((algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
                SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDate);
                List<Algo> list = algoExpirationDate.getAlgos();
                if (list != null && !list.isEmpty()) {
                    for (Algo algo : list) {
                        DigestAlgorithm digestAlgorithm = this.toDigestAlgorithm(algo.getValue());
                        if (digestAlgorithm == null || !this.acceptableDigestAlgorithms.containsKey(digestAlgorithm)) continue;
                        CryptographicSuiteEvaluation evaluation = this.buildEvaluation(algo, dateFormat);
                        this.acceptableDigestAlgorithms.computeIfAbsent(digestAlgorithm, v -> new HashSet()).add(evaluation);
                    }
                }
            }
            for (Set set : this.acceptableDigestAlgorithms.values()) {
                if (!set.isEmpty()) continue;
                set.add(new CryptographicSuiteEvaluation());
            }
        }
        return this.acceptableDigestAlgorithms;
    }

    @Override
    public Map<SignatureAlgorithm, Set<CryptographicSuiteEvaluation>> getAcceptableSignatureAlgorithms() {
        if (this.acceptableSignatureAlgorithms == null) {
            ListAlgo miniPublicKeySize;
            SignatureAlgorithm signatureAlgorithm;
            EncryptionAlgorithm encryptionAlgorithm;
            List<Algo> algos;
            AlgoExpirationDate algoExpirationDate;
            List<Algo> algos2;
            this.acceptableSignatureAlgorithms = new EnumMap<SignatureAlgorithm, Set<CryptographicSuiteEvaluation>>(SignatureAlgorithm.class);
            Map<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> acceptableDigestAlgorithmsMap = this.getAcceptableDigestAlgorithms();
            ListAlgo encryptionAlgo = ((CryptographicConstraint)this.constraint).getAcceptableEncryptionAlgo();
            if (encryptionAlgo != null && (algos2 = encryptionAlgo.getAlgos()) != null && !algos2.isEmpty()) {
                for (Algo algo : algos2) {
                    EncryptionAlgorithm encryptionAlgorithm2 = this.toEncryptionAlgorithm(algo.getValue());
                    if (encryptionAlgorithm2 == null) continue;
                    for (DigestAlgorithm digestAlgorithm : acceptableDigestAlgorithmsMap.keySet()) {
                        SignatureAlgorithm signatureAlgorithm2 = this.findSignatureAlgorithm(encryptionAlgorithm2, digestAlgorithm);
                        if (signatureAlgorithm2 == null) continue;
                        this.acceptableSignatureAlgorithms.computeIfAbsent(signatureAlgorithm2, v -> new HashSet());
                    }
                }
            }
            if ((algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
                SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDate);
                algos = algoExpirationDate.getAlgos();
                if (algos != null && !algos.isEmpty()) {
                    for (Algo algo : algos) {
                        encryptionAlgorithm = this.toEncryptionAlgorithm(algo.getValue());
                        if (encryptionAlgorithm == null) continue;
                        for (Map.Entry<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> entry : acceptableDigestAlgorithmsMap.entrySet()) {
                            signatureAlgorithm = this.findSignatureAlgorithm(encryptionAlgorithm, entry.getKey());
                            if (signatureAlgorithm == null || !this.acceptableSignatureAlgorithms.containsKey(signatureAlgorithm)) continue;
                            Date digestAlgoValidityEnd = this.getAlgorithmExpirationDate(entry.getValue());
                            CryptographicSuiteEvaluation evaluation = this.buildEvaluation(encryptionAlgorithm, algo, dateFormat, digestAlgoValidityEnd);
                            this.acceptableSignatureAlgorithms.computeIfAbsent(signatureAlgorithm, v -> new HashSet()).add(evaluation);
                        }
                    }
                }
            }
            if ((miniPublicKeySize = ((CryptographicConstraint)this.constraint).getMiniPublicKeySize()) != null && (algos = miniPublicKeySize.getAlgos()) != null && !algos.isEmpty()) {
                for (Algo algo : algos) {
                    encryptionAlgorithm = this.toEncryptionAlgorithm(algo.getValue());
                    if (encryptionAlgorithm == null) continue;
                    for (Map.Entry<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> entry : acceptableDigestAlgorithmsMap.entrySet()) {
                        signatureAlgorithm = this.findSignatureAlgorithm(encryptionAlgorithm, entry.getKey());
                        if (signatureAlgorithm == null || !this.acceptableSignatureAlgorithms.containsKey(signatureAlgorithm)) continue;
                        Set<CryptographicSuiteEvaluation> evaluations = this.acceptableSignatureAlgorithms.get(signatureAlgorithm);
                        Date digestAlgoValidityEnd = this.getAlgorithmExpirationDate(entry.getValue());
                        evaluations = this.getFloorEvaluations(evaluations, encryptionAlgorithm, algo, digestAlgoValidityEnd);
                        this.acceptableSignatureAlgorithms.put(signatureAlgorithm, evaluations);
                    }
                }
            }
            for (Map.Entry<SignatureAlgorithm, Set<CryptographicSuiteEvaluation>> entry : this.acceptableSignatureAlgorithms.entrySet()) {
                Set<CryptographicSuiteEvaluation> evaluationList = entry.getValue();
                if (!evaluationList.isEmpty()) continue;
                CryptographicSuiteEvaluation evaluation = new CryptographicSuiteEvaluation();
                Set<CryptographicSuiteEvaluation> digestAlgoEvaluations = acceptableDigestAlgorithmsMap.get(entry.getKey().getDigestAlgorithm());
                if (digestAlgoEvaluations != null && !digestAlgoEvaluations.isEmpty()) {
                    evaluation.setValidityEnd(this.getAlgorithmExpirationDate(digestAlgoEvaluations));
                }
                evaluationList.add(evaluation);
            }
        }
        return this.acceptableSignatureAlgorithms;
    }

    private Date getAlgorithmExpirationDate(Set<CryptographicSuiteEvaluation> evaluations) {
        if (evaluations == null || evaluations.isEmpty()) {
            return null;
        }
        Date expirationDate = null;
        for (CryptographicSuiteEvaluation evaluation : evaluations) {
            Date validityEnd = evaluation.getValidityEnd();
            if (validityEnd == null) {
                return null;
            }
            if (expirationDate != null && !expirationDate.before(validityEnd)) continue;
            expirationDate = validityEnd;
        }
        return expirationDate;
    }

    private Set<CryptographicSuiteEvaluation> getFloorEvaluations(Set<CryptographicSuiteEvaluation> existingEvaluations, EncryptionAlgorithm encryptionAlgorithm, Algo algo, Date forcedValidityEnd) {
        if (!existingEvaluations.isEmpty()) {
            Integer minSize = algo.getSize();
            for (CryptographicSuiteEvaluation evaluation : existingEvaluations) {
                for (CryptographicSuiteParameter parameter : evaluation.getParameterList()) {
                    if (minSize == null || parameter.getMin() != null && minSize <= parameter.getMin()) continue;
                    parameter.setMin(minSize);
                }
            }
        } else {
            CryptographicSuiteEvaluation evaluation = this.buildEvaluation(encryptionAlgorithm, algo, null, forcedValidityEnd);
            existingEvaluations.add(evaluation);
        }
        return existingEvaluations;
    }

    private CryptographicSuiteEvaluation buildEvaluation(Algo algo, SimpleDateFormat simpleDateFormat) {
        return this.buildEvaluation(null, algo, simpleDateFormat, null);
    }

    private CryptographicSuiteEvaluation buildEvaluation(EncryptionAlgorithm encryptionAlgorithm, Algo algo, SimpleDateFormat simpleDateFormat, Date forcedValidityEnd) {
        CryptographicSuiteEvaluation evaluation = new CryptographicSuiteEvaluation();
        evaluation.setParameterList(this.buildParameters(encryptionAlgorithm, algo));
        if (simpleDateFormat != null) {
            Date validityEnd = this.getDate(algo, simpleDateFormat);
            if (validityEnd == null || forcedValidityEnd != null && validityEnd.after(forcedValidityEnd)) {
                validityEnd = forcedValidityEnd;
            }
            evaluation.setValidityEnd(validityEnd);
        }
        evaluation.setAlgorithmUsage(this.buildUsages());
        return evaluation;
    }

    private List<CryptographicSuiteParameter> buildParameters(EncryptionAlgorithm encryptionAlgorithm, Algo algo) {
        ArrayList<CryptographicSuiteParameter> parameters = new ArrayList<CryptographicSuiteParameter>();
        if (algo.getSize() != null) {
            CryptographicSuiteParameter parameter = new CryptographicSuiteParameter();
            parameter.setName(this.getParameterName(encryptionAlgorithm));
            parameter.setMin(algo.getSize());
            parameters.add(parameter);
        }
        return parameters;
    }

    private String getParameterName(EncryptionAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm == null) {
            return null;
        }
        if (EncryptionAlgorithm.RSA.isEquivalent(encryptionAlgorithm)) {
            return MODULES_LENGTH_PARAMETER;
        }
        if (EncryptionAlgorithm.DSA.isEquivalent(encryptionAlgorithm) || EncryptionAlgorithm.ECDSA.isEquivalent(encryptionAlgorithm) || EncryptionAlgorithm.EDDSA.isEquivalent(encryptionAlgorithm)) {
            return PLENGTH_PARAMETER;
        }
        return null;
    }

    private List<CryptographicSuiteAlgorithmUsage> buildUsages() {
        return Collections.emptyList();
    }

    private DigestAlgorithm toDigestAlgorithm(String algorithmName) {
        try {
            return DigestAlgorithm.forName(algorithmName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private SimpleDateFormat getUsedDateFormat(AlgoExpirationDate expirations) {
        SimpleDateFormat sdf = new SimpleDateFormat(expirations.getFormat() != null ? expirations.getFormat() : DEFAULT_DATE_FORMAT);
        sdf.setTimeZone(UTC);
        return sdf;
    }

    private Date getDate(Algo algo, SimpleDateFormat format) {
        if (algo != null) {
            return this.getDate(algo.getDate(), format);
        }
        return null;
    }

    private Date getDate(String dateString, SimpleDateFormat format) {
        if (dateString != null) {
            try {
                return format.parse(dateString);
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse '{}' with format '{}'", (Object)dateString, (Object)format);
            }
        }
        return null;
    }

    private SignatureAlgorithm findSignatureAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm);
        if (signatureAlgorithm == null) {
            LOG.trace("Cannot find a SignatureAlgorithm for combination of {} with {}.", (Object)encryptionAlgorithm.getName(), (Object)digestAlgorithm.getName());
        }
        return signatureAlgorithm;
    }

    private EncryptionAlgorithm toEncryptionAlgorithm(String algorithmName) {
        try {
            return EncryptionAlgorithm.forName(algorithmName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void setLevel(Level level) {
        if (this.constraint != null) {
            this.constraint.setLevel(level);
        }
    }

    @Override
    public Level getAcceptableSignatureAlgorithmsLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getAcceptableEncryptionAlgo());
        }
        return null;
    }

    @Override
    public void setAcceptableSignatureAlgorithmsLevel(Level acceptableEncryptionAlgorithmsLevel) {
        ListAlgo acceptableEncryptionAlgo;
        if (this.constraint != null && (acceptableEncryptionAlgo = ((CryptographicConstraint)this.constraint).getAcceptableEncryptionAlgo()) != null) {
            acceptableEncryptionAlgo.setLevel(acceptableEncryptionAlgorithmsLevel);
        }
    }

    @Override
    public Level getAcceptableSignatureAlgorithmsMiniKeySizeLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getMiniPublicKeySize());
        }
        return null;
    }

    @Override
    public void setAcceptableSignatureAlgorithmsMiniKeySizeLevel(Level acceptableEncryptionAlgorithmsMiniKeySizeLevel) {
        ListAlgo miniPublicKeySize;
        if (this.constraint != null && (miniPublicKeySize = ((CryptographicConstraint)this.constraint).getMiniPublicKeySize()) != null) {
            miniPublicKeySize.setLevel(acceptableEncryptionAlgorithmsMiniKeySizeLevel);
        }
    }

    @Override
    public Level getAcceptableDigestAlgorithmsLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getAcceptableDigestAlgo());
        }
        return null;
    }

    @Override
    public void setAcceptableDigestAlgorithmsLevel(Level acceptableDigestAlgorithmsLevel) {
        ListAlgo acceptableDigestAlgo;
        if (this.constraint != null && (acceptableDigestAlgo = ((CryptographicConstraint)this.constraint).getAcceptableDigestAlgo()) != null) {
            acceptableDigestAlgo.setLevel(acceptableDigestAlgorithmsLevel);
        }
    }

    @Override
    public Level getAlgorithmsExpirationDateLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevel(((CryptographicConstraint)this.constraint).getAlgoExpirationDate());
        }
        return null;
    }

    @Override
    public void setAlgorithmsExpirationDateLevel(Level algorithmsExpirationDateLevel) {
        AlgoExpirationDate algoExpirationDate;
        if (this.constraint != null && (algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
            algoExpirationDate.setLevel(algorithmsExpirationDateLevel);
        }
    }

    @Override
    public Level getAlgorithmsExpirationDateAfterUpdateLevel() {
        if (this.constraint != null) {
            AlgoExpirationDate algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate();
            if (algoExpirationDate != null && algoExpirationDate.getLevelAfterUpdate() != null) {
                return algoExpirationDate.getLevelAfterUpdate();
            }
            return this.getCryptographicLevel(algoExpirationDate);
        }
        return null;
    }

    @Override
    public void setAlgorithmsExpirationTimeAfterPolicyUpdateLevel(Level algorithmsExpirationTimeAfterPolicyUpdateLevel) {
        AlgoExpirationDate algoExpirationDate;
        if (this.constraint != null && (algoExpirationDate = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
            algoExpirationDate.setLevelAfterUpdate(algorithmsExpirationTimeAfterPolicyUpdateLevel);
        }
    }

    @Override
    public Date getCryptographicSuiteUpdateDate() {
        AlgoExpirationDate algoExpirationDates;
        if (this.constraint != null && (algoExpirationDates = ((CryptographicConstraint)this.constraint).getAlgoExpirationDate()) != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            return this.getDate(algoExpirationDates.getUpdateDate(), dateFormat);
        }
        return null;
    }

    private Level getCryptographicLevel(LevelConstraint cryptoConstraint) {
        if (cryptoConstraint != null && cryptoConstraint.getLevel() != null) {
            return cryptoConstraint.getLevel();
        }
        return this.getLevel();
    }
}

