/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy.crypto.json;

import eu.europa.esig.dss.enumerations.CryptographicSuiteAlgorithmUsage;
import eu.europa.esig.dss.enumerations.CryptographicSuiteRecommendation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteAlgorithm;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteCatalogue;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteEvaluation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteMetadata;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteParameter;
import eu.europa.esig.json.JsonObjectWrapper;
import eu.europa.esig.json.RFC3339DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicSuiteJsonCatalogue
extends CryptographicSuiteCatalogue {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicSuiteJsonCatalogue.class);
    private static final String DEFAULT_VERSION = "1";
    private static final String DEFAULT_LANG = "en";
    private final JsonObjectWrapper securitySuitabilityPolicy;

    public CryptographicSuiteJsonCatalogue(JsonObjectWrapper securitySuitabilityPolicy) {
        Objects.requireNonNull(securitySuitabilityPolicy, "securitySuitabilityPolicy cannot be null!");
        this.securitySuitabilityPolicy = securitySuitabilityPolicy;
    }

    @Override
    protected CryptographicSuiteMetadata buildMetadata() {
        JsonObjectWrapper publisher;
        CryptographicSuiteMetadata metadata = new CryptographicSuiteMetadata();
        JsonObjectWrapper policyName = this.securitySuitabilityPolicy.getAsObject("PolicyName");
        if (policyName != null) {
            metadata.setPolicyName(policyName.getAsString("Name"));
            metadata.setPolicyOID(policyName.getAsString("ObjectIdentifier"));
            metadata.setPolicyURI(policyName.getAsString("URI"));
        }
        if ((publisher = this.securitySuitabilityPolicy.getAsObject("Publisher")) != null) {
            metadata.setPublisherName(publisher.getAsString("Name"));
            metadata.setPublisherAddress(publisher.getAsString("Address"));
            metadata.setPublisherURI(publisher.getAsString("URI"));
        }
        metadata.setPolicyIssueDate(this.getAsDateTime(this.securitySuitabilityPolicy, "PolicyIssueDate"));
        metadata.setNextUpdate(this.getAsDateTime(this.securitySuitabilityPolicy, "NextUpdate"));
        metadata.setUsage(this.securitySuitabilityPolicy.getAsString("Usage"));
        metadata.setVersion(this.getVersion());
        metadata.setLang(this.getLang());
        metadata.setId(this.securitySuitabilityPolicy.getAsString("id"));
        return metadata;
    }

    @Override
    protected List<CryptographicSuiteAlgorithm> buildAlgorithmList() {
        ArrayList<CryptographicSuiteAlgorithm> algorithmList = new ArrayList<CryptographicSuiteAlgorithm>();
        List<JsonObjectWrapper> algorithms = this.securitySuitabilityPolicy.getAsObjectList("Algorithm");
        for (JsonObjectWrapper algorithmType : algorithms) {
            CryptographicSuiteAlgorithm algorithm = this.buildAlgorithm(algorithmType);
            if (algorithm == null) continue;
            algorithmList.add(algorithm);
        }
        return algorithmList;
    }

    private CryptographicSuiteAlgorithm buildAlgorithm(JsonObjectWrapper algorithmType) {
        try {
            CryptographicSuiteAlgorithm algorithm = new CryptographicSuiteAlgorithm();
            JsonObjectWrapper algorithmIdentifier = algorithmType.getAsObject("AlgorithmIdentifier");
            if (algorithmIdentifier != null) {
                algorithm.setAlgorithmIdentifierName(algorithmIdentifier.getAsString("Name"));
                algorithm.setAlgorithmIdentifierOIDs(this.getAlgorithmIdentifierOIDs(algorithmIdentifier));
                algorithm.setAlgorithmIdentifierURIs(this.getAlgorithmIdentifierURIs(algorithmIdentifier));
            }
            algorithm.setEvaluationList(this.buildEvaluationList(algorithmType.getAsObjectList("Evaluation")));
            algorithm.setInformationTextList(this.getInformationText(algorithmType));
            return algorithm;
        }
        catch (Exception e) {
            String errorMessage = "An error occurred during processing of an algorithm JSON entry : {}. The entry is skipped.";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            } else {
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
            return null;
        }
    }

    private List<String> getAlgorithmIdentifierOIDs(JsonObjectWrapper algorithmIdentifier) {
        String algorithmOID = algorithmIdentifier.getAsString("ObjectIdentifier");
        if (algorithmOID != null) {
            return Collections.singletonList(algorithmOID);
        }
        return Collections.emptyList();
    }

    private List<String> getAlgorithmIdentifierURIs(JsonObjectWrapper algorithmIdentifier) {
        String algorithmURI = algorithmIdentifier.getAsString("URI");
        if (algorithmURI != null) {
            return Collections.singletonList(algorithmURI);
        }
        return Collections.emptyList();
    }

    private List<CryptographicSuiteEvaluation> buildEvaluationList(List<JsonObjectWrapper> evaluations) {
        ArrayList<CryptographicSuiteEvaluation> evaluationList = new ArrayList<CryptographicSuiteEvaluation>();
        for (JsonObjectWrapper evaluationType : evaluations) {
            evaluationList.add(this.buildEvaluation(evaluationType));
        }
        return evaluationList;
    }

    private List<String> getInformationText(JsonObjectWrapper algorithmType) {
        JsonObjectWrapper information = algorithmType.getAsObject("Information");
        if (information == null) {
            return Collections.emptyList();
        }
        return information.getAsStringList("Text");
    }

    private CryptographicSuiteEvaluation buildEvaluation(JsonObjectWrapper evaluationType) {
        CryptographicSuiteEvaluation evaluation = new CryptographicSuiteEvaluation();
        evaluation.setParameterList(this.buildParameterList(evaluationType.getAsObjectList("Parameter")));
        JsonObjectWrapper validity = evaluationType.getAsObject("Validity");
        if (validity != null) {
            evaluation.setValidityStart(this.getAsDate(validity, "Start"));
            evaluation.setValidityEnd(this.getAsDate(validity, "End"));
        }
        evaluation.setAlgorithmUsage(this.getAlgorithmUsage(evaluationType));
        evaluation.setRecommendation(this.getRecommendation(evaluationType));
        return evaluation;
    }

    private List<CryptographicSuiteParameter> buildParameterList(List<JsonObjectWrapper> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CryptographicSuiteParameter> parameterList = new ArrayList<CryptographicSuiteParameter>();
        for (JsonObjectWrapper parameterType : parameters) {
            parameterList.add(this.buildParameter(parameterType));
        }
        return parameterList;
    }

    private CryptographicSuiteParameter buildParameter(JsonObjectWrapper parameterType) {
        CryptographicSuiteParameter parameter = new CryptographicSuiteParameter();
        parameter.setName(parameterType.getAsString("name"));
        parameter.setMin(this.toInteger(parameterType.getAsNumber("Min")));
        parameter.setMax(this.toInteger(parameterType.getAsNumber("Max")));
        return parameter;
    }

    private List<CryptographicSuiteAlgorithmUsage> getAlgorithmUsage(JsonObjectWrapper evaluationType) {
        String algorithmUsageStr = evaluationType.getAsString("AlgorithmUsage");
        if (algorithmUsageStr == null) {
            return Collections.emptyList();
        }
        CryptographicSuiteAlgorithmUsage algorithmUsage = CryptographicSuiteAlgorithmUsage.fromUri(algorithmUsageStr);
        if (algorithmUsage == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(algorithmUsage);
    }

    private CryptographicSuiteRecommendation getRecommendation(JsonObjectWrapper evaluationType) {
        String recommendation = evaluationType.getAsString("Recommendation");
        if (recommendation == null) {
            return null;
        }
        return CryptographicSuiteRecommendation.fromValue(recommendation);
    }

    private String getVersion() {
        String version = this.securitySuitabilityPolicy.getAsString("version");
        if (version != null) {
            return version;
        }
        return DEFAULT_VERSION;
    }

    private String getLang() {
        String lang = this.securitySuitabilityPolicy.getAsString("lang");
        if (lang != null) {
            return lang;
        }
        return DEFAULT_LANG;
    }

    private Integer toInteger(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    private Date getAsDate(JsonObjectWrapper jsonObject, String name) {
        String dateString = jsonObject.getAsString(name);
        if (dateString == null) {
            return null;
        }
        return RFC3339DateUtils.getDate(dateString);
    }

    private Date getAsDateTime(JsonObjectWrapper jsonObject, String name) {
        String dateString = jsonObject.getAsString(name);
        if (dateString == null) {
            return null;
        }
        return RFC3339DateUtils.getDateTime(dateString);
    }
}

