/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.http;

import eu.europa.esig.dss.model.http.ResponseEnvelope;
import eu.europa.esig.dss.spi.client.http.MaxSizeInputStream;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;

public class NativeHTTPDataLoaderCall
implements Callable<ResponseEnvelope> {
    private static final String ERROR_MESSAGE = "An error occurred while reading from url '%s' : %s";
    private final String url;
    private final byte[] content;
    private boolean useCaches;
    private int maxInputSize;
    private int connectTimeout;
    private int readTimeout;
    private boolean includeResponseBody = true;
    private boolean includeResponseDetails;

    public NativeHTTPDataLoaderCall(String url) {
        this(url, null);
    }

    public NativeHTTPDataLoaderCall(String url, byte[] content) {
        this.url = url;
        this.content = content;
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    public void setMaxInputSize(int maxInputSize) {
        this.maxInputSize = maxInputSize;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setIncludeResponseBody(boolean includeResponseBody) {
        this.includeResponseBody = includeResponseBody;
    }

    public void setIncludeResponseDetails(boolean includeResponseDetails) {
        this.includeResponseDetails = includeResponseDetails;
    }

    @Override
    public ResponseEnvelope call() {
        ResponseEnvelope responseEnvelope;
        OutputStream os = null;
        InputStream is = null;
        try {
            ResponseEnvelope result = new ResponseEnvelope();
            URLConnection connection = this.createConnection();
            connection.setUseCaches(this.useCaches);
            if (this.connectTimeout > 0) {
                connection.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout > 0) {
                connection.setReadTimeout(this.readTimeout);
            }
            if (this.content != null) {
                connection.setDoOutput(true);
                os = connection.getOutputStream();
                Utils.write(this.content, os);
            }
            is = connection.getInputStream();
            if (this.includeResponseBody) {
                if (this.maxInputSize > 0) {
                    is = new MaxSizeInputStream(is, this.maxInputSize, this.url);
                }
                result.setResponseBody(Utils.toByteArray(is));
            }
            if (this.includeResponseDetails) {
                result.setHeaders(connection.getHeaderFields());
                if (connection instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    Certificate[] certificates = httpsConnection.getServerCertificates();
                    result.setTLSCertificates(certificates);
                }
            }
            responseEnvelope = result;
        }
        catch (IOException e) {
            try {
                throw new DSSExternalResourceException(String.format(ERROR_MESSAGE, this.url, e.getMessage()), e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(os);
                Utils.closeQuietly(is);
                throw throwable;
            }
        }
        Utils.closeQuietly(os);
        Utils.closeQuietly(is);
        return responseEnvelope;
    }

    protected URLConnection createConnection() throws IOException {
        return URI.create(this.url).toURL().openConnection();
    }
}

