/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.security;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import java.security.Provider;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DSSSecurityFactory<I, O> {
    private static final Logger LOG = LoggerFactory.getLogger(DSSSecurityFactory.class);

    protected DSSSecurityFactory() {
    }

    public O build(I input) {
        Objects.requireNonNull(input, "Input cannot be null");
        O output = this.buildWithPrimarySecurityProvider(input);
        if (output != null) {
            return output;
        }
        output = this.buildWithAlternativeSecurityProviders(input);
        if (output != null) {
            return output;
        }
        throw new DSSException(String.format("Unable to load %s for the given %s. All security providers have failed. More detail in debug mode.", this.getFactoryClassName(), input.getClass().getSimpleName()));
    }

    protected O buildWithPrimarySecurityProvider(I input) {
        try {
            return this.buildWithProvider(input, DSSSecurityProvider.getSecurityProvider());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to build {} using the default security provider. {}. Input: {}", this.getFactoryClassName(), e.getMessage(), this.toString(input), e);
            } else {
                LOG.warn("Unable to build {} using the default security provider. {}.", (Object)this.getFactoryClassName(), (Object)e.getMessage());
            }
            return null;
        }
    }

    protected O buildWithAlternativeSecurityProviders(I input) {
        for (Provider provider : DSSSecurityProvider.getAlternativeSecurityProviders()) {
            try {
                O result = this.buildWithProvider(input, provider);
                if (result == null) continue;
                LOG.info("{} has been successfully built using the alternative security provider '{}'. More detail in debug mode.", (Object)this.getFactoryClassName(), (Object)provider.getName());
                return result;
            }
            catch (Exception e) {
                String errorMessage = "Unable to build {} using the alternative security provider '{}'. {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, this.getFactoryClassName(), provider.getName(), e.getMessage(), e);
                    continue;
                }
                LOG.warn(errorMessage, this.getFactoryClassName(), provider.getName(), e.getMessage());
            }
        }
        return null;
    }

    protected abstract String getFactoryClassName();

    protected abstract String toString(I var1);

    protected abstract O buildWithProvider(I var1, Provider var2) throws Exception;
}

