/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.security;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.security.DSSSecurityFactory;
import eu.europa.esig.dss.utils.Utils;
import java.security.Provider;
import java.security.PublicKey;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;

public abstract class DSSSignerInformationVerifierSecurityFactory<I>
extends DSSSecurityFactory<I, SignerInformationVerifier> {
    public static final DSSSignerInformationVerifierSecurityFactory<CertificateToken> CERTIFICATE_TOKEN_INSTANCE = new DSSSignerInformationVerifierSecurityFactory<CertificateToken>(){

        @Override
        protected String toString(CertificateToken input) {
            return input != null ? Utils.toBase64(input.getEncoded()) : null;
        }

        @Override
        protected SignerInformationVerifier buildWithProvider(CertificateToken input, Provider securityProvider) throws OperatorCreationException {
            JcaSimpleSignerInfoVerifierBuilder jcaSimpleSignerInfoVerifierBuilder = new JcaSimpleSignerInfoVerifierBuilder();
            jcaSimpleSignerInfoVerifierBuilder.setProvider(securityProvider);
            return jcaSimpleSignerInfoVerifierBuilder.build(input.getCertificate());
        }
    };
    public static final DSSSignerInformationVerifierSecurityFactory<PublicKey> PUBLIC_TOKEN_INSTANCE = new DSSSignerInformationVerifierSecurityFactory<PublicKey>(){

        @Override
        protected String toString(PublicKey input) {
            return String.format("PublicKey with algorithm '%s'", input != null ? input.getAlgorithm() : null);
        }

        @Override
        protected SignerInformationVerifier buildWithProvider(PublicKey input, Provider securityProvider) throws OperatorCreationException {
            JcaSimpleSignerInfoVerifierBuilder jcaSimpleSignerInfoVerifierBuilder = new JcaSimpleSignerInfoVerifierBuilder();
            jcaSimpleSignerInfoVerifierBuilder.setProvider(securityProvider);
            return jcaSimpleSignerInfoVerifierBuilder.build(input);
        }
    };

    private DSSSignerInformationVerifierSecurityFactory() {
    }

    @Override
    protected String getFactoryClassName() {
        return SignerInformationVerifier.class.getSimpleName();
    }
}

