/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.scope;

import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.DataIdentifier;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import java.util.Objects;

public class SignatureSignatureScope
extends SignatureScope {
    private final AdvancedSignature signature;

    public SignatureSignatureScope(AdvancedSignature signature, DSSDocument document) {
        super(signature.getId(), document);
        Objects.requireNonNull(signature, "Signature shall be provided!");
        this.signature = signature;
    }

    @Override
    public DataIdentifier getDSSId() {
        return super.getDSSId();
    }

    @Override
    public String getName(TokenIdentifierProvider tokenIdentifierProvider) {
        return this.getSignatureId(tokenIdentifierProvider);
    }

    @Override
    public String getDescription(TokenIdentifierProvider tokenIdentifierProvider) {
        return String.format("Signature with Id : %s", this.getSignatureId(tokenIdentifierProvider));
    }

    private String getSignatureId(TokenIdentifierProvider tokenIdentifierProvider) {
        return tokenIdentifierProvider.getIdAsString(this.signature);
    }

    @Override
    public SignatureScopeType getType() {
        return SignatureScopeType.SIGNATURE;
    }
}

