/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.utils;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.File;
import java.util.Collection;

public final class StandaloneAppUtils {
    private StandaloneAppUtils() {
    }

    public static CertificateToken toCertificateToken(File certificateFile) {
        if (certificateFile != null) {
            byte[] certificateBytes = DSSUtils.toByteArray(certificateFile);
            String certificateBytesString = new String(certificateBytes);
            if (!StandaloneAppUtils.isPem(certificateBytes) && Utils.isBase64Encoded(certificateBytesString)) {
                return DSSUtils.loadCertificateFromBase64EncodedString(certificateBytesString);
            }
            return DSSUtils.loadCertificate(certificateBytes);
        }
        return null;
    }

    private static boolean isPem(byte[] string) {
        return Utils.startsWith(string, "-----".getBytes());
    }

    public static CertificateSource toCertificateSource(Collection<File> certificateFiles) {
        CommonCertificateSource certSource = null;
        if (Utils.isCollectionNotEmpty(certificateFiles)) {
            certSource = new CommonCertificateSource();
            for (File file : certificateFiles) {
                CertificateToken certificateChainItem = StandaloneAppUtils.toCertificateToken(file);
                if (certificateChainItem == null) continue;
                certSource.addCertificate(certificateChainItem);
            }
        }
        return certSource;
    }
}

