/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.condition;

import eu.europa.esig.dss.model.tsl.Condition;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.extension.QcStatements;
import eu.europa.esig.dss.spi.QcStatementUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.Objects;

public class QCStatementCondition
implements Condition {
    private static final long serialVersionUID = -446434899721093605L;
    private final String oid;
    private final String type;
    private final String legislation;

    public QCStatementCondition(String oid, String type, String legislation) {
        this.oid = oid;
        this.type = type;
        this.legislation = legislation;
    }

    public String getOid() {
        return this.oid;
    }

    public String getType() {
        return this.type;
    }

    public String getLegislation() {
        return this.legislation;
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        QcStatements qcStatements = QcStatementUtils.getQcStatements(certificateToken);
        if (qcStatements != null) {
            if (Utils.isStringNotEmpty(this.oid) && !QcStatementUtils.isQcStatementPresent(qcStatements, this.oid)) {
                return false;
            }
            if (Utils.isStringNotEmpty(this.type) && !QcStatementUtils.isQcTypePresent(qcStatements, this.type)) {
                return false;
            }
            return !Utils.isStringNotEmpty(this.legislation) || QcStatementUtils.isQcLegislationPresent(qcStatements, this.legislation);
        }
        return false;
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("QCStatementCondition: ").append('\n');
        builder.append(indent).append("oid: ").append(this.oid).append('\n');
        builder.append(indent).append("type: ").append(this.type).append('\n');
        builder.append(indent).append("legislation: ").append(this.legislation).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QCStatementCondition that = (QCStatementCondition)object;
        return Objects.equals(this.oid, that.oid) && Objects.equals(this.type, that.type) && Objects.equals(this.legislation, that.legislation);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.oid);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.legislation);
        return result;
    }
}

