/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.timedependent.MutableTimeDependentValues;
import eu.europa.esig.dss.model.tsl.CertificateContentEquivalence;
import eu.europa.esig.dss.model.tsl.Condition;
import eu.europa.esig.dss.model.tsl.QCStatementOids;
import eu.europa.esig.dss.model.tsl.ServiceEquivalence;
import eu.europa.esig.dss.model.tsl.ServiceTypeASi;
import eu.europa.esig.dss.tsl.dto.condition.CompositeCondition;
import eu.europa.esig.dss.tsl.dto.condition.QCStatementCondition;
import eu.europa.esig.dss.tsl.function.converter.CriteriaListConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.ecc.CriteriaListType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualifierType;
import eu.europa.esig.trustedlist.jaxb.mra.CertificateContentReferenceEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.CertificateContentReferencesEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.QualifierEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.QualifierEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceHistoryInstanceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceHistoryType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceInformationType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLQualificationExtensionEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusEquivalenceType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLStatusList;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeEquivalenceListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeListType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceTSLTypeType;
import eu.europa.esig.trustedlist.jaxb.tsl.AdditionalServiceInformationType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustServiceEquivalenceConverter
implements Function<TrustServiceEquivalenceInformationType, MutableTimeDependentValues<ServiceEquivalence>> {
    private static final Logger LOG = LoggerFactory.getLogger(TrustServiceEquivalenceConverter.class);
    private final CriteriaListConverter criteriaConverter = new CriteriaListConverter();

    @Override
    public MutableTimeDependentValues<ServiceEquivalence> apply(TrustServiceEquivalenceInformationType t) {
        MutableTimeDependentValues<ServiceEquivalence> result = new MutableTimeDependentValues<ServiceEquivalence>();
        ServiceEquivalence serviceEquivalence = new ServiceEquivalence.ServiceEquivalenceBuilder().setLegalInfoIdentifier(t.getTrustServiceLegalIdentifier()).setStartDate(t.getTrustServiceEquivalenceStatusStartingTime().toGregorianCalendar().getTime()).setStatus(t.getTrustServiceEquivalenceStatus()).setTypeAsiEquivalence(this.getTypeASiEquivalence(t.getTrustServiceTSLTypeEquivalenceList())).setStatusEquivalence(this.getStatusEquivalence(t.getTrustServiceTSLStatusEquivalenceList())).setCertificateContentEquivalences(this.getCertificateEquivalence(t.getCertificateContentReferencesEquivalenceList())).setQualifierEquivalence(this.getQualifierEquivalence(t.getTrustServiceTSLQualificationExtensionEquivalenceList())).build();
        result.addOldest(serviceEquivalence);
        Date oldestStartDate = serviceEquivalence.getStartDate();
        for (TrustServiceEquivalenceHistoryType trustServiceEquivalenceHistory : t.getTrustServiceEquivalenceHistory()) {
            for (TrustServiceEquivalenceHistoryInstanceType h : trustServiceEquivalenceHistory.getTrustServiceEquivalenceHistoryInstance()) {
                ServiceEquivalence historyServiceEquivalence = new ServiceEquivalence.ServiceEquivalenceBuilder().setLegalInfoIdentifier(serviceEquivalence.getLegalInfoIdentifier()).setStartDate(h.getTrustServiceEquivalenceStatusStartingTime().toGregorianCalendar().getTime()).setEndDate(oldestStartDate).setStatus(h.getTrustServiceEquivalenceStatus()).setTypeAsiEquivalence(this.getTypeASiEquivalence(h.getTrustServiceTSLTypeEquivalenceList())).setStatusEquivalence(this.getStatusEquivalence(h.getTrustServiceTSLStatusEquivalenceList())).setCertificateContentEquivalences(this.getCertificateEquivalence(h.getCertificateContentReferencesEquivalenceList())).setQualifierEquivalence(this.getQualifierEquivalence(h.getTrustServiceTSLQualificationExtensionEquivalenceList())).build();
                result.addOldest(historyServiceEquivalence);
                oldestStartDate = historyServiceEquivalence.getStartDate();
            }
        }
        return result;
    }

    private Map<ServiceTypeASi, ServiceTypeASi> getTypeASiEquivalence(TrustServiceTSLTypeEquivalenceListType serviceTSLTypeEquivalenceList) {
        HashMap<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence = new HashMap<ServiceTypeASi, ServiceTypeASi>();
        if (serviceTSLTypeEquivalenceList != null) {
            TrustServiceTSLTypeListType expected = serviceTSLTypeEquivalenceList.getTrustServiceTSLTypeListPointedParty();
            TrustServiceTSLTypeListType substitute = serviceTSLTypeEquivalenceList.getTrustServiceTSLTypeListPointingParty();
            List<TrustServiceTSLTypeType> expectedServiceTSLTypes = expected.getTrustServiceTSLType();
            List<TrustServiceTSLTypeType> substituteServiceTSLTypes = substitute.getTrustServiceTSLType();
            for (TrustServiceTSLTypeType expectedTypeASI : expectedServiceTSLTypes) {
                ServiceTypeASi staExpected = this.getServiceTypeASi(expectedTypeASI);
                for (TrustServiceTSLTypeType substituteTypeASI : substituteServiceTSLTypes) {
                    ServiceTypeASi staSubstitute = this.getServiceTypeASi(substituteTypeASI);
                    typeAsiEquivalence.put(staExpected, staSubstitute);
                }
            }
        }
        return typeAsiEquivalence;
    }

    private ServiceTypeASi getServiceTypeASi(TrustServiceTSLTypeType expectedTypeASI) {
        ServiceTypeASi sta = new ServiceTypeASi();
        sta.setType(expectedTypeASI.getServiceTypeIdentifier());
        AdditionalServiceInformationType additionalServiceInformation = expectedTypeASI.getAdditionalServiceInformation();
        if (additionalServiceInformation != null && additionalServiceInformation.getURI() != null) {
            sta.setAsi(additionalServiceInformation.getURI().getValue());
        }
        return sta;
    }

    private Map<List<String>, List<String>> getStatusEquivalence(TrustServiceTSLStatusEquivalenceListType serviceTSLStatusEquivalenceList) {
        HashMap<List<String>, List<String>> statusEquivalenceMap = new HashMap<List<String>, List<String>>();
        TrustServiceTSLStatusEquivalenceType validEquivalences = serviceTSLStatusEquivalenceList.getTrustServiceTSLStatusValidEquivalence();
        this.extractEquivalences(validEquivalences, statusEquivalenceMap);
        TrustServiceTSLStatusEquivalenceType invalidEquivalences = serviceTSLStatusEquivalenceList.getTrustServiceTSLStatusInvalidEquivalence();
        this.extractEquivalences(invalidEquivalences, statusEquivalenceMap);
        return statusEquivalenceMap;
    }

    private void extractEquivalences(TrustServiceTSLStatusEquivalenceType statusEquivalence, Map<List<String>, List<String>> statusEquivalenceMap) {
        if (statusEquivalence != null) {
            TrustServiceTSLStatusList serviceTSLStatusListExpected = statusEquivalence.getTrustServiceTSLStatusListPointedParty();
            List<String> expected = serviceTSLStatusListExpected.getServiceStatus();
            TrustServiceTSLStatusList serviceTSLStatusListSubstitute = statusEquivalence.getTrustServiceTSLStatusListPointingParty();
            List<String> substitute = serviceTSLStatusListSubstitute.getServiceStatus();
            statusEquivalenceMap.put(expected, substitute);
        }
    }

    private List<CertificateContentEquivalence> getCertificateEquivalence(CertificateContentReferencesEquivalenceListType certificateContentEquivalenceList) {
        ArrayList<CertificateContentEquivalence> certificateContentEquivalences = new ArrayList<CertificateContentEquivalence>();
        if (certificateContentEquivalenceList != null && Utils.isCollectionNotEmpty(certificateContentEquivalenceList.getCertificateContentReferenceEquivalence())) {
            for (CertificateContentReferenceEquivalenceType certEquiv : certificateContentEquivalenceList.getCertificateContentReferenceEquivalence()) {
                CriteriaListType expected = certEquiv.getCertificateContentDeclarationPointedParty();
                CriteriaListType substitute = certEquiv.getCertificateContentDeclarationPointingParty();
                Condition condition = this.criteriaConverter.apply(substitute);
                CertificateContentEquivalence equiv = new CertificateContentEquivalence();
                equiv.setContext(certEquiv.getCertificateContentReferenceEquivalenceContext());
                equiv.setCondition(this.criteriaConverter.apply(expected));
                equiv.setContentReplacement(this.getQCStatementOids(condition));
                certificateContentEquivalences.add(equiv);
            }
        }
        return certificateContentEquivalences;
    }

    private QCStatementOids getQCStatementOids(Condition condition) {
        QCStatementOids result = new QCStatementOids();
        ArrayList<String> qcStatementIds = new ArrayList<String>();
        ArrayList<String> qcTypeIds = new ArrayList<String>();
        ArrayList<String> qcCClegislations = new ArrayList<String>();
        ArrayList<String> qcStatementIdsToRemove = new ArrayList<String>();
        ArrayList<String> qcTypeIdsToRemove = new ArrayList<String>();
        ArrayList<String> qcCClegislationsToRemove = new ArrayList<String>();
        if (condition instanceof CompositeCondition) {
            CompositeCondition composite = (CompositeCondition)condition;
            switch (composite.getMatchingCriteriaIndicator()) {
                case ALL: {
                    for (Condition condition2 : composite.getChildren()) {
                        this.populateFromChild(condition2, qcStatementIds, qcTypeIds, qcCClegislations, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove);
                    }
                    break;
                }
                case AT_LEAST_ONE: {
                    if (composite.getChildren().size() > 1) {
                        LOG.info("First equivalence condition is used out of '{}'!", (Object)composite.getChildren().size());
                    }
                    Condition firstCondition = composite.getChildren().get(0);
                    this.populateFromChild(firstCondition, qcStatementIds, qcTypeIds, qcCClegislations, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove);
                    break;
                }
                case NONE: {
                    for (Condition childCondition : composite.getChildren()) {
                        this.populateFromChild(childCondition, qcStatementIdsToRemove, qcTypeIdsToRemove, qcCClegislationsToRemove, qcStatementIds, qcTypeIds, qcCClegislations);
                    }
                    break;
                }
                default: {
                    LOG.warn("Unsupported assert {}", (Object)composite.getMatchingCriteriaIndicator());
                }
            }
        }
        if (condition instanceof QCStatementCondition) {
            String legislation;
            String string;
            QCStatementCondition qcCondition = (QCStatementCondition)condition;
            String oid = qcCondition.getOid();
            if (Utils.isStringNotEmpty(oid)) {
                qcStatementIds.add(oid);
            }
            if (Utils.isStringNotEmpty(string = qcCondition.getType())) {
                qcTypeIds.add(string);
            }
            if (Utils.isStringNotEmpty(legislation = qcCondition.getLegislation())) {
                qcCClegislations.add(legislation);
            }
        }
        result.setQcStatementIds(qcStatementIds);
        result.setQcTypeIds(qcTypeIds);
        result.setQcCClegislations(qcCClegislations);
        result.setQcStatementIdsToRemove(qcStatementIdsToRemove);
        result.setQcTypeIdsToRemove(qcTypeIdsToRemove);
        result.setQcCClegislationsToRemove(qcCClegislationsToRemove);
        return result;
    }

    private void populateFromChild(Condition condition, List<String> qcStatementIds, List<String> qcTypeIds, List<String> qcCClegislations, List<String> qcStatementIdsToRemove, List<String> qcTypeIdsToRemove, List<String> qcCClegislationsToRemove) {
        QCStatementOids conditionResult = this.getQCStatementOids(condition);
        for (String conditionQCStatementId : conditionResult.getQcStatementIds()) {
            if (qcStatementIds.contains(conditionQCStatementId)) continue;
            qcStatementIds.add(conditionQCStatementId);
        }
        for (String conditionQCTypeId : conditionResult.getQcTypeIds()) {
            if (qcTypeIds.contains(conditionQCTypeId)) continue;
            qcTypeIds.add(conditionQCTypeId);
        }
        for (String conditionQcCClegislation : conditionResult.getQcCClegislations()) {
            if (qcCClegislations.contains(conditionQcCClegislation)) continue;
            qcCClegislations.add(conditionQcCClegislation);
        }
        for (String childQCStatementId : conditionResult.getQcStatementIdsToRemove()) {
            if (qcStatementIdsToRemove.contains(childQCStatementId)) continue;
            qcStatementIdsToRemove.add(childQCStatementId);
        }
        for (String childQCTypeId : conditionResult.getQcTypeIdsToRemove()) {
            if (qcTypeIdsToRemove.contains(childQCTypeId)) continue;
            qcTypeIdsToRemove.add(childQCTypeId);
        }
        for (String childQcCClegislation : conditionResult.getQcCClegislationsToRemove()) {
            if (qcCClegislationsToRemove.contains(childQcCClegislation)) continue;
            qcCClegislationsToRemove.add(childQcCClegislation);
        }
    }

    private Map<String, String> getQualifierEquivalence(TrustServiceTSLQualificationExtensionEquivalenceListType qualificationExtensionEquivalenceListType) {
        HashMap<String, String> qualifierEquivalenceMap = new HashMap<String, String>();
        if (qualificationExtensionEquivalenceListType != null && Utils.isCollectionNotEmpty(qualificationExtensionEquivalenceListType.getQualifierEquivalenceList())) {
            for (QualifierEquivalenceListType qualifierEquivalenceList : qualificationExtensionEquivalenceListType.getQualifierEquivalenceList()) {
                List<QualifierEquivalenceType> qualifierEquivalence = qualifierEquivalenceList.getQualifierEquivalence();
                for (QualifierEquivalenceType qualifierEquivalenceType : qualifierEquivalence) {
                    QualifierType qualifierExpected = qualifierEquivalenceType.getQualifierPointedParty();
                    QualifierType qualifierSubstitute = qualifierEquivalenceType.getQualifierPointingParty();
                    qualifierEquivalenceMap.put(qualifierExpected.getUri(), qualifierSubstitute.getUri());
                }
            }
        }
        return qualifierEquivalenceMap;
    }
}

