/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.policy.SignaturePolicyProvider;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidatorLoader;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;
import eu.europa.esig.dss.validation.executor.DocumentProcessExecutor;
import eu.europa.esig.dss.validation.executor.signature.DefaultSignatureProcessExecutor;
import eu.europa.esig.dss.validation.policy.ValidationPolicyLoader;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.reports.diagnostic.SignedDocumentDiagnosticDataBuilder;
import eu.europa.esig.dss.validation.reports.diagnostic.XmlDiagnosticDataFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignedDocumentValidator
implements DocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDocumentValidator.class);
    protected final DocumentAnalyzer documentAnalyzer;
    protected DocumentProcessExecutor processExecutor = null;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private boolean includeSemantics = false;
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private Locale locale = Locale.getDefault();
    private boolean enableEtsiValidationReport = true;

    protected SignedDocumentValidator(DocumentAnalyzer documentAnalyzer) {
        Objects.requireNonNull(documentAnalyzer, "DocumentAnalyzer cannot be null!");
        this.documentAnalyzer = documentAnalyzer;
    }

    public static SignedDocumentValidator fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<DocumentValidatorFactory> serviceLoaders = ServiceLoader.load(DocumentValidatorFactory.class);
        for (DocumentValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return this.documentAnalyzer.isSupported(dssDocument);
    }

    public DocumentAnalyzer getDocumentAnalyzer() {
        return this.documentAnalyzer;
    }

    @Override
    public void setSigningCertificateSource(CertificateSource signingCertificateSource) {
        this.documentAnalyzer.setSigningCertificateSource(signingCertificateSource);
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.documentAnalyzer.setCertificateVerifier(certificateVerifier);
    }

    @Override
    public void setValidationContextExecutor(ValidationContextExecutor validationContextExecutor) {
        this.documentAnalyzer.setValidationContextExecutor(validationContextExecutor);
    }

    @Override
    public void setTokenIdentifierProvider(TokenIdentifierProvider tokenIdentifierProvider) {
        this.documentAnalyzer.setTokenIdentifierProvider(tokenIdentifierProvider);
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.documentAnalyzer.setDetachedContents(detachedContents);
    }

    @Override
    public void setDetachedEvidenceRecordDocuments(List<DSSDocument> detachedEvidenceRecordDocuments) {
        this.documentAnalyzer.setDetachedEvidenceRecordDocuments(detachedEvidenceRecordDocuments);
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.documentAnalyzer.setContainerContents(containerContents);
    }

    @Override
    public void setManifestFile(ManifestFile manifestFile) {
        this.documentAnalyzer.setManifestFile(manifestFile);
    }

    @Override
    public void setValidationTime(Date validationTime) {
        this.documentAnalyzer.setValidationTime(validationTime);
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.documentAnalyzer.setSignaturePolicyProvider(signaturePolicyProvider);
    }

    @Override
    public void setSignaturePolicyValidatorLoader(SignaturePolicyValidatorLoader signaturePolicyValidatorLoader) {
        this.documentAnalyzer.setSignaturePolicyValidatorLoader(signaturePolicyValidatorLoader);
    }

    @Override
    public void setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "Default DigestAlgorithm cannot be nulL!");
        this.defaultDigestAlgorithm = digestAlgorithm;
    }

    @Override
    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        Objects.requireNonNull(tokenExtractionStrategy);
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    @Override
    public void setIncludeSemantics(boolean include) {
        this.includeSemantics = include;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public void setProcessExecutor(DocumentProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    protected DocumentProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public DocumentProcessExecutor getDefaultProcessExecutor() {
        return new DefaultSignatureProcessExecutor();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Reports validateDocument() {
        return this.validateDocument((DSSDocument)null);
    }

    @Override
    public Reports validateDocument(URL validationPolicyURL) {
        return this.validateDocument(validationPolicyURL, null);
    }

    @Override
    public Reports validateDocument(String policyResourcePath) {
        return this.validateDocument(policyResourcePath, null);
    }

    @Override
    public Reports validateDocument(File policyFile) {
        return this.validateDocument(policyFile, null);
    }

    @Override
    public Reports validateDocument(DSSDocument policyDocument) {
        return this.validateDocument(policyDocument, null);
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream) {
        return this.validateDocument(policyDataStream, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Reports validateDocument(URL validationPolicyURL, URL cryptographicSuiteURL) {
        try (InputStream validationPolicyIS = validationPolicyURL != null ? validationPolicyURL.openStream() : null;){
            Reports reports;
            block14: {
                InputStream cryptographicSuiteIS = cryptographicSuiteURL != null ? cryptographicSuiteURL.openStream() : null;
                try {
                    reports = this.validateDocument(validationPolicyIS, cryptographicSuiteIS);
                    if (cryptographicSuiteIS == null) break block14;
                }
                catch (Throwable throwable) {
                    if (cryptographicSuiteIS != null) {
                        try {
                            cryptographicSuiteIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cryptographicSuiteIS.close();
            }
            return reports;
        }
        catch (IOException e) {
            throw new IllegalInputException(String.format("Unable to load policy with URL '%s' and cryptographic suite '%s'. Reason : %s", validationPolicyURL, cryptographicSuiteURL, e.getMessage()), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Reports validateDocument(String policyResourcePath, String cryptographicSuitePath) {
        try (InputStream validationPolicyIS = Utils.isStringNotEmpty(policyResourcePath) ? this.getClass().getResourceAsStream(policyResourcePath) : null;){
            Reports reports;
            block14: {
                InputStream cryptographicSuiteIS = Utils.isStringNotEmpty(cryptographicSuitePath) ? this.getClass().getResourceAsStream(cryptographicSuitePath) : null;
                try {
                    reports = this.validateDocument(validationPolicyIS, cryptographicSuiteIS);
                    if (cryptographicSuiteIS == null) break block14;
                }
                catch (Throwable throwable) {
                    if (cryptographicSuiteIS != null) {
                        try {
                            cryptographicSuiteIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cryptographicSuiteIS.close();
            }
            return reports;
        }
        catch (IOException e) {
            throw new IllegalInputException(String.format("Unable to load policy with URL '%s' and cryptographic suite '%s'. Reason : %s", policyResourcePath, cryptographicSuitePath, e.getMessage()), e);
        }
    }

    @Override
    public Reports validateDocument(File policyFile, File cryptographicSuiteFile) {
        FileDocument policyDocument = policyFile != null && policyFile.exists() ? new FileDocument(policyFile) : null;
        FileDocument cryptographicSuiteDocument = cryptographicSuiteFile != null && cryptographicSuiteFile.exists() ? new FileDocument(cryptographicSuiteFile) : null;
        return this.validateDocument(policyDocument, cryptographicSuiteDocument);
    }

    @Override
    public Reports validateDocument(DSSDocument policyDocument, DSSDocument cryptographicSuiteDocument) {
        ValidationPolicy validationPolicy = this.loadValidationPolicy(policyDocument, cryptographicSuiteDocument);
        return this.validateDocument(validationPolicy);
    }

    protected ValidationPolicy loadValidationPolicy(DSSDocument policyDocument, DSSDocument cryptographicSuiteDocument) {
        try {
            ValidationPolicyLoader validationPolicyLoader;
            if (policyDocument == null) {
                LOG.debug("No provided validation policy : use the default policy");
                validationPolicyLoader = ValidationPolicyLoader.fromDefaultValidationPolicy();
            } else {
                validationPolicyLoader = ValidationPolicyLoader.fromValidationPolicy(policyDocument);
            }
            if (cryptographicSuiteDocument != null) {
                validationPolicyLoader = validationPolicyLoader.withCryptographicSuite(cryptographicSuiteDocument);
            }
            return validationPolicyLoader.create();
        }
        catch (Exception e) {
            throw new IllegalInputException("Unable to load the policy", e);
        }
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream, InputStream cryptographicSuiteStream) {
        InMemoryDocument policyDocument = policyDataStream != null ? new InMemoryDocument(policyDataStream) : null;
        InMemoryDocument cryptographicSuiteDocument = cryptographicSuiteStream != null ? new InMemoryDocument(cryptographicSuiteStream) : null;
        return this.validateDocument(policyDocument, cryptographicSuiteDocument);
    }

    @Override
    public Reports validateDocument(ValidationPolicy validationPolicy) {
        LOG.info("Document validation...");
        this.assertConfigurationValid();
        XmlDiagnosticData diagnosticData = this.getDiagnosticData();
        return this.processValidationPolicy(diagnosticData, validationPolicy);
    }

    protected void assertConfigurationValid() {
        if (ValidationLevel.BASIC_SIGNATURES == this.validationLevel && (Utils.isCollectionNotEmpty(this.documentAnalyzer.getDetachedTimestamps()) || Utils.isCollectionNotEmpty(this.documentAnalyzer.getDetachedEvidenceRecords())) && Utils.isCollectionEmpty(this.documentAnalyzer.getSignatures())) {
            throw new IllegalArgumentException("Basic Signatures validation cannot be used for timestamp or evidence record documents!");
        }
    }

    public final XmlDiagnosticData getDiagnosticData() {
        ValidationContext validationContext = this.documentAnalyzer.validate();
        SignedDocumentDiagnosticDataBuilder diagnosticDataBuilder = this.initializeDiagnosticDataBuilder();
        return new XmlDiagnosticDataFactory(diagnosticDataBuilder).setDocument(this.documentAnalyzer.getDocument()).setValidationTime(this.documentAnalyzer.getValidationTime()).setTokenIdentifierProvider(this.documentAnalyzer.getTokenIdentifierProvider()).setValidationContext(validationContext).setDefaultDigestAlgorithm(this.defaultDigestAlgorithm).setTokenExtractionStrategy(this.tokenExtractionStrategy).create();
    }

    public SignedDocumentDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new SignedDocumentDiagnosticDataBuilder();
    }

    protected final Reports processValidationPolicy(XmlDiagnosticData diagnosticData, ValidationPolicy validationPolicy) {
        DocumentProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setCurrentTime(this.documentAnalyzer.getValidationTime());
        executor.setValidationPolicy(validationPolicy);
        executor.setValidationLevel(this.validationLevel);
        executor.setDiagnosticData(diagnosticData);
        executor.setIncludeSemantics(this.includeSemantics);
        executor.setEnableEtsiValidationReport(this.enableEtsiValidationReport);
        executor.setLocale(this.locale);
        return (Reports)executor.execute();
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        return this.documentAnalyzer.getSignatures();
    }

    public AdvancedSignature getSignatureById(String signatureId) {
        if (this.documentAnalyzer instanceof DefaultDocumentAnalyzer) {
            return ((DefaultDocumentAnalyzer)this.documentAnalyzer).getSignatureById(signatureId);
        }
        throw new IllegalStateException("The documentAnalyzer shall be an instance of DefaultDocumentAnalyzer to execute the method!");
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        return this.documentAnalyzer.getDetachedTimestamps();
    }

    @Override
    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        return this.documentAnalyzer.getDetachedEvidenceRecords();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        return this.documentAnalyzer.getOriginalDocuments(signatureId);
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        return this.documentAnalyzer.getOriginalDocuments(advancedSignature);
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures) {
        return this.documentAnalyzer.getValidationData(signatures);
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        return this.documentAnalyzer.getValidationData(signatures, detachedTimestamps);
    }
}

