/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.model.policy.ValidationPolicyFactory;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteCatalogue;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteFactory;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.ContextAndSubContext;
import eu.europa.esig.dss.validation.policy.ValidationPolicyWithCryptographicSuite;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public class ValidationPolicyLoader {
    private final ValidationPolicy validationPolicy;
    private final Map<CryptographicSuite, List<ContextAndSubContext>> cryptographicSuitesMap = new LinkedHashMap<CryptographicSuite, List<ContextAndSubContext>>();

    protected ValidationPolicyLoader() {
        this(null);
    }

    protected ValidationPolicyLoader(ValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    public static ValidationPolicyLoader fromDefaultValidationPolicy() {
        return ValidationPolicyLoader.fromValidationPolicy(ValidationPolicyLoader.loadDefaultPolicy());
    }

    public static ValidationPolicyLoader fromValidationPolicy(DSSDocument validationPolicy) {
        Objects.requireNonNull(validationPolicy, "Validation policy document cannot be null!");
        return ValidationPolicyLoader.fromValidationPolicy(ValidationPolicyLoader.loadPolicy(validationPolicy));
    }

    public static ValidationPolicyLoader fromValidationPolicy(InputStream validationPolicyStream) {
        Objects.requireNonNull(validationPolicyStream, "Validation policy stream cannot be null!");
        return ValidationPolicyLoader.fromValidationPolicy(new InMemoryDocument(validationPolicyStream));
    }

    public static ValidationPolicyLoader fromValidationPolicy(File validationPolicyFile) {
        Objects.requireNonNull(validationPolicyFile, "Validation policy file cannot be null!");
        return ValidationPolicyLoader.fromValidationPolicy(new FileDocument(validationPolicyFile));
    }

    public static ValidationPolicyLoader fromValidationPolicy(String validationPolicyFilePath) {
        ValidationPolicyLoader validationPolicyLoader;
        block8: {
            Objects.requireNonNull(validationPolicyFilePath, "Validation policy file path cannot be null!");
            InputStream is = ValidationPolicyLoader.class.getResourceAsStream(validationPolicyFilePath);
            try {
                validationPolicyLoader = ValidationPolicyLoader.fromValidationPolicy(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load a cryptographic suite from path '%s'. Reason : %s", validationPolicyFilePath, e.getMessage()), e);
                }
            }
            is.close();
        }
        return validationPolicyLoader;
    }

    public static ValidationPolicyLoader fromValidationPolicy(ValidationPolicy validationPolicy) {
        Objects.requireNonNull(validationPolicy, "Validation policy cannot be null!");
        return new ValidationPolicyLoader(validationPolicy);
    }

    public ValidationPolicyLoaderWithCryptoSuite withDefaultCryptographicSuite() {
        return this.withDefaultCryptographicSuiteForContext(null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(DSSDocument cryptographicSuite) {
        return this.withCryptographicSuiteForContext(cryptographicSuite, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(InputStream cryptographicSuiteIS) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteIS, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(File cryptographicSuiteFile) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteFile, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(String cryptographicSuiteFilePath) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteFilePath, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(CryptographicSuite cryptographicSuite) {
        return this.withCryptographicSuiteForContext(cryptographicSuite, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(CryptographicSuiteCatalogue cryptographicSuiteCatalogue) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteCatalogue, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withDefaultCryptographicSuiteForContext(Context context) {
        return this.withDefaultCryptographicSuiteForContext(context, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(DSSDocument cryptographicSuite, Context context) {
        return this.withCryptographicSuiteForContext(cryptographicSuite, context, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(InputStream cryptographicSuiteIS, Context context) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteIS, context, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(File cryptographicSuiteFile, Context context) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteFile, context, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(String cryptographicSuiteFilePath, Context context) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteFilePath, context, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(CryptographicSuite cryptographicSuite, Context context) {
        return this.withCryptographicSuiteForContext(cryptographicSuite, context, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(CryptographicSuiteCatalogue cryptographicSuiteCatalogue, Context context) {
        return this.withCryptographicSuiteForContext(cryptographicSuiteCatalogue, context, null);
    }

    public ValidationPolicyLoaderWithCryptoSuite withDefaultCryptographicSuiteForContext(Context context, SubContext subContext) {
        if (Context.EVIDENCE_RECORD == context && subContext != null) {
            throw new IllegalArgumentException("Please use a NULL SubContext for the Context.EVIDENCE_RECORD or use #withDefaultCryptographicSuiteForContext(cryptographicSuite, context) method.");
        }
        return this.withCryptographicSuiteForContext(ValidationPolicyLoader.loadDefaultCryptographicSuite(), context, subContext);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(DSSDocument cryptographicSuite, Context context, SubContext subContext) {
        Objects.requireNonNull(cryptographicSuite, "Cryptographic suite document cannot be null!");
        return this.withCryptographicSuiteForContext(ValidationPolicyLoader.loadCryptographicSuiteCatalogue(cryptographicSuite), context, subContext);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(InputStream cryptographicSuiteIS, Context context, SubContext subContext) {
        Objects.requireNonNull(cryptographicSuiteIS, "Cryptographic suite stream cannot be null!");
        return this.withCryptographicSuiteForContext(new InMemoryDocument(cryptographicSuiteIS), context, subContext);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(File cryptographicSuiteFile, Context context, SubContext subContext) {
        Objects.requireNonNull(cryptographicSuiteFile, "Cryptographic suite file cannot be null!");
        return this.withCryptographicSuiteForContext(new FileDocument(cryptographicSuiteFile), context, subContext);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(String cryptographicSuiteFilePath, Context context, SubContext subContext) {
        ValidationPolicyLoaderWithCryptoSuite validationPolicyLoaderWithCryptoSuite;
        block8: {
            Objects.requireNonNull(cryptographicSuiteFilePath, "Cryptographic suite file path cannot be null!");
            InputStream is = this.getClass().getResourceAsStream(cryptographicSuiteFilePath);
            try {
                validationPolicyLoaderWithCryptoSuite = this.withCryptographicSuiteForContext(is, context, subContext);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load a cryptographic suite catalogue from path '%s'. Reason : %s", cryptographicSuiteFilePath, e.getMessage()), e);
                }
            }
            is.close();
        }
        return validationPolicyLoaderWithCryptoSuite;
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(CryptographicSuite cryptographicSuite, Context context, SubContext subContext) {
        Objects.requireNonNull(cryptographicSuite, "Cryptographic suite cannot be null!");
        this.cryptographicSuitesMap.computeIfAbsent(cryptographicSuite, k -> new ArrayList()).add(new ContextAndSubContext(context, subContext));
        return new ValidationPolicyLoaderWithCryptoSuite(this, cryptographicSuite);
    }

    public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(CryptographicSuiteCatalogue cryptographicSuiteCatalogue, Context context, SubContext subContext) {
        ArrayList<CryptographicSuite> cryptographicSuites;
        block16: {
            block15: {
                Objects.requireNonNull(cryptographicSuiteCatalogue, "Cryptographic suite catalogue cannot be null!");
                cryptographicSuites = new ArrayList<CryptographicSuite>();
                if (context == null) break block15;
                switch (context) {
                    case SIGNATURE: 
                    case CERTIFICATE: {
                        if (subContext != null) {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCertificatesCryptographicSuite(), context, subContext);
                        } else {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCryptographicSuite(), context, subContext);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCertificatesCryptographicSuite(), context, SubContext.SIGNING_CERT);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCertificatesCryptographicSuite(), context, SubContext.CA_CERTIFICATE);
                        }
                        break block16;
                    }
                    case COUNTER_SIGNATURE: {
                        if (subContext != null) {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCounterSignatureCertificatesCryptographicSuite(), context, subContext);
                        } else {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCounterSignatureCryptographicSuite(), context, subContext);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCounterSignatureCertificatesCryptographicSuite(), context, SubContext.SIGNING_CERT);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCounterSignatureCertificatesCryptographicSuite(), context, SubContext.CA_CERTIFICATE);
                        }
                        break block16;
                    }
                    case REVOCATION: {
                        if (subContext != null) {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getRevocationCertificatesCryptographicSuite(), context, subContext);
                        } else {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getRevocationCryptographicSuite(), context, subContext);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getRevocationCertificatesCryptographicSuite(), context, SubContext.SIGNING_CERT);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getRevocationCertificatesCryptographicSuite(), context, SubContext.CA_CERTIFICATE);
                        }
                        break block16;
                    }
                    case TIMESTAMP: {
                        if (subContext != null) {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getTimestampCertificatesCryptographicSuite(), context, subContext);
                        } else {
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getTimestampCryptographicSuite(), context, subContext);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getTimestampCertificatesCryptographicSuite(), context, SubContext.SIGNING_CERT);
                            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getTimestampCertificatesCryptographicSuite(), context, SubContext.CA_CERTIFICATE);
                        }
                        break block16;
                    }
                    case EVIDENCE_RECORD: {
                        this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getEvidenceRecordSignatureCryptographicSuite(), context, subContext);
                        break block16;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("The Context '%s' is not supported!", new Object[]{context}));
                    }
                }
            }
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCryptographicSuite(), context, subContext);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCryptographicSuite(), Context.CERTIFICATE, subContext);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCertificatesCryptographicSuite(), Context.CERTIFICATE, SubContext.SIGNING_CERT);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCertificatesCryptographicSuite(), Context.CERTIFICATE, SubContext.CA_CERTIFICATE);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCryptographicSuite(), Context.SIGNATURE, subContext);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCertificatesCryptographicSuite(), Context.SIGNATURE, SubContext.SIGNING_CERT);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getSignatureCertificatesCryptographicSuite(), Context.SIGNATURE, SubContext.CA_CERTIFICATE);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCounterSignatureCryptographicSuite(), Context.COUNTER_SIGNATURE, subContext);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCounterSignatureCertificatesCryptographicSuite(), Context.COUNTER_SIGNATURE, SubContext.SIGNING_CERT);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getCounterSignatureCertificatesCryptographicSuite(), Context.COUNTER_SIGNATURE, SubContext.CA_CERTIFICATE);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getRevocationCryptographicSuite(), Context.REVOCATION, subContext);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getRevocationCertificatesCryptographicSuite(), Context.REVOCATION, SubContext.SIGNING_CERT);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getRevocationCertificatesCryptographicSuite(), Context.REVOCATION, SubContext.CA_CERTIFICATE);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getTimestampCryptographicSuite(), Context.TIMESTAMP, subContext);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getTimestampCertificatesCryptographicSuite(), Context.TIMESTAMP, SubContext.SIGNING_CERT);
            this.addCryptographicSuite(cryptographicSuites, cryptographicSuiteCatalogue.getTimestampCertificatesCryptographicSuite(), Context.TIMESTAMP, SubContext.CA_CERTIFICATE);
        }
        return new ValidationPolicyLoaderWithCryptoSuite(this, cryptographicSuites);
    }

    private void addCryptographicSuite(List<CryptographicSuite> cryptographicSuites, CryptographicSuite cryptographicSuite, Context context, SubContext subContext) {
        this.cryptographicSuitesMap.computeIfAbsent(cryptographicSuite, k -> new ArrayList()).add(new ContextAndSubContext(context, subContext));
        cryptographicSuites.add(cryptographicSuite);
    }

    public ValidationPolicy create() {
        if (Utils.isMapEmpty(this.cryptographicSuitesMap)) {
            return this.validationPolicy;
        }
        ValidationPolicyWithCryptographicSuite validationPolicyWithCryptographicSuite = new ValidationPolicyWithCryptographicSuite(this.validationPolicy);
        for (Map.Entry<CryptographicSuite, List<ContextAndSubContext>> entry : this.cryptographicSuitesMap.entrySet()) {
            CryptographicSuite cryptographicSuite = entry.getKey();
            for (ContextAndSubContext scope : entry.getValue()) {
                if (scope == null) {
                    validationPolicyWithCryptographicSuite.setCryptographicSuite(cryptographicSuite);
                    continue;
                }
                validationPolicyWithCryptographicSuite.setCryptographicSuite(cryptographicSuite, scope.getContext(), scope.getSubContext());
            }
        }
        return validationPolicyWithCryptographicSuite;
    }

    private static ValidationPolicy loadDefaultPolicy() {
        ServiceLoader<ValidationPolicyFactory> loader = ServiceLoader.load(ValidationPolicyFactory.class);
        Iterator<ValidationPolicyFactory> factoryOptions = loader.iterator();
        if (factoryOptions.hasNext()) {
            return factoryOptions.next().loadDefaultValidationPolicy();
        }
        throw new UnsupportedOperationException("No ValidationPolicyFactory has been found! Please add 'dss-policy-jaxb' module to the classpath or create your own implementation.");
    }

    private static ValidationPolicy loadPolicy(DSSDocument validationPolicyDocument) {
        ServiceLoader<ValidationPolicyFactory> loader = ServiceLoader.load(ValidationPolicyFactory.class);
        for (ValidationPolicyFactory factory : loader) {
            if (!factory.isSupported(validationPolicyDocument)) continue;
            return factory.loadValidationPolicy(validationPolicyDocument);
        }
        throw new UnsupportedOperationException("The validation policy is not valid or no suitable ValidationPolicyFactory has been found! Please ensure the provided policy file is valid and 'dss-policy-jaxb' module is added to the classpath or create your own implementation for a custom policy.");
    }

    private static CryptographicSuiteCatalogue loadDefaultCryptographicSuite() {
        ServiceLoader<CryptographicSuiteFactory> loader = ServiceLoader.load(CryptographicSuiteFactory.class);
        Iterator<CryptographicSuiteFactory> factoryOptions = loader.iterator();
        if (factoryOptions.hasNext()) {
            return factoryOptions.next().loadDefaultCryptographicSuite();
        }
        throw new UnsupportedOperationException("No ValidationPolicyFactory has been found! Please add 'dss-policy-jaxb' module to the classpath or create your own implementation.");
    }

    private static CryptographicSuiteCatalogue loadCryptographicSuiteCatalogue(DSSDocument cryptographicSuiteDocument) {
        ServiceLoader<CryptographicSuiteFactory> loader = ServiceLoader.load(CryptographicSuiteFactory.class);
        for (CryptographicSuiteFactory factory : loader) {
            if (!factory.isSupported(cryptographicSuiteDocument)) continue;
            return factory.loadCryptographicSuite(cryptographicSuiteDocument);
        }
        throw new UnsupportedOperationException("The cryptographic suite file is not valid or no suitable CryptographicSuiteFactory has been found! Please ensure the provided policy file is valid and 'dss-policy-crypto-xml' or 'dss-policy-crypto-json' module is added to the classpath or create your own implementation for a custom cryptographic suite policy.");
    }

    public static class ValidationPolicyLoaderWithCryptoSuite
    extends ValidationPolicyLoader {
        private final ValidationPolicyLoader validationPolicyLoader;
        private final List<CryptographicSuite> cryptographicSuites;

        protected ValidationPolicyLoaderWithCryptoSuite(ValidationPolicyLoader validationPolicyLoader, CryptographicSuite cryptographicSuite) {
            this(validationPolicyLoader, Collections.singletonList(cryptographicSuite));
        }

        protected ValidationPolicyLoaderWithCryptoSuite(ValidationPolicyLoader validationPolicyLoader, List<CryptographicSuite> cryptographicSuites) {
            this.validationPolicyLoader = validationPolicyLoader;
            this.cryptographicSuites = cryptographicSuites;
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withDefaultCryptographicSuite() {
            return this.validationPolicyLoader.withDefaultCryptographicSuite();
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(DSSDocument cryptographicSuite) {
            return this.validationPolicyLoader.withCryptographicSuite(cryptographicSuite);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(InputStream cryptographicSuiteIS) {
            return this.validationPolicyLoader.withCryptographicSuite(cryptographicSuiteIS);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(File cryptographicSuiteFile) {
            return this.validationPolicyLoader.withCryptographicSuite(cryptographicSuiteFile);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(String cryptographicSuiteFilePath) {
            return this.validationPolicyLoader.withCryptographicSuite(cryptographicSuiteFilePath);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuite(CryptographicSuite cryptographicSuite) {
            return this.validationPolicyLoader.withCryptographicSuite(cryptographicSuite);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withDefaultCryptographicSuiteForContext(Context context) {
            return this.validationPolicyLoader.withDefaultCryptographicSuiteForContext(context);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(DSSDocument cryptographicSuite, Context context) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuite, context);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(InputStream cryptographicSuiteIS, Context context) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuiteIS, context);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(File cryptographicSuiteFile, Context context) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuiteFile, context);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(String cryptographicSuiteFilePath, Context context) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuiteFilePath, context);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(CryptographicSuite cryptographicSuite, Context context) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuite, context);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withDefaultCryptographicSuiteForContext(Context context, SubContext subContext) {
            return this.validationPolicyLoader.withDefaultCryptographicSuiteForContext(context, subContext);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(DSSDocument cryptographicSuite, Context context, SubContext subContext) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuite, context, subContext);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(InputStream cryptographicSuiteIS, Context context, SubContext subContext) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuiteIS, context, subContext);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(File cryptographicSuiteFile, Context context, SubContext subContext) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuiteFile, context, subContext);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(String cryptographicSuiteFilePath, Context context, SubContext subContext) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuiteFilePath, context, subContext);
        }

        @Override
        public ValidationPolicyLoaderWithCryptoSuite withCryptographicSuiteForContext(CryptographicSuite cryptographicSuite, Context context, SubContext subContext) {
            return this.validationPolicyLoader.withCryptographicSuiteForContext(cryptographicSuite, context, subContext);
        }

        @Override
        public ValidationPolicy create() {
            return this.validationPolicyLoader.create();
        }

        public ValidationPolicyLoaderWithCryptoSuite andLevel(Level level) {
            this.cryptographicSuites.forEach(s -> s.setLevel(level));
            return this;
        }

        public ValidationPolicyLoaderWithCryptoSuite andAcceptableDigestAlgorithmsLevel(Level level) {
            this.cryptographicSuites.forEach(s -> s.setAcceptableDigestAlgorithmsLevel(level));
            return this;
        }

        @Deprecated
        public ValidationPolicyLoaderWithCryptoSuite andAcceptableEncryptionAlgorithmsLevel(Level level) {
            return this.andAcceptableSignatureAlgorithmsLevel(level);
        }

        public ValidationPolicyLoaderWithCryptoSuite andAcceptableSignatureAlgorithmsLevel(Level level) {
            this.cryptographicSuites.forEach(s -> s.setAcceptableSignatureAlgorithmsLevel(level));
            return this;
        }

        @Deprecated
        public ValidationPolicyLoaderWithCryptoSuite andAcceptableEncryptionAlgorithmsMiniKeySizeLevel(Level level) {
            return this.andAcceptableSignatureAlgorithmsMiniKeySizeLevel(level);
        }

        public ValidationPolicyLoaderWithCryptoSuite andAcceptableSignatureAlgorithmsMiniKeySizeLevel(Level level) {
            this.cryptographicSuites.forEach(s -> s.setAcceptableSignatureAlgorithmsMiniKeySizeLevel(level));
            return this;
        }

        public ValidationPolicyLoaderWithCryptoSuite andAlgorithmsExpirationDateLevel(Level level) {
            this.cryptographicSuites.forEach(s -> s.setAlgorithmsExpirationDateLevel(level));
            return this;
        }

        public ValidationPolicyLoaderWithCryptoSuite andAlgorithmsExpirationTimeAfterPolicyUpdateLevel(Level level) {
            this.cryptographicSuites.forEach(s -> s.setAlgorithmsExpirationTimeAfterPolicyUpdateLevel(level));
            return this;
        }
    }
}

