/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.enumerations.ValidationModel;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.DurationRule;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.NumericValueRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.model.policy.ValueRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.policy.ContextAndSubContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidationPolicyWithCryptographicSuite
implements ValidationPolicy {
    private final ValidationPolicy validationPolicy;
    private final Map<ContextAndSubContext, CryptographicSuite> cryptographicSuitesMap = new HashMap<ContextAndSubContext, CryptographicSuite>();

    public ValidationPolicyWithCryptographicSuite(ValidationPolicy validationPolicy) {
        Objects.requireNonNull(validationPolicy, "ValidationPolicy cannot be null!");
        this.validationPolicy = validationPolicy;
    }

    public void setCryptographicSuite(CryptographicSuite cryptographicSuite) {
        this.cryptographicSuitesMap.put(new ContextAndSubContext(), cryptographicSuite);
    }

    public void setCryptographicSuite(CryptographicSuite cryptographicSuite, Context context) {
        this.cryptographicSuitesMap.put(new ContextAndSubContext(context, null), cryptographicSuite);
    }

    public void setCryptographicSuite(CryptographicSuite cryptographicSuite, Context context, SubContext subContext) {
        if (Context.EVIDENCE_RECORD == context && subContext != null) {
            throw new IllegalArgumentException("Please use a NULL SubContext for the Context.EVIDENCE_RECORD or use #setCryptographicSuite(cryptographicSuite, context) method.");
        }
        this.cryptographicSuitesMap.put(new ContextAndSubContext(context, subContext), cryptographicSuite);
    }

    @Override
    public String getPolicyName() {
        return this.validationPolicy.getPolicyName();
    }

    @Override
    public String getPolicyDescription() {
        return this.validationPolicy.getPolicyDescription();
    }

    @Override
    public MultiValuesRule getSignaturePolicyConstraint(Context context) {
        return this.validationPolicy.getSignaturePolicyConstraint(context);
    }

    @Override
    public LevelRule getSignaturePolicyIdentifiedConstraint(Context context) {
        return this.validationPolicy.getSignaturePolicyIdentifiedConstraint(context);
    }

    @Override
    public LevelRule getSignaturePolicyStorePresentConstraint(Context context) {
        return this.validationPolicy.getSignaturePolicyStorePresentConstraint(context);
    }

    @Override
    public LevelRule getSignaturePolicyPolicyHashValid(Context context) {
        return this.validationPolicy.getSignaturePolicyPolicyHashValid(context);
    }

    @Override
    public LevelRule getStructuralValidationConstraint(Context context) {
        return this.validationPolicy.getStructuralValidationConstraint(context);
    }

    @Override
    public LevelRule getSigningCertificateRefersCertificateChainConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateRefersCertificateChainConstraint(context);
    }

    @Override
    public LevelRule getReferencesToAllCertificateChainPresentConstraint(Context context) {
        return this.validationPolicy.getReferencesToAllCertificateChainPresentConstraint(context);
    }

    @Override
    public LevelRule getSigningCertificateDigestAlgorithmConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateDigestAlgorithmConstraint(context);
    }

    @Override
    @Deprecated
    public LevelRule getSigningDurationRule(Context context) {
        return this.getSigningTimeConstraint(context);
    }

    @Override
    public LevelRule getSigningTimeConstraint(Context context) {
        return this.validationPolicy.getSigningTimeConstraint(context);
    }

    @Override
    public LevelRule getSigningTimeInCertRangeConstraint(Context context) {
        return this.validationPolicy.getSigningTimeInCertRangeConstraint(context);
    }

    @Override
    public MultiValuesRule getContentTypeConstraint(Context context) {
        return this.validationPolicy.getContentTypeConstraint(context);
    }

    @Override
    public MultiValuesRule getContentHintsConstraint(Context context) {
        return this.validationPolicy.getContentHintsConstraint(context);
    }

    @Override
    public MultiValuesRule getContentIdentifierConstraint(Context context) {
        return this.validationPolicy.getContentIdentifierConstraint(context);
    }

    @Override
    public LevelRule getMessageDigestOrSignedPropertiesConstraint(Context context) {
        return this.validationPolicy.getMessageDigestOrSignedPropertiesConstraint(context);
    }

    @Override
    public LevelRule getEllipticCurveKeySizeConstraint(Context context) {
        return this.validationPolicy.getEllipticCurveKeySizeConstraint(context);
    }

    @Override
    public MultiValuesRule getCommitmentTypeIndicationConstraint(Context context) {
        return this.validationPolicy.getCommitmentTypeIndicationConstraint(context);
    }

    @Override
    public LevelRule getSignerLocationConstraint(Context context) {
        return this.validationPolicy.getSignerLocationConstraint(context);
    }

    @Override
    public LevelRule getContentTimeStampConstraint(Context context) {
        return this.validationPolicy.getContentTimeStampConstraint(context);
    }

    @Override
    public LevelRule getContentTimeStampMessageImprintConstraint(Context context) {
        return this.validationPolicy.getContentTimeStampMessageImprintConstraint(context);
    }

    @Override
    public MultiValuesRule getClaimedRoleConstraint(Context context) {
        return this.validationPolicy.getClaimedRoleConstraint(context);
    }

    @Override
    public MultiValuesRule getCertifiedRolesConstraint(Context context) {
        return this.validationPolicy.getCertifiedRolesConstraint(context);
    }

    @Override
    public CryptographicSuite getSignatureCryptographicConstraint(Context context) {
        CryptographicSuite cryptographicSuite = this.getCryptographicSuite(context, null);
        if (cryptographicSuite == null) {
            cryptographicSuite = this.validationPolicy.getSignatureCryptographicConstraint(context);
        }
        return cryptographicSuite;
    }

    @Override
    public CryptographicSuite getCertificateCryptographicConstraint(Context context, SubContext subContext) {
        CryptographicSuite cryptographicSuite = this.getCryptographicSuite(context, subContext);
        if (cryptographicSuite == null) {
            cryptographicSuite = this.validationPolicy.getCertificateCryptographicConstraint(context, subContext);
        }
        return cryptographicSuite;
    }

    @Override
    public CryptographicSuite getEvidenceRecordCryptographicConstraint() {
        CryptographicSuite cryptographicSuite = this.getCryptographicSuite(Context.EVIDENCE_RECORD, null);
        if (cryptographicSuite == null) {
            cryptographicSuite = this.validationPolicy.getEvidenceRecordCryptographicConstraint();
        }
        return cryptographicSuite;
    }

    private CryptographicSuite getCryptographicSuite(Context context, SubContext subContext) {
        if (Utils.isMapNotEmpty(this.cryptographicSuitesMap)) {
            ContextAndSubContext contextAndSubContext;
            for (Map.Entry<ContextAndSubContext, CryptographicSuite> entry : this.cryptographicSuitesMap.entrySet()) {
                contextAndSubContext = entry.getKey();
                if (context != contextAndSubContext.getContext() || subContext != contextAndSubContext.getSubContext()) continue;
                return entry.getValue();
            }
            for (Map.Entry<ContextAndSubContext, CryptographicSuite> entry : this.cryptographicSuitesMap.entrySet()) {
                contextAndSubContext = entry.getKey();
                if (context != contextAndSubContext.getContext() || contextAndSubContext.getSubContext() != null) continue;
                return entry.getValue();
            }
            for (Map.Entry<ContextAndSubContext, CryptographicSuite> entry : this.cryptographicSuitesMap.entrySet()) {
                contextAndSubContext = entry.getKey();
                if (contextAndSubContext.getContext() != null || contextAndSubContext.getSubContext() != null) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public LevelRule getCertificateCAConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateCAConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateMaxPathLengthConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateMaxPathLengthConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateKeyUsageConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateKeyUsageConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateExtendedKeyUsageConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateExtendedKeyUsageConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificatePolicyTreeConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicyTreeConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateNameConstraintsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNameConstraintsConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateAuthorityKeyIdentifierPresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateAuthorityKeyIdentifierPresentConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateSubjectKeyIdentifierPresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSubjectKeyIdentifierPresentConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateNoRevAvailConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNoRevAvailConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateSupportedCriticalExtensionsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSupportedCriticalExtensionsConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateForbiddenExtensionsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateForbiddenExtensionsConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateNotExpiredConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotExpiredConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateSunsetDateConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSunsetDateConstraint(context, subContext);
    }

    @Override
    public LevelRule getProspectiveCertificateChainConstraint(Context context) {
        return this.validationPolicy.getProspectiveCertificateChainConstraint(context);
    }

    @Override
    public LevelRule getCertificateSignatureConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSignatureConstraint(context, subContext);
    }

    @Override
    public LevelRule getUnknownStatusConstraint() {
        return this.validationPolicy.getUnknownStatusConstraint();
    }

    @Override
    public LevelRule getThisUpdatePresentConstraint() {
        return this.validationPolicy.getThisUpdatePresentConstraint();
    }

    @Override
    public LevelRule getRevocationIssuerKnownConstraint() {
        return this.validationPolicy.getRevocationIssuerKnownConstraint();
    }

    @Override
    public LevelRule getRevocationIssuerValidAtProductionTimeConstraint() {
        return this.validationPolicy.getRevocationIssuerValidAtProductionTimeConstraint();
    }

    @Override
    public LevelRule getRevocationAfterCertificateIssuanceConstraint() {
        return this.validationPolicy.getRevocationAfterCertificateIssuanceConstraint();
    }

    @Override
    public LevelRule getRevocationHasInformationAboutCertificateConstraint() {
        return this.validationPolicy.getRevocationHasInformationAboutCertificateConstraint();
    }

    @Override
    public LevelRule getOCSPResponseResponderIdMatchConstraint() {
        return this.validationPolicy.getOCSPResponseResponderIdMatchConstraint();
    }

    @Override
    public LevelRule getOCSPResponseCertHashPresentConstraint() {
        return this.validationPolicy.getOCSPResponseCertHashPresentConstraint();
    }

    @Override
    public LevelRule getOCSPResponseCertHashMatchConstraint() {
        return this.validationPolicy.getOCSPResponseCertHashMatchConstraint();
    }

    @Override
    public LevelRule getSelfIssuedOCSPConstraint() {
        return this.validationPolicy.getSelfIssuedOCSPConstraint();
    }

    @Override
    public LevelRule getRevocationDataAvailableConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationDataAvailableConstraint(context, subContext);
    }

    @Override
    public LevelRule getAcceptableRevocationDataFoundConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getAcceptableRevocationDataFoundConstraint(context, subContext);
    }

    @Override
    public LevelRule getCRLNextUpdatePresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCRLNextUpdatePresentConstraint(context, subContext);
    }

    @Override
    public LevelRule getOCSPNextUpdatePresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getOCSPNextUpdatePresentConstraint(context, subContext);
    }

    @Override
    public DurationRule getRevocationFreshnessConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationFreshnessConstraint(context, subContext);
    }

    @Override
    public LevelRule getRevocationFreshnessNextUpdateConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationFreshnessNextUpdateConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateNotRevokedConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotRevokedConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateNotOnHoldConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotOnHoldConstraint(context, subContext);
    }

    @Override
    public LevelRule getRevocationIssuerNotExpiredConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationIssuerNotExpiredConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateNotSelfSignedConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateNotSelfSignedConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateSelfSignedConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSelfSignedConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getTrustServiceTypeIdentifierConstraint(Context context) {
        return this.validationPolicy.getTrustServiceTypeIdentifierConstraint(context);
    }

    @Override
    public MultiValuesRule getTrustServiceStatusConstraint(Context context) {
        return this.validationPolicy.getTrustServiceStatusConstraint(context);
    }

    @Override
    public MultiValuesRule getCertificatePolicyIdsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicyIdsConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificatePolicyQualificationIdsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicyQualificationIdsConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificatePolicySupportedByQSCDIdsConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePolicySupportedByQSCDIdsConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateQCComplianceConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQCComplianceConstraint(context, subContext);
    }

    @Override
    public ValueRule getCertificateQcEuLimitValueCurrencyConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcEuLimitValueCurrencyConstraint(context, subContext);
    }

    @Override
    public NumericValueRule getCertificateMinQcEuLimitValueConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateMinQcEuLimitValueConstraint(context, subContext);
    }

    @Override
    public NumericValueRule getCertificateMinQcEuRetentionPeriodConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateMinQcEuRetentionPeriodConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateQcSSCDConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcSSCDConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateQcEuPDSLocationConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcEuPDSLocationConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateQcTypeConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcTypeConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateQcCCLegislationConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcCCLegislationConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateIssuedToNaturalPersonConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateIssuedToNaturalPersonConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateIssuedToLegalPersonConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateIssuedToLegalPersonConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateSemanticsIdentifierConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSemanticsIdentifierConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificatePS2DQcTypeRolesOfPSPConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePS2DQcTypeRolesOfPSPConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificatePS2DQcCompetentAuthorityNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePS2DQcCompetentAuthorityNameConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificatePS2DQcCompetentAuthorityIdConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePS2DQcCompetentAuthorityIdConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateQcQSCDLegislationConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcQSCDLegislationConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateQcIdentificationMethodConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateQcIdentificationMethodConstraint(context, subContext);
    }

    @Override
    public LevelRule getSigningCertificateRecognitionConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateRecognitionConstraint(context);
    }

    @Override
    public LevelRule getSigningCertificateAttributePresentConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateAttributePresentConstraint(context);
    }

    @Override
    public LevelRule getUnicitySigningCertificateAttributeConstraint(Context context) {
        return this.validationPolicy.getUnicitySigningCertificateAttributeConstraint(context);
    }

    @Override
    public LevelRule getSigningCertificateDigestValuePresentConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateDigestValuePresentConstraint(context);
    }

    @Override
    public LevelRule getSigningCertificateDigestValueMatchConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateDigestValueMatchConstraint(context);
    }

    @Override
    public LevelRule getSigningCertificateIssuerSerialMatchConstraint(Context context) {
        return this.validationPolicy.getSigningCertificateIssuerSerialMatchConstraint(context);
    }

    @Override
    public LevelRule getKeyIdentifierPresent(Context context) {
        return this.validationPolicy.getKeyIdentifierPresent(context);
    }

    @Override
    public LevelRule getKeyIdentifierMatch(Context context) {
        return this.validationPolicy.getKeyIdentifierMatch(context);
    }

    @Override
    public LevelRule getReferenceDataExistenceConstraint(Context context) {
        return this.validationPolicy.getReferenceDataExistenceConstraint(context);
    }

    @Override
    public LevelRule getReferenceDataIntactConstraint(Context context) {
        return this.validationPolicy.getReferenceDataIntactConstraint(context);
    }

    @Override
    public LevelRule getReferenceDataNameMatchConstraint(Context context) {
        return this.validationPolicy.getReferenceDataNameMatchConstraint(context);
    }

    @Override
    public LevelRule getManifestEntryObjectExistenceConstraint(Context context) {
        return this.validationPolicy.getManifestEntryObjectExistenceConstraint(context);
    }

    @Override
    public LevelRule getManifestEntryObjectIntactConstraint(Context context) {
        return this.validationPolicy.getManifestEntryObjectIntactConstraint(context);
    }

    @Override
    public LevelRule getManifestEntryObjectGroupConstraint(Context context) {
        return this.validationPolicy.getManifestEntryObjectGroupConstraint(context);
    }

    @Override
    public LevelRule getManifestEntryNameMatchConstraint(Context context) {
        return this.validationPolicy.getManifestEntryNameMatchConstraint(context);
    }

    @Override
    public LevelRule getSignatureIntactConstraint(Context context) {
        return this.validationPolicy.getSignatureIntactConstraint(context);
    }

    @Override
    public LevelRule getSignatureDuplicatedConstraint(Context context) {
        return this.validationPolicy.getSignatureDuplicatedConstraint(context);
    }

    @Override
    public LevelRule getSignerInformationStoreConstraint(Context context) {
        return this.validationPolicy.getSignerInformationStoreConstraint(context);
    }

    @Override
    public LevelRule getByteRangeConstraint(Context context) {
        return this.validationPolicy.getByteRangeConstraint(context);
    }

    @Override
    public LevelRule getByteRangeCollisionConstraint(Context context) {
        return this.validationPolicy.getByteRangeCollisionConstraint(context);
    }

    @Override
    public LevelRule getByteRangeAllDocumentConstraint(Context context) {
        return this.validationPolicy.getByteRangeAllDocumentConstraint(context);
    }

    @Override
    public LevelRule getPdfSignatureDictionaryConstraint(Context context) {
        return this.validationPolicy.getPdfSignatureDictionaryConstraint(context);
    }

    @Override
    public LevelRule getPdfPageDifferenceConstraint(Context context) {
        return this.validationPolicy.getPdfPageDifferenceConstraint(context);
    }

    @Override
    public LevelRule getPdfAnnotationOverlapConstraint(Context context) {
        return this.validationPolicy.getPdfAnnotationOverlapConstraint(context);
    }

    @Override
    public LevelRule getPdfVisualDifferenceConstraint(Context context) {
        return this.validationPolicy.getPdfVisualDifferenceConstraint(context);
    }

    @Override
    public LevelRule getDocMDPConstraint(Context context) {
        return this.validationPolicy.getDocMDPConstraint(context);
    }

    @Override
    public LevelRule getFieldMDPConstraint(Context context) {
        return this.validationPolicy.getFieldMDPConstraint(context);
    }

    @Override
    public LevelRule getSigFieldLockConstraint(Context context) {
        return this.validationPolicy.getSigFieldLockConstraint(context);
    }

    @Override
    public LevelRule getFormFillChangesConstraint(Context context) {
        return this.validationPolicy.getFormFillChangesConstraint(context);
    }

    @Override
    public LevelRule getAnnotationChangesConstraint(Context context) {
        return this.validationPolicy.getAnnotationChangesConstraint(context);
    }

    @Override
    public LevelRule getUndefinedChangesConstraint(Context context) {
        return this.validationPolicy.getUndefinedChangesConstraint(context);
    }

    @Override
    public LevelRule getBestSignatureTimeBeforeExpirationDateOfSigningCertificateConstraint() {
        return this.validationPolicy.getBestSignatureTimeBeforeExpirationDateOfSigningCertificateConstraint();
    }

    @Override
    public LevelRule getTimestampCoherenceConstraint() {
        return this.validationPolicy.getTimestampCoherenceConstraint();
    }

    @Override
    public DurationRule getTimestampDelayConstraint() {
        return this.validationPolicy.getTimestampDelayConstraint();
    }

    @Override
    public LevelRule getTimestampValidConstraint() {
        return this.validationPolicy.getTimestampValidConstraint();
    }

    @Override
    public LevelRule getTimestampTSAGeneralNamePresent() {
        return this.validationPolicy.getTimestampTSAGeneralNamePresent();
    }

    @Override
    public LevelRule getTimestampTSAGeneralNameContentMatch() {
        return this.validationPolicy.getTimestampTSAGeneralNameContentMatch();
    }

    @Override
    public LevelRule getTimestampTSAGeneralNameOrderMatch() {
        return this.validationPolicy.getTimestampTSAGeneralNameOrderMatch();
    }

    @Override
    public LevelRule getAtsHashIndexConstraint() {
        return this.validationPolicy.getAtsHashIndexConstraint();
    }

    @Override
    public LevelRule getTimestampContainerSignedAndTimestampedFilesCoveredConstraint() {
        return this.validationPolicy.getTimestampContainerSignedAndTimestampedFilesCoveredConstraint();
    }

    @Override
    @Deprecated
    public LevelRule getRevocationTimeAgainstBestSignatureDurationRule() {
        return this.getRevocationTimeAgainstBestSignatureTimeConstraint();
    }

    @Override
    public LevelRule getRevocationTimeAgainstBestSignatureTimeConstraint() {
        return this.validationPolicy.getRevocationTimeAgainstBestSignatureTimeConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordValidConstraint() {
        return this.validationPolicy.getEvidenceRecordValidConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordDataObjectExistenceConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectExistenceConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordDataObjectIntactConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectIntactConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordDataObjectFoundConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectFoundConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordDataObjectGroupConstraint() {
        return this.validationPolicy.getEvidenceRecordDataObjectGroupConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordSignedFilesCoveredConstraint() {
        return this.validationPolicy.getEvidenceRecordSignedFilesCoveredConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordContainerSignedAndTimestampedFilesCoveredConstraint() {
        return this.validationPolicy.getEvidenceRecordContainerSignedAndTimestampedFilesCoveredConstraint();
    }

    @Override
    public LevelRule getEvidenceRecordHashTreeRenewalConstraint() {
        return this.validationPolicy.getEvidenceRecordHashTreeRenewalConstraint();
    }

    @Override
    public LevelRule getCounterSignatureConstraint(Context context) {
        return this.validationPolicy.getCounterSignatureConstraint(context);
    }

    @Override
    public LevelRule getSignatureTimeStampConstraint(Context context) {
        return this.validationPolicy.getSignatureTimeStampConstraint(context);
    }

    @Override
    public LevelRule getValidationDataTimeStampConstraint(Context context) {
        return this.validationPolicy.getValidationDataTimeStampConstraint(context);
    }

    @Override
    public LevelRule getValidationDataRefsOnlyTimeStampConstraint(Context context) {
        return this.validationPolicy.getValidationDataRefsOnlyTimeStampConstraint(context);
    }

    @Override
    public LevelRule getArchiveTimeStampConstraint(Context context) {
        return this.validationPolicy.getArchiveTimeStampConstraint(context);
    }

    @Override
    public LevelRule getDocumentTimeStampConstraint(Context context) {
        return this.validationPolicy.getDocumentTimeStampConstraint(context);
    }

    @Override
    public LevelRule getTLevelTimeStampConstraint(Context context) {
        return this.validationPolicy.getTLevelTimeStampConstraint(context);
    }

    @Override
    public LevelRule getLTALevelTimeStampConstraint(Context context) {
        return this.validationPolicy.getLTALevelTimeStampConstraint(context);
    }

    @Override
    public MultiValuesRule getSignatureFormatConstraint(Context context) {
        return this.validationPolicy.getSignatureFormatConstraint(context);
    }

    @Override
    public MultiValuesRule getCertificateCountryConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateCountryConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateLocalityConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateLocalityConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateStateConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateStateConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateOrganizationIdentifierConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateOrganizationIdentifierConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateOrganizationNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateOrganizationNameConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateOrganizationUnitConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateOrganizationUnitConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateIssuerNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateIssuerNameConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateSurnameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSurnameConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateGivenNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateGivenNameConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateCommonNameConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateCommonNameConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificatePseudonymConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePseudonymConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificatePseudoUsageConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificatePseudoUsageConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateTitleConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateTitleConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getCertificateEmailConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateEmailConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateSerialNumberConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateSerialNumberConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateAuthorityInfoAccessPresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateAuthorityInfoAccessPresentConstraint(context, subContext);
    }

    @Override
    public CertificateApplicabilityRule getRevocationDataSkipConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getRevocationDataSkipConstraint(context, subContext);
    }

    @Override
    public LevelRule getCertificateRevocationInfoAccessPresentConstraint(Context context, SubContext subContext) {
        return this.validationPolicy.getCertificateRevocationInfoAccessPresentConstraint(context, subContext);
    }

    @Override
    public MultiValuesRule getAcceptedContainerTypesConstraint() {
        return this.validationPolicy.getAcceptedContainerTypesConstraint();
    }

    @Override
    public LevelRule getZipCommentPresentConstraint() {
        return this.validationPolicy.getZipCommentPresentConstraint();
    }

    @Override
    public MultiValuesRule getAcceptedZipCommentsConstraint() {
        return this.validationPolicy.getAcceptedZipCommentsConstraint();
    }

    @Override
    public LevelRule getMimeTypeFilePresentConstraint() {
        return this.validationPolicy.getMimeTypeFilePresentConstraint();
    }

    @Override
    public MultiValuesRule getAcceptedMimeTypeContentsConstraint() {
        return this.validationPolicy.getAcceptedMimeTypeContentsConstraint();
    }

    @Override
    public LevelRule getManifestFilePresentConstraint() {
        return this.validationPolicy.getManifestFilePresentConstraint();
    }

    @Override
    public LevelRule getSignedFilesPresentConstraint() {
        return this.validationPolicy.getSignedFilesPresentConstraint();
    }

    @Override
    public LevelRule getFilenameAdherenceConstraint() {
        return this.validationPolicy.getFilenameAdherenceConstraint();
    }

    @Override
    public LevelRule getAllFilesSignedConstraint() {
        return this.validationPolicy.getAllFilesSignedConstraint();
    }

    @Override
    public LevelRule getFullScopeConstraint() {
        return this.validationPolicy.getFullScopeConstraint();
    }

    @Override
    public MultiValuesRule getAcceptablePDFAProfilesConstraint() {
        return this.validationPolicy.getAcceptablePDFAProfilesConstraint();
    }

    @Override
    public LevelRule getPDFACompliantConstraint() {
        return this.validationPolicy.getPDFACompliantConstraint();
    }

    @Override
    public boolean isEIDASConstraintPresent() {
        return this.validationPolicy.isEIDASConstraintPresent();
    }

    @Override
    public DurationRule getTLFreshnessConstraint() {
        return this.validationPolicy.getTLFreshnessConstraint();
    }

    @Override
    public LevelRule getTLWellSignedConstraint() {
        return this.validationPolicy.getTLWellSignedConstraint();
    }

    @Override
    public LevelRule getTLNotExpiredConstraint() {
        return this.validationPolicy.getTLNotExpiredConstraint();
    }

    @Override
    public MultiValuesRule getTLVersionConstraint() {
        return this.validationPolicy.getTLVersionConstraint();
    }

    @Override
    public LevelRule getTLStructureConstraint() {
        return this.validationPolicy.getTLStructureConstraint();
    }

    @Override
    public ValidationModel getValidationModel() {
        return this.validationPolicy.getValidationModel();
    }

    public String toString() {
        return "ValidationPolicyWithCryptographicSuite [validationPolicyName=" + this.validationPolicy.getPolicyName() + ", cryptographicSuitesNames=" + this.cryptographicSuitesMap.values().stream().map(CryptographicSuite::getPolicyName).collect(Collectors.toList()) + ']';
    }
}

